/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.editor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.xtend.ide.editor.TypedRegionMerger;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;

public class RichStringAwareSourceViewer
extends XtextSourceViewer {
    private static Logger log = Logger.getLogger(RichStringAwareSourceViewer.class);
    private TypedRegionMerger merger;

    public RichStringAwareSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
    }

    protected void shift(boolean useDefaultPrefixes, boolean right, boolean ignoreWhitespace) {
        block29: {
            if (useDefaultPrefixes && ignoreWhitespace) {
                if (this.fUndoManager != null) {
                    this.fUndoManager.beginCompoundChange();
                }
                IDocument d = this.getDocument();
                Map partitioners = null;
                DocumentRewriteSession rewriteSession = null;
                try {
                    try {
                        ITextSelection selection = (ITextSelection)this.getSelection();
                        IRegion block = this.copiedGetTextBlockFromSelection(selection);
                        ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)d, (String)this.getDocumentPartitioning(), (int)block.getOffset(), (int)block.getLength(), (boolean)false);
                        regions = this.merger.merge(regions);
                        int lineCount = 0;
                        int[] lines = new int[regions.length * 2];
                        int i = 0;
                        int j = 0;
                        while (i < regions.length) {
                            lines[j] = this.copiedGetFirstCompleteLineOfRegion((IRegion)regions[i]);
                            int length = regions[i].getLength();
                            int offset = regions[i].getOffset() + length;
                            if (length > 0) {
                                --offset;
                            }
                            lines[j + 1] = lines[j] == -1 ? -1 : d.getLineOfOffset(offset);
                            lineCount += lines[j + 1] - lines[j] + 1;
                            ++i;
                            j += 2;
                        }
                        if (d instanceof IDocumentExtension4) {
                            IDocumentExtension4 extension = (IDocumentExtension4)d;
                            rewriteSession = extension.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
                        } else {
                            this.setRedraw(false);
                            this.startSequentialRewriteMode(true);
                        }
                        if (lineCount >= 20) {
                            partitioners = TextUtilities.removeDocumentPartitioners((IDocument)d);
                        }
                        Map map = this.fDefaultPrefixChars;
                        int i2 = 0;
                        int j2 = 0;
                        while (i2 < regions.length) {
                            String[] prefixes = (String[])this.copiedSelectContentTypePlugin(regions[i2].getType(), map);
                            if (prefixes != null && prefixes.length > 0 && lines[j2] >= 0 && lines[j2 + 1] >= 0) {
                                if (right) {
                                    this.copiedShiftRight(lines[j2], lines[j2 + 1], prefixes[0]);
                                } else {
                                    this.copiedShiftLeft(lines[j2], lines[j2 + 1], prefixes, ignoreWhitespace);
                                }
                            }
                            ++i2;
                            j2 += 2;
                        }
                    }
                    catch (BadLocationException x) {
                        log.debug((Object)x.getMessage(), (Throwable)x);
                        if (partitioners != null) {
                            TextUtilities.addDocumentPartitioners((IDocument)d, partitioners);
                        }
                        if (d instanceof IDocumentExtension4) {
                            IDocumentExtension4 extension = (IDocumentExtension4)d;
                            extension.stopRewriteSession(rewriteSession);
                        } else {
                            this.stopSequentialRewriteMode();
                            this.setRedraw(true);
                        }
                        if (this.fUndoManager != null) {
                            this.fUndoManager.endCompoundChange();
                        }
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    if (partitioners != null) {
                        TextUtilities.addDocumentPartitioners((IDocument)d, partitioners);
                    }
                    if (d instanceof IDocumentExtension4) {
                        IDocumentExtension4 extension = (IDocumentExtension4)d;
                        extension.stopRewriteSession(rewriteSession);
                    } else {
                        this.stopSequentialRewriteMode();
                        this.setRedraw(true);
                    }
                    if (this.fUndoManager != null) {
                        this.fUndoManager.endCompoundChange();
                    }
                    throw throwable;
                }
                if (partitioners != null) {
                    TextUtilities.addDocumentPartitioners((IDocument)d, (Map)partitioners);
                }
                if (d instanceof IDocumentExtension4) {
                    IDocumentExtension4 extension = (IDocumentExtension4)d;
                    extension.stopRewriteSession(rewriteSession);
                } else {
                    this.stopSequentialRewriteMode();
                    this.setRedraw(true);
                }
                if (this.fUndoManager != null) {
                    this.fUndoManager.endCompoundChange();
                }
            } else {
                super.shift(useDefaultPrefixes, right, ignoreWhitespace);
            }
        }
    }

    private IRegion copiedGetTextBlockFromSelection(ITextSelection selection) {
        try {
            IDocument document = this.getDocument();
            int start = document.getLineOffset(selection.getStartLine());
            int endLine = selection.getEndLine();
            IRegion endLineInfo = document.getLineInformation(endLine);
            int end = endLineInfo.getOffset() + endLineInfo.getLength();
            return new Region(start, end - start);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private void copiedShiftRight(int startLine, int endLine, String prefix) {
        try {
            IDocument d = this.getDocument();
            while (startLine <= endLine) {
                d.replace(d.getLineOffset(startLine++), 0, prefix);
            }
        }
        catch (BadLocationException x) {
            log.debug((Object)x.getMessage(), (Throwable)x);
        }
    }

    private void copiedShiftLeft(int startLine, int endLine, String[] prefixes, boolean ignoreWhitespace) {
        IDocument d = this.getDocument();
        try {
            IRegion[] occurrences = new IRegion[endLine - startLine + 1];
            int i = 0;
            while (i < occurrences.length) {
                int length;
                IRegion line = d.getLineInformation(startLine + i);
                String text = d.get(line.getOffset(), line.getLength());
                int index = -1;
                int[] found = TextUtilities.indexOf((String[])prefixes, (String)text, (int)0);
                if (found[0] != -1) {
                    if (ignoreWhitespace) {
                        String s = d.get(line.getOffset(), found[0]);
                        if ((s = s.trim()).length() == 0) {
                            index = line.getOffset() + found[0];
                        }
                    } else if (found[0] == 0) {
                        index = line.getOffset();
                    }
                }
                if (index > -1) {
                    length = prefixes[found[1]].length();
                    if (length == 0 && !ignoreWhitespace && line.getLength() > 0) {
                        return;
                    }
                } else {
                    return;
                }
                occurrences[i] = new Region(index, length);
                ++i;
            }
            int decrement = 0;
            int i2 = 0;
            while (i2 < occurrences.length) {
                IRegion r = occurrences[i2];
                d.replace(r.getOffset() - decrement, r.getLength(), "");
                decrement += r.getLength();
                ++i2;
            }
        }
        catch (BadLocationException x) {
            log.debug((Object)x.getMessage(), (Throwable)x);
        }
    }

    private Object copiedSelectContentTypePlugin(String type, Map plugins) {
        if (plugins == null) {
            return null;
        }
        return plugins.get(type);
    }

    private int copiedGetFirstCompleteLineOfRegion(IRegion region) {
        try {
            IDocument d = this.getDocument();
            int startLine = d.getLineOfOffset(region.getOffset());
            int offset = d.getLineOffset(startLine);
            if (offset >= region.getOffset()) {
                return startLine;
            }
            offset = d.getLineOffset(startLine + 1);
            return offset > region.getOffset() + region.getLength() ? -1 : startLine + 1;
        }
        catch (BadLocationException x) {
            log.debug((Object)x.getMessage(), (Throwable)x);
            return -1;
        }
    }

    public void doOperation(int operation) {
        if (this.getTextWidget() == null || !this.redraws() && operation != 15) {
            return;
        }
        if (operation == 13) {
            this.fContentAssistant.showPossibleCompletions();
            this.fContentAssistant.showContextInformation();
        } else {
            super.doOperation(operation);
        }
    }

    @Singleton
    public static class Factory
    extends XtextSourceViewer.DefaultFactory {
        @Inject
        private TypedRegionMerger merger;

        public XtextSourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
            RichStringAwareSourceViewer result = new RichStringAwareSourceViewer(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
            result.merger = this.merger;
            return result;
        }
    }
}

