/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.GitTag;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.storage.CommitBlobStorage;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.storage.OpenWorkspaceVersionEnabled;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.ITag;

public class CommitFileRevision
extends GitFileRevision
implements OpenWorkspaceVersionEnabled {
    private final Repository db;
    private final RevCommit commit;
    private final PersonIdent author;
    private final String path;
    private ObjectId blobId;
    private DirCacheCheckout.CheckoutMetadata metadata;

    CommitFileRevision(Repository repo, RevCommit rc, String path) {
        this(repo, rc, path, null, null);
    }

    CommitFileRevision(Repository repo, RevCommit rc, String path, ObjectId blob, DirCacheCheckout.CheckoutMetadata metadata) {
        super(path);
        this.db = repo;
        this.commit = rc;
        this.author = rc.getAuthorIdent();
        this.path = path;
        this.blobId = blob;
        this.metadata = metadata;
    }

    @Override
    public Repository getRepository() {
        return this.db;
    }

    @Override
    public String getGitPath() {
        return this.path;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        if (this.blobId == null) {
            this.locateBlobObjectId();
        }
        return new CommitBlobStorage(this.db, this.path, this.blobId, this.commit, this.metadata);
    }

    public long getTimestamp() {
        return this.author != null ? this.author.getWhen().getTime() : 0L;
    }

    public String getContentIdentifier() {
        return this.commit.getId().name();
    }

    public String getAuthor() {
        return this.author != null ? this.author.getName() : null;
    }

    public String getComment() {
        return this.commit.getShortMessage();
    }

    public String toString() {
        return this.commit.getId() + ":" + this.path;
    }

    public ITag[] getTags() {
        ArrayList<GitTag> ret = new ArrayList<GitTag>();
        for (Map.Entry tag : this.db.getTags().entrySet()) {
            Ref ref = this.db.peel((Ref)tag.getValue());
            ObjectId refId = ref.getPeeledObjectId();
            if (refId == null) {
                refId = ref.getObjectId();
            }
            if (!AnyObjectId.equals((AnyObjectId)refId, (AnyObjectId)this.commit)) continue;
            ret.add(new GitTag((String)tag.getKey()));
        }
        return ret.toArray(new ITag[ret.size()]);
    }

    public RevCommit getRevCommit() {
        return this.commit;
    }

    private void locateBlobObjectId() throws CoreException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (TreeWalk w = TreeWalk.forPath((Repository)this.db, (String)this.path, (RevTree)this.commit.getTree());){
                if (w == null) {
                    throw new CoreException(Activator.error(NLS.bind((String)CoreText.CommitFileRevision_pathNotIn, (Object)this.commit.getId().name(), (Object)this.path), null));
                }
                this.blobId = w.getObjectId(0);
                CoreConfig.EolStreamType eolStreamType = w.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP);
                String filterCommand = w.getFilterCommand("smudge");
                this.metadata = new DirCacheCheckout.CheckoutMetadata(eolStreamType, filterCommand);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Activator.error(NLS.bind((String)CoreText.CommitFileRevision_errorLookingUpPath, (Object)this.commit.getId().name(), (Object)this.path), e));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.author == null ? 0 : this.author.hashCode());
        result = 31 * result + (this.blobId == null ? 0 : this.blobId.hashCode());
        result = 31 * result + (this.commit == null ? 0 : this.commit.hashCode());
        result = 31 * result + (this.db == null ? 0 : this.db.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommitFileRevision other = (CommitFileRevision)obj;
        if (this.author == null ? other.author != null : !this.author.equals((Object)other.author)) {
            return false;
        }
        if (this.blobId == null ? other.blobId != null : !this.blobId.equals((AnyObjectId)other.blobId)) {
            return false;
        }
        if (this.commit == null ? other.commit != null : !this.commit.equals((AnyObjectId)other.commit)) {
            return false;
        }
        if (this.db == null ? other.db != null : !this.db.equals(other.db)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

