/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class Divide
extends AbstractTool {
    public Divide() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to divide", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The resulting PDF", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Divide", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Divide OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file2 = (File)this.getValue("destfile");
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            int n = pdfReader.getNumberOfPages();
            System.out.println("There are " + n + " pages in the original file.");
            Rectangle rectangle = pdfReader.getPageSize(1);
            Rectangle rectangle2 = new Rectangle(rectangle.getWidth() / 2.0f, rectangle.getHeight());
            Document document = new Document(rectangle2, 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file2));
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            for (int i = 0; i < n; ++i) {
                int n2 = i + 1;
                rectangle = pdfReader.getPageSize(n2);
                rectangle2 = new Rectangle(rectangle.getWidth() / 2.0f, rectangle.getHeight());
                document.newPage();
                float f = 0.0f;
                float f2 = 0.0f;
                PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(pdfReader, n2);
                pdfContentByte.addTemplate(pdfImportedPage, 1.0f, 0.0f, 0.0f, 1.0f, f, f2);
                document.newPage();
                f = -rectangle2.getWidth();
                f2 = 0.0f;
                pdfImportedPage = pdfWriter.getImportedPage(pdfReader, n2);
                pdfContentByte.addTemplate(pdfImportedPage, 1.0f, 0.0f, 0.0f, 1.0f, f, f2);
            }
            document.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void valueHasChanged(AbstractArgument abstractArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Divide divide = new Divide();
        if (stringArray.length < 2) {
            System.err.println(divide.getUsage());
        }
        divide.setMainArguments(stringArray);
        divide.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        Divide.addVersion("$Id: Divide.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

