/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.framework;

import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.MockitoSession;
import org.mockito.exceptions.misusing.RedundantListenerException;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.junit.TestFinishedEvent;
import org.mockito.internal.junit.UniversalTestListener;
import org.mockito.internal.util.MockitoLogger;
import org.mockito.quality.Strictness;

public class DefaultMockitoSession
implements MockitoSession {
    private final Object testClassInstance;
    private final UniversalTestListener listener;

    public DefaultMockitoSession(Object testClassInstance, Strictness strictness, MockitoLogger logger) {
        this.testClassInstance = testClassInstance;
        this.listener = new UniversalTestListener(strictness, logger);
        try {
            Mockito.framework().addListener(this.listener);
        }
        catch (RedundantListenerException e) {
            Reporter.unfinishedMockingSession();
        }
        MockitoAnnotations.initMocks(testClassInstance);
    }

    @Override
    public void finishMocking() {
        Mockito.framework().removeListener(this.listener);
        this.listener.testFinished(new TestFinishedEvent(){

            @Override
            public Throwable getFailure() {
                return null;
            }

            @Override
            public Object getTestClassInstance() {
                return DefaultMockitoSession.this.testClassInstance;
            }

            @Override
            public String getTestMethodName() {
                return null;
            }
        });
        Mockito.validateMockitoUsage();
    }
}

