/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.commands;

import org.eclipse.dltk.dbgp.DbgpBaseCommands;
import org.eclipse.dltk.dbgp.DbgpRequest;
import org.eclipse.dltk.dbgp.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.commands.IDbgpStreamCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlParser;

public class DbgpStreamCommands
extends DbgpBaseCommands
implements IDbgpStreamCommands {
    private static final String STDERR_COMMAND = "stderr";
    private static final String STDOUT_COMMAND = "stdout";

    protected boolean execCommand(String command, int value) throws DbgpException {
        DbgpRequest request = DbgpStreamCommands.createRequest(command);
        request.addOption("-c", value);
        return DbgpXmlParser.parseSuccess(this.communicate(request));
    }

    public DbgpStreamCommands(IDbgpCommunicator communicator) {
        super(communicator);
    }

    @Override
    public boolean configureStdout(int value) throws DbgpException {
        return this.execCommand(STDOUT_COMMAND, value);
    }

    @Override
    public boolean configureStderr(int value) throws DbgpException {
        return this.execCommand(STDERR_COMMAND, value);
    }
}

