/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.AbstractTabbarContribution;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.MenuContributionItemArmListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class AbstractMenuContributionItem
extends AbstractTabbarContribution {
    public static final String TOOLTIP = "Tooltip";
    protected MenuManager menuManager;
    private MenuContributionItemArmListener listener;
    private List<String> tooltips = new ArrayList<String>();

    protected AbstractMenuContributionItem() {
    }

    protected AbstractMenuContributionItem(String id) {
        super(id);
    }

    @Override
    public void create(ToolBarManager tb, String groupId) {
        tb.insertAfter(groupId, (IContributionItem)this.createContributionItem(tb));
    }

    public ContributionItem createContributionItem(ToolBarManager tb) {
        return new TabbarContributionItem(tb);
    }

    protected abstract Image getMenuImage();

    protected abstract String getLabel();

    protected abstract void menuShow(IMenuManager var1);

    private void showMenu(Control control, int offset) {
        EObject diagram;
        Diagram gmfDiagram = this.part.getDiagram();
        if (gmfDiagram != null && (diagram = gmfDiagram.getElement()) instanceof DDiagram) {
            this.setDiagram((DDiagram)diagram);
            final Menu menu = this.getMenuManager().createContextMenu(control);
            final MenuContributionItemArmListener oldListener = this.listener;
            this.listener = new MenuContributionItemArmListener(control);
            menu.addListener(22, new Listener(){

                public void handleEvent(Event event) {
                    Iterator<String> it = AbstractMenuContributionItem.this.tooltips.iterator();
                    MenuItem[] menuItemArray = menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem item = menuItemArray[n2];
                        if (oldListener != null) {
                            item.removeArmListener((ArmListener)oldListener);
                        }
                        item.addArmListener((ArmListener)AbstractMenuContributionItem.this.listener);
                        if (it.hasNext()) {
                            item.setData(AbstractMenuContributionItem.TOOLTIP, (Object)it.next());
                        }
                        ++n2;
                    }
                }
            });
            menu.setLocation(control.toDisplay(0 + offset, control.getSize().y));
            menu.setVisible(true);
        }
    }

    private MenuManager getMenuManager() {
        if (this.menuManager != null) {
            return this.menuManager;
        }
        this.menuManager = new MenuManager(null, this.getId());
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToHide(IMenuManager manager) {
            }

            public void menuAboutToShow(IMenuManager manager) {
                AbstractMenuContributionItem.this.tooltips.clear();
                AbstractMenuContributionItem.this.menuShow(manager);
            }
        });
        return this.menuManager;
    }

    protected void addTooltip(String tooltip) {
        this.tooltips.add(tooltip);
    }

    protected void doDispose() {
        this.dispose();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.menuManager != null) {
            this.menuManager.dispose();
            this.menuManager = null;
        }
        this.tooltips = null;
        this.listener = null;
    }

    private class TabbarContributionItem
    extends ContributionItem {
        private ToolItem menuItem;
        private ToolBarManager toolBarManager;

        TabbarContributionItem(ToolBarManager tb) {
            this.toolBarManager = tb;
        }

        public void fill(final ToolBar parent, final int index) {
            this.menuItem = new ToolItem(parent, 4, index);
            this.menuItem.setToolTipText(AbstractMenuContributionItem.this.getLabel());
            this.computeEnable();
            this.menuItem.setImage(AbstractMenuContributionItem.this.getMenuImage());
            this.menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int offset = this.computeOffset(parent);
                    AbstractMenuContributionItem.this.showMenu((Control)TabbarContributionItem.this.toolBarManager.getControl(), offset);
                }

                private int computeOffset(ToolBar tb) {
                    int offset = 0;
                    int i = 0;
                    while (i < index) {
                        offset += tb.getItem(i).getWidth();
                        ++i;
                    }
                    return offset;
                }
            });
        }

        private void computeEnable() {
            if (AbstractMenuContributionItem.this.part instanceof DDiagramEditor && ((DDiagramEditor)AbstractMenuContributionItem.this.part).getRepresentation() instanceof DDiagram) {
                boolean canEditInstance = true;
                DDiagramEditor editor = (DDiagramEditor)AbstractMenuContributionItem.this.part;
                DDiagram editorDiagram = (DDiagram)editor.getRepresentation();
                IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(editor.getSession().getSessionResource().getResourceSet());
                canEditInstance = permissionAuthority.canEditInstance((EObject)editorDiagram);
                this.menuItem.setEnabled(canEditInstance);
            }
        }

        public void dispose() {
            AbstractMenuContributionItem.this.doDispose();
            if (this.menuItem != null) {
                this.menuItem.dispose();
                this.menuItem = null;
            }
            this.toolBarManager = null;
            super.dispose();
        }

        public void update() {
            super.update();
            if (this.menuItem != null && !this.menuItem.isDisposed()) {
                this.menuItem.setImage(AbstractMenuContributionItem.this.getMenuImage());
                this.computeEnable();
            }
        }
    }
}

