/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.model.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.model.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.view.LayoutData;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusViewProvider;
import org.eclipse.sirius.diagram.ui.internal.refresh.CanonicalElementAdapter;
import org.eclipse.sirius.diagram.ui.internal.refresh.CanonicalSynchronizerResult;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.IsOrphanedSwitch;
import org.eclipse.sirius.diagram.ui.internal.refresh.NodePositionHelper;
import org.eclipse.sirius.diagram.ui.internal.view.factories.AbstractContainerViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.ViewSizeHint;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramUpdater;
import org.eclipse.sirius.diagram.ui.part.SiriusNodeDescriptor;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.ext.base.Option;

public abstract class AbstractCanonicalSynchronizer
implements CanonicalSynchronizer {
    private static final boolean STANDARD_LAYOUT_FOR_CREATED_REGION_CONTENT = Boolean.getBoolean("org.eclipse.sirius.diagram.ui.internal.region.content.canonical.layout.standard");
    private static final Dimension NO_CHANGE_SIZE = new Dimension(-1, -1);
    protected boolean storeViews2Arrange = true;
    protected IViewProvider viewpointViewProvider = new SiriusViewProvider();
    protected Map<View, Boolean> regionsContainersToLayoutWithImpactStatus = new HashMap<View, Boolean>();
    private boolean snapToGrid;
    private int gridSpacing = 0;

    public void storeViewsToArrange(boolean storeViewsToArrange) {
        this.storeViews2Arrange = storeViewsToArrange;
    }

    protected void refreshSemantic(View view, CanonicalSynchronizerResult canonicalSynchronizerResult) {
        this.refreshSemanticChildren(view, ViewUtil.resolveSemanticElement((View)view), canonicalSynchronizerResult);
        for (View childView : Iterables.filter((Iterable)view.getChildren(), View.class)) {
            if (canonicalSynchronizerResult.getOrphanNodes().contains(childView)) continue;
            this.refreshSemantic(childView, canonicalSynchronizerResult);
        }
    }

    protected void refreshSemanticChildren(View gmfView, EObject semanticView, CanonicalSynchronizerResult canonicalSynchronizerResult) {
        Set<View> createdViews;
        ArrayList<SiriusNodeDescriptor> semanticChildren;
        List<View> viewChildren;
        List<View> orphan;
        int type;
        if (semanticView == null) {
            return;
        }
        boolean isPartOfRegionsContainer = semanticView instanceof DNodeContainer && new DNodeContainerExperimentalQuery((DNodeContainer)semanticView).isRegionContainer();
        boolean isRegionsContainer = false;
        if (isPartOfRegionsContainer && ((type = SiriusVisualIDRegistry.getVisualID(gmfView.getType())) == 2002 || type == 3008)) {
            isRegionsContainer = true;
            this.regionsContainersToLayoutWithImpactStatus.put(gmfView, Boolean.FALSE);
        }
        if (!(orphan = this.cleanCanonicalSemanticChildren(gmfView, viewChildren = this.getViewChildren(gmfView), semanticChildren = new ArrayList<SiriusNodeDescriptor>(SiriusDiagramUpdater.getSemanticChildren(gmfView)))).isEmpty()) {
            canonicalSynchronizerResult.addOrphanNodes(orphan);
            this.setRegionsContainerAsImpacted(gmfView, isRegionsContainer, isPartOfRegionsContainer);
        }
        if (!(createdViews = this.createViews(semanticChildren, gmfView.getType(), gmfView)).isEmpty()) {
            canonicalSynchronizerResult.addCreatedNodes(createdViews);
            this.setRegionsContainerAsImpacted(gmfView, isRegionsContainer, isPartOfRegionsContainer);
        }
        if (semanticView instanceof DNodeList || isPartOfRegionsContainer) {
            this.refreshSemanticChildrenOrdering(gmfView);
        }
    }

    protected boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    protected void setSnapToGrid(boolean snapToGrid) {
        this.snapToGrid = snapToGrid;
    }

    protected int getGridSpacing() {
        return this.gridSpacing;
    }

    protected void setGridSpacing(int gridSpacing) {
        this.gridSpacing = gridSpacing;
    }

    private void setRegionsContainerAsImpacted(View gmfView, boolean isRegionsContainer, boolean isPartOfRegionsContainer) {
        Option<View> realRegionsContainer;
        if (isRegionsContainer) {
            this.regionsContainersToLayoutWithImpactStatus.put(gmfView, Boolean.TRUE);
        } else if (isPartOfRegionsContainer && (realRegionsContainer = new ViewQuery(gmfView).getAncestor(2002, 3008)).some()) {
            this.regionsContainersToLayoutWithImpactStatus.put((View)realRegionsContainer.get(), Boolean.TRUE);
        }
    }

    private void markCreatedViewsAsToLayout(Collection<View> createdViews) {
        for (View createdView : createdViews) {
            createdView.eAdapters().add((Object)SiriusLayoutDataManager.INSTANCE.getAdapterMarker());
        }
    }

    protected boolean createdViewIsMarkedAsToLayout(View createdView) {
        return createdView.eAdapters().contains((Object)SiriusLayoutDataManager.INSTANCE.getAdapterMarker());
    }

    private void markCreatedViewsAsToLayoutBorderNode(Collection<View> createdViews) {
        for (View createdView : createdViews) {
            createdView.eAdapters().add((Object)SiriusLayoutDataManager.INSTANCE.getBorderNodeMarker());
        }
    }

    private void markCreatedViewsWithCenterLayout(Collection<View> createdViews) {
        for (View createdView : createdViews) {
            createdView.eAdapters().add((Object)SiriusLayoutDataManager.INSTANCE.getCenterAdapterMarker());
        }
    }

    protected boolean createdViewIsMarkedAsToCenterLayout(View createdView) {
        return createdView.eAdapters().contains((Object)SiriusLayoutDataManager.INSTANCE.getCenterAdapterMarker());
    }

    private void markCreatedViewsAsReferenceLayout(Set<View> createdViews) {
        for (View createdView : createdViews) {
            createdView.eAdapters().add((Object)SiriusLayoutDataManager.INSTANCE.getReferenceAdapterMarker());
        }
    }

    protected boolean createdViewIsMarkedAsReferenceLayout(View createdView) {
        return createdView.eAdapters().contains((Object)SiriusLayoutDataManager.INSTANCE.getReferenceAdapterMarker());
    }

    private boolean refreshSemanticChildrenOrdering(View hostView) {
        boolean moveOccur = false;
        HashMap<EObject, View> semantic2ViewMap = new HashMap<EObject, View>();
        List<View> views = this.getViewChildren(hostView);
        ArrayList<SiriusNodeDescriptor> semanticChildren = new ArrayList<SiriusNodeDescriptor>(SiriusDiagramUpdater.getSemanticChildren(hostView));
        int i = 0;
        while (i < semanticChildren.size()) {
            SiriusNodeDescriptor viewpointNodeDescriptor = (SiriusNodeDescriptor)semanticChildren.get(i);
            EObject modelElement = viewpointNodeDescriptor.getModelElement();
            View view = null;
            if (semantic2ViewMap.containsKey(modelElement)) {
                view = (View)semantic2ViewMap.get(modelElement);
            } else {
                view = this.getView(views, modelElement);
                if (view != null) {
                    semantic2ViewMap.put(modelElement, view);
                }
            }
            if (view != null && hostView.getPersistedChildren().indexOf((Object)view) != i) {
                hostView.getPersistedChildren().move(i, (Object)view);
                moveOccur = true;
            }
            ++i;
        }
        return moveOccur;
    }

    private View getView(List<View> views, EObject modelElement) {
        for (View view : views) {
            if (!modelElement.equals(view.getElement())) continue;
            return view;
        }
        return null;
    }

    private List<View> getViewChildren(View current) {
        return current.getChildren();
    }

    protected Set<View> createViews(List<SiriusNodeDescriptor> eObjects, String factoryHint, View host) {
        ArrayList<CreateViewRequest.ViewDescriptor> descriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        for (SiriusNodeDescriptor nodeDescriptor : eObjects) {
            EObject element = nodeDescriptor.getModelElement();
            if (element == null) continue;
            CreateViewRequest.ViewDescriptor descriptor = this.getViewDescriptor(element, nodeDescriptor.getType());
            descriptors.add(descriptor);
        }
        LinkedHashSet<View> createdViews = new LinkedHashSet<View>();
        LinkedHashSet<View> createdViewsToLayout = new LinkedHashSet<View>();
        LinkedHashSet<View> createdCenteredViewsToLayout = new LinkedHashSet<View>();
        LinkedHashSet<View> createdBorderedViewsToLayout = new LinkedHashSet<View>();
        LinkedHashSet<View> createdLayoutRefernceViews = new LinkedHashSet<View>();
        for (CreateViewRequest.ViewDescriptor viewDescriptor : descriptors) {
            Class viewKind = viewDescriptor.getViewKind();
            IAdaptable semanticAdapter = viewDescriptor.getElementAdapter();
            View containerView = host;
            String semanticHint = viewDescriptor.getSemanticHint();
            int index = viewDescriptor.getIndex();
            boolean persisted = viewDescriptor.isPersisted();
            PreferencesHint preferencesHint = viewDescriptor.getPreferencesHint();
            Diagram createdView = null;
            if (viewKind == Diagram.class) {
                createdView = this.viewpointViewProvider.createDiagram(semanticAdapter, semanticHint, preferencesHint);
            } else if (viewKind == Edge.class) {
                createdView = this.viewpointViewProvider.createEdge(semanticAdapter, containerView, semanticHint, index, persisted, preferencesHint);
            } else if (viewKind == Node.class) {
                createdView = this.viewpointViewProvider.createNode(semanticAdapter, containerView, semanticHint, index, persisted, preferencesHint);
            }
            if (createdView == null) continue;
            createdViews.add((View)createdView);
            LayoutDataResult layoutDataResult = this.updateLocationAndSize((View)createdView);
            if (layoutDataResult.isAlreadylayouted && viewKind == Node.class) {
                this.removeJustCreatedMarker((View)createdView);
            }
            if (layoutDataResult.normalLayout) {
                createdViewsToLayout.add((View)createdView);
            }
            if (layoutDataResult.centerLayout) {
                createdCenteredViewsToLayout.add((View)createdView);
            }
            if (layoutDataResult.borderLayout) {
                createdBorderedViewsToLayout.add((View)createdView);
            }
            if (layoutDataResult.isLayoutReference) {
                createdLayoutRefernceViews.add((View)createdView);
            }
            if (!(createdView instanceof Node)) continue;
            for (Object view : createdView.getPersistedChildren()) {
                if (!(view instanceof View) || !new ViewQuery((View)view).isForNameEditPartOnBorder()) continue;
                LayoutDataResult layoutNameDataResult = this.updateLocationAndSize((View)view);
                if (layoutNameDataResult.centerLayout) {
                    createdCenteredViewsToLayout.add((View)createdView);
                }
                if (!layoutNameDataResult.borderLayout) continue;
                createdBorderedViewsToLayout.add((View)createdView);
            }
        }
        if (this.storeViews2Arrange) {
            this.markCreatedViewsAsToLayout(createdViewsToLayout);
            this.markCreatedViewsWithCenterLayout(createdCenteredViewsToLayout);
            this.markCreatedViewsAsToLayoutBorderNode(createdBorderedViewsToLayout);
            this.markCreatedViewsAsReferenceLayout(createdLayoutRefernceViews);
        }
        return createdViews;
    }

    private void removeJustCreatedMarker(View createdView) {
        LinkedHashSet adapters = Sets.newLinkedHashSet((Iterable)createdView.eAdapters());
        Iterator iterator = adapters.iterator();
        ArrayList<Adapter> adaptersToRemove = new ArrayList<Adapter>();
        while (iterator.hasNext()) {
            Adapter adapter = (Adapter)iterator.next();
            if (!adapter.isAdapterForType(AbstractContainerViewFactory.class)) continue;
            adaptersToRemove.add(adapter);
        }
        for (Adapter adapterToRemove : adaptersToRemove) {
            createdView.eAdapters().remove((Object)adapterToRemove);
        }
    }

    private LayoutDataResult updateLocationAndSize(View createdView) {
        EObject element = createdView.getElement();
        LayoutDataResult updateLocationAndSize = NodePositionHelper.isBorderedNode(element) || new ViewQuery(createdView).isForNameEditPartOnBorder() ? this.updateAbstractDNode_ownedBorderedNodes_Bounds(createdView) : (NodePositionHelper.isTopLevelNode(element) ? this.updateDDiagramChildBounds(createdView) : (NodePositionHelper.isInsideNodeContainer(element) ? this.updateDNodeContainerChildButNotBorderedNodeBounds(createdView) : new LayoutDataResult(true, false, false, false, false)));
        return updateLocationAndSize;
    }

    private LayoutDataResult updateDDiagramChildBounds(View createdView) {
        Node createdNode;
        Dimension size = null;
        Point location = null;
        boolean normalLayout = true;
        boolean centerLayout = false;
        boolean borderLayout = false;
        boolean isAlreadyLayouted = false;
        boolean isLayoutReference = false;
        EObject element = createdView.getElement();
        AbstractDNode abstractDNode = null;
        if (element instanceof AbstractDNode) {
            abstractDNode = (AbstractDNode)element;
            LayoutData layoutData = SiriusLayoutDataManager.INSTANCE.getData(abstractDNode);
            if (layoutData == null) {
                layoutData = SiriusLayoutDataManager.INSTANCE.getData(abstractDNode, true);
            }
            if (layoutData != null) {
                size = layoutData.getSize();
                location = layoutData.getLocation();
                isLayoutReference = location != null;
            }
            borderLayout = !abstractDNode.getOwnedBorderedNodes().isEmpty();
        } else {
            size = ViewSizeHint.getInstance().consumeSize();
        }
        if (createdView instanceof Node && (createdNode = (Node)createdView).getLayoutConstraint() instanceof Bounds) {
            normalLayout = false;
            isAlreadyLayouted = true;
            centerLayout = location == null;
            this.updateBoundsConstraint(createdNode, location, size);
        }
        return new LayoutDataResult(normalLayout, centerLayout, borderLayout, isAlreadyLayouted, isLayoutReference);
    }

    private LayoutDataResult updateAbstractDNode_ownedBorderedNodes_Bounds(View createdView) {
        Node createdNode = (Node)createdView;
        AbstractDNode portNode = (AbstractDNode)createdView.getElement();
        LayoutData layoutData = SiriusLayoutDataManager.INSTANCE.getData(portNode);
        boolean laidOut = false;
        if (layoutData == null) {
            layoutData = SiriusLayoutDataManager.INSTANCE.getData(portNode, true);
            Dimension size = null;
            Point contextLocation = null;
            if (layoutData != null) {
                laidOut = true;
                contextLocation = layoutData.getLocation();
                size = layoutData.getSize();
            } else {
                Optional<Rectangle> optionalRect;
                size = ViewSizeHint.getInstance().consumeSize();
                if (size == null && new ViewQuery(createdView).isForNameEditPart() && (optionalRect = GMFHelper.getAbsoluteBounds(createdView)).isPresent()) {
                    size = optionalRect.get().getSize();
                }
            }
            Point location = new NodePositionHelper(this.isSnapToGrid(), this.getGridSpacing()).getOnBorderPositionFromParent(createdNode, contextLocation, size);
            laidOut = laidOut || createdNode.getLayoutConstraint() instanceof Location;
            this.updateBoundsConstraint(createdNode, location, size != null ? size : NO_CHANGE_SIZE);
        } else {
            laidOut = true;
            Point location = new NodePositionHelper(this.isSnapToGrid(), this.getGridSpacing()).getOnBorderPositionFromLayoutData(createdNode, layoutData);
            this.updateBoundsConstraint(createdNode, location, layoutData.getSize());
        }
        return new LayoutDataResult(!laidOut, false, false, laidOut, false);
    }

    private LayoutDataResult updateDNodeContainerChildButNotBorderedNodeBounds(View createdView) {
        EObject element = createdView.getElement();
        EObject parent = element.eContainer();
        boolean normalLayout = true;
        boolean centerLayout = false;
        boolean borderLayout = false;
        boolean isAlreadylayouted = false;
        boolean isLayoutReference = false;
        if (element instanceof AbstractDNode) {
            AbstractDNode abstractDNode = (AbstractDNode)element;
            if (parent instanceof DNodeContainer) {
                DNodeContainer nodeContainer = (DNodeContainer)parent;
                Dimension size = null;
                Point location = null;
                LayoutData layoutData = SiriusLayoutDataManager.INSTANCE.getData(abstractDNode);
                if (layoutData == null) {
                    layoutData = SiriusLayoutDataManager.INSTANCE.getData(abstractDNode, true);
                }
                if (layoutData != null) {
                    location = layoutData.getLocation();
                    size = layoutData.getSize();
                    normalLayout = false;
                    isAlreadylayouted = true;
                    isLayoutReference = true;
                }
                if (location == null && !this.isInForcedLayout(createdView, nodeContainer)) {
                    normalLayout = false;
                    centerLayout = true;
                    isAlreadylayouted = true;
                }
                if (!abstractDNode.getOwnedBorderedNodes().isEmpty()) {
                    borderLayout = true;
                }
                if (createdView instanceof Node) {
                    Node createdNode = (Node)createdView;
                    this.updateBoundsConstraint(createdNode, location, size);
                }
            }
        }
        return new LayoutDataResult(normalLayout, centerLayout, borderLayout, isAlreadylayouted, isLayoutReference);
    }

    private boolean isInForcedLayout(View createdView, DNodeContainer nodeContainer) {
        boolean skip = false;
        if (STANDARD_LAYOUT_FOR_CREATED_REGION_CONTENT && new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)nodeContainer).isRegion()) {
            EObject dnodeContainer2_3008 = createdView.eContainer();
            dnodeContainer2_3008 = dnodeContainer2_3008 != null ? dnodeContainer2_3008.eContainer() : null;
            boolean bl = skip = dnodeContainer2_3008 != null && (dnodeContainer2_3008.eAdapters().contains((Object)SiriusLayoutDataManager.INSTANCE.getCenterAdapterMarker()) || dnodeContainer2_3008.eAdapters().contains((Object)SiriusLayoutDataManager.INSTANCE.getAdapterMarker()));
        }
        return skip || new DNodeContainerExperimentalQuery(nodeContainer).isRegionContainer();
    }

    protected void updateLocationConstraint(Location constraint, Point location) {
        if (location != null) {
            constraint.setX(location.x);
            constraint.setY(location.y);
        }
    }

    protected void updateSizeConstraint(Node createdNode, Size constraint, Dimension size) {
        boolean collapsedSizeForced;
        Dimension safeSize = size != null ? size : NO_CHANGE_SIZE;
        Dimension defaultSize = new NodePositionHelper(this.isSnapToGrid(), this.getGridSpacing()).getAdjustedDimension(createdNode, constraint);
        boolean bl = collapsedSizeForced = new NodeQuery(createdNode).isCollapsed() && size != null;
        if (collapsedSizeForced || NodePositionHelper.canResizeWidth(createdNode)) {
            constraint.setWidth(safeSize.width != -1 ? safeSize.width : defaultSize.width);
        }
        if (collapsedSizeForced || NodePositionHelper.canResizeHeight(createdNode)) {
            constraint.setHeight(safeSize.height != -1 ? safeSize.height : defaultSize.height);
        }
    }

    private void updateBoundsConstraint(Node createdNode, Point location, Dimension size) {
        LayoutConstraint constraint = createdNode.getLayoutConstraint();
        if (constraint instanceof Location) {
            Location locationConstraint = (Location)constraint;
            this.updateLocationConstraint(locationConstraint, location);
        }
        if (constraint instanceof Size) {
            Size sizeConstraint = (Size)constraint;
            this.updateSizeConstraint(createdNode, sizeConstraint, size);
        }
    }

    protected CreateViewRequest getCreateViewRequest(List<? extends CreateViewRequest.ViewDescriptor> descriptors) {
        return new CreateViewRequest(descriptors);
    }

    protected CreateViewRequest.ViewDescriptor getViewDescriptor(EObject element, String factoryHint) {
        CanonicalElementAdapter elementAdapter = new CanonicalElementAdapter(element, factoryHint);
        CreateViewRequest.ViewDescriptor descriptor = this.getViewDescriptor((IAdaptable)elementAdapter, Node.class, factoryHint, -1);
        return descriptor;
    }

    protected CreateViewRequest.ViewDescriptor getViewDescriptor(IAdaptable elementAdapter, Class<?> viewKind, String hint, int index) {
        return new CreateViewRequest.ViewDescriptor(elementAdapter, viewKind, hint, index, true, DiagramUIPlugin.DIAGRAM_PREFERENCES_HINT);
    }

    private List<View> cleanCanonicalSemanticChildren(View currentView, Collection<View> viewChildren, Collection<SiriusNodeDescriptor> semanticChildren) {
        Iterator<View> viewChildrenIT = viewChildren.iterator();
        ArrayList<View> orphan = new ArrayList<View>();
        HashMap<EObject, View> viewToSemanticMap = new HashMap<EObject, View>();
        HashMap<EObject, SiriusNodeDescriptor> semanticToObjectInMap = new HashMap<EObject, SiriusNodeDescriptor>();
        HashSet<EObject> realSemanticChilren = new HashSet<EObject>();
        for (SiriusNodeDescriptor object : semanticChildren) {
            realSemanticChilren.add(object.getModelElement());
            semanticToObjectInMap.put(object.getModelElement(), object);
        }
        while (viewChildrenIT.hasNext()) {
            View viewChild = viewChildrenIT.next();
            EObject semanticChild = viewChild.getElement();
            if (!new IsOrphanedSwitch(viewChild, realSemanticChilren, currentView).doSwitch(SiriusVisualIDRegistry.getVisualID(currentView)).booleanValue()) {
                semanticChildren.remove(semanticToObjectInMap.get(semanticChild));
                viewToSemanticMap.put(semanticChild, viewChild);
            } else {
                orphan.add(viewChild);
            }
            View viewInMap = (View)viewToSemanticMap.get(semanticChild);
            if (viewInMap == null || viewChild.equals(viewInMap) || !viewInMap.isMutable()) continue;
            orphan.remove(viewChild);
            orphan.add(viewInMap);
            viewToSemanticMap.put(semanticChild, viewChild);
        }
        return orphan;
    }

    private record LayoutDataResult(boolean normalLayout, boolean centerLayout, boolean borderLayout, boolean isAlreadylayouted, boolean isLayoutReference) {
    }
}

