/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.properties;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.common.tools.api.util.TreeItemWrapper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.viewpoint.description.AbstractMappingImport;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public abstract class AbstractMappingImportSelectionWizardBuilder {
    protected AbstractNodeMapping currentMapping;
    private Collection<AbstractNodeMapping> importers;
    private Collection<Viewpoint> availableViewpoints;

    public AbstractMappingImportSelectionWizardBuilder(AbstractNodeMapping nodeMapping, Collection<Viewpoint> availableViewpoints) {
        this.currentMapping = nodeMapping;
        this.availableViewpoints = availableViewpoints;
    }

    public TreeItemWrapper buildMappingInput() {
        this.buildMappingImporters();
        TreeItemWrapper root = new TreeItemWrapper(null, null);
        for (Viewpoint viewpoint : this.availableViewpoints) {
            this.addSiriusItems(viewpoint, root);
        }
        return root;
    }

    private void buildMappingImporters() {
        this.importers = new HashSet<AbstractNodeMapping>();
        this.importers.add(this.currentMapping);
        for (Viewpoint viewpoint : ViewpointRegistry.getInstance().getViewpoints()) {
            for (RepresentationDescription representationDescription : new ViewpointQuery(viewpoint).getAllRepresentationDescriptions()) {
                if (!(representationDescription instanceof DiagramDescription)) continue;
                DiagramDescription desc = (DiagramDescription)representationDescription;
                for (AbstractNodeMapping mapping : this.getAllMappings(desc)) {
                    if (!this.checkImportType(mapping)) continue;
                    this.addMappingImporters((AbstractMappingImport)mapping);
                }
            }
        }
    }

    private void addMappingImporters(AbstractMappingImport mappingImport) {
        AbstractNodeMapping importedMapping = this.getImportedMapping(mappingImport);
        if (this.isANodeMappingImporters(importedMapping)) {
            this.importers.add((AbstractNodeMapping)mappingImport);
        }
        if (this.checkImportType(importedMapping)) {
            this.addMappingImporters((AbstractMappingImport)importedMapping);
        }
    }

    private boolean isANodeMappingImporters(AbstractNodeMapping importedMapping) {
        return this.checkImportType(importedMapping) || EqualityHelper.contains(this.importers, (EObject)importedMapping);
    }

    private void addSiriusItems(Viewpoint viewpoint, TreeItemWrapper root) {
        TreeItemWrapper viewpointItem = new TreeItemWrapper((Object)viewpoint, root);
        for (RepresentationDescription represenationDescription : new ViewpointQuery(viewpoint).getAllRepresentationDescriptions()) {
            if (!(represenationDescription instanceof DiagramDescription)) continue;
            this.addDiagramDescriptionItems((DiagramDescription)represenationDescription, viewpointItem);
        }
        if (!viewpointItem.getChildren().isEmpty()) {
            root.getChildren().add(viewpointItem);
        }
    }

    private void addDiagramDescriptionItems(DiagramDescription diagramDescription, TreeItemWrapper viewpointItem) {
        TreeItemWrapper diagramDescriptionItem = new TreeItemWrapper((Object)diagramDescription, viewpointItem);
        this.addMappingItems(diagramDescription, diagramDescriptionItem);
        if (!diagramDescriptionItem.getChildren().isEmpty()) {
            viewpointItem.getChildren().add(diagramDescriptionItem);
        }
    }

    protected void addMappingItems(DiagramDescription diagramDescription, TreeItemWrapper diagramDescriptionItem) {
        for (AbstractNodeMapping mapping : this.getAllMappings(diagramDescription)) {
            if (EcoreUtil.equals((EObject)this.currentMapping, (EObject)mapping) || !this.safeMappingCandidate(mapping)) continue;
            TreeItemWrapper mappingItem = new TreeItemWrapper((Object)mapping, diagramDescriptionItem);
            diagramDescriptionItem.getChildren().add(mappingItem);
        }
        this.addMappings(diagramDescriptionItem, diagramDescription);
    }

    protected boolean safeMappingCandidate(AbstractNodeMapping mapping) {
        if (mapping instanceof AbstractMappingImport) {
            AbstractMappingImport mappingImport = (AbstractMappingImport)mapping;
            AbstractNodeMapping importedMapping = this.getImportedMapping(mappingImport);
            return !EqualityHelper.contains(this.importers, (EObject)importedMapping);
        }
        return true;
    }

    protected abstract boolean checkImportType(AbstractNodeMapping var1);

    protected abstract AbstractNodeMapping getImportedMapping(AbstractMappingImport var1);

    protected abstract <T extends AbstractNodeMapping> Collection<T> getAllMappings(DiagramDescription var1);

    protected abstract void addMappings(TreeItemWrapper var1, DiagramDescription var2);
}

