/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.internal.xpath.helper;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rap.e4.apache.jxpath.Container;
import org.eclipse.rap.e4.apache.jxpath.JXPathException;
import org.eclipse.rap.e4.apache.jxpath.util.TypeUtils;

public class ValueUtils {
    public static Object getValue(EObject bean, EStructuralFeature pd) {
        return bean.eGet(pd);
    }

    public static boolean isCollection(Object value) {
        if ((value = ValueUtils.getValue(value)) == null) {
            return false;
        }
        if (value.getClass().isArray()) {
            return true;
        }
        return value instanceof Collection;
    }

    public static Object getValue(Object object) {
        while (object instanceof Container) {
            object = ((Container)object).getValue();
        }
        return object;
    }

    public static int getLength(Object collection) {
        if (collection == null) {
            return 0;
        }
        if ((collection = ValueUtils.getValue(collection)).getClass().isArray()) {
            return Array.getLength(collection);
        }
        if (collection instanceof Collection) {
            return ((Collection)collection).size();
        }
        return 1;
    }

    public static Object remove(Object collection, int index) {
        if ((collection = ValueUtils.getValue(collection)) == null) {
            return null;
        }
        if (index >= ValueUtils.getLength(collection)) {
            throw new JXPathException("No such element at index " + index);
        }
        if (collection.getClass().isArray()) {
            int length = Array.getLength(collection);
            Object smaller = Array.newInstance(collection.getClass().getComponentType(), length - 1);
            if (index > 0) {
                System.arraycopy(collection, 0, smaller, 0, index);
            }
            if (index < length - 1) {
                System.arraycopy(collection, index + 1, smaller, index, length - index - 1);
            }
            return smaller;
        }
        if (collection instanceof List) {
            int size = ((List)collection).size();
            if (index < size) {
                ((List)collection).remove(index);
            }
            return collection;
        }
        if (collection instanceof Collection) {
            Iterator it = ((Collection)collection).iterator();
            int i = 0;
            while (i < index) {
                if (!it.hasNext()) break;
                it.next();
                ++i;
            }
            if (it.hasNext()) {
                it.next();
                it.remove();
            }
            return collection;
        }
        throw new JXPathException("Cannot remove " + collection.getClass().getName() + "[" + index + "]");
    }

    public static Object getValue(EObject bean, EStructuralFeature pd, int index) {
        if (pd.isMany()) {
            try {
                return ((List)bean.eGet(pd)).get(index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
            catch (Throwable ex) {
                throw new JXPathException("Cannot access property: " + pd.getName(), ex);
            }
        }
        return ValueUtils.getValue(ValueUtils.getValue(bean, pd), index);
    }

    public static Object getValue(Object collection, int index) {
        Object value = collection = ValueUtils.getValue(collection);
        if (collection != null) {
            if (collection.getClass().isArray()) {
                if (index < 0 || index >= Array.getLength(collection)) {
                    return null;
                }
                value = Array.get(collection, index);
            } else if (collection instanceof List) {
                if (index < 0 || index >= ((List)collection).size()) {
                    return null;
                }
                value = ((List)collection).get(index);
            } else if (collection instanceof Collection) {
                int i = 0;
                Iterator it = ((Collection)collection).iterator();
                while (i < index) {
                    it.next();
                    ++i;
                }
                value = it.hasNext() ? it.next() : null;
            }
        }
        return value;
    }

    public static int getCollectionHint(Class<?> clazz) {
        if (clazz.isArray()) {
            return 1;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (clazz.isPrimitive()) {
            return -1;
        }
        if (clazz.isInterface()) {
            return 0;
        }
        if (Modifier.isFinal(clazz.getModifiers())) {
            return -1;
        }
        return 0;
    }

    public static void setValue(EObject bean, EStructuralFeature pd, Object value) {
        try {
            if (pd.isMany()) {
                List l = (List)bean.eGet(pd);
                l.clear();
                l.addAll((Collection)value);
            } else {
                bean.eSet(pd, value);
            }
        }
        catch (Exception ex) {
            throw new JXPathException("Cannot modify property: " + (bean == null ? "null" : bean.getClass().getName()) + "." + pd.getName(), ex);
        }
    }

    public static void setValue(EObject bean, EStructuralFeature pd, int index, Object value) {
        Object collection;
        if (pd.isMany()) {
            try {
                List l = (List)bean.eGet(pd);
                l.set(index, ValueUtils.convert(value, pd.getEType().getInstanceClass()));
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot access property: " + pd.getName() + ", " + ex.getMessage());
            }
        }
        if (ValueUtils.isCollection(collection = ValueUtils.getValue(bean, pd))) {
            ValueUtils.setValue(collection, index, value);
        } else if (index == 0) {
            ValueUtils.setValue(bean, pd, value);
        } else {
            throw new RuntimeException("Not a collection: " + pd.getName());
        }
    }

    public static void setValue(Object collection, int index, Object value) {
        if ((collection = ValueUtils.getValue(collection)) != null) {
            if (collection.getClass().isArray()) {
                Array.set(collection, index, ValueUtils.convert(value, collection.getClass().getComponentType()));
            } else if (collection instanceof List) {
                ((List)collection).set(index, value);
            } else if (collection instanceof Collection) {
                throw new UnsupportedOperationException("Cannot set value of an element of a " + collection.getClass().getName());
            }
        }
    }

    private static Object convert(Object value, Class<?> type) {
        try {
            return TypeUtils.convert(value, type);
        }
        catch (Exception ex) {
            throw new JXPathException("Cannot convert value of class " + (value == null ? "null" : value.getClass().getName()) + " to type " + String.valueOf(type), ex);
        }
    }

    public static Object expandCollection(Object collection, int size) {
        if (collection == null) {
            return null;
        }
        if (size < ValueUtils.getLength(collection)) {
            throw new JXPathException("adjustment of " + String.valueOf(collection) + " to size " + size + " is not an expansion");
        }
        if (collection.getClass().isArray()) {
            Object bigger = Array.newInstance(collection.getClass().getComponentType(), size);
            System.arraycopy(collection, 0, bigger, 0, Array.getLength(collection));
            return bigger;
        }
        if (collection instanceof Collection) {
            Collection c = (Collection)collection;
            while (c.size() < size) {
                c.add(null);
            }
            return collection;
        }
        throw new JXPathException("Cannot turn " + collection.getClass().getName() + " into a collection of size " + size);
    }
}

