/*
 * Copyright (c) 2011, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Denise Smith - February 25, 2013
package org.eclipse.persistence.testing.jaxb.interfaces.choice;

import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;

@XmlRootElement(name = "ListmyObject", namespace = "someNamespace")
@XmlType(name = "ListmyObject", namespace = "someNamespace")
@XmlAccessorType(XmlAccessType.FIELD)
public class Root {

    /*
     * customer is using a List and specifies the Interface ImyObject that just contains
     * getters and setters
     */
    @XmlElements(value = { @XmlElement(name = "myObject", type = MyObject.class), @XmlElement(name = "otherObject", type = MyOtherObject.class) })
    protected List<MyInterface> myList = new ArrayList<MyInterface>();

    public List<MyInterface> getMyList() {
        return myList;
    }

    public void setMyList(List<MyInterface> m_listMyObject) {
        this.myList = m_listMyObject;
    }

    public boolean equals(Object obj){
        if(obj instanceof Root){
            Root compare = (Root)obj;
            return myList.equals(compare.myList);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return myList != null ? myList.hashCode() : 0;
    }
}
