/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class InvalidIdentityMapTest
extends ExceptionTest {
    ClassDescriptor descriptor;
    Class<? extends IdentityMap> orgIdentityMapClass;
    IntegrityChecker orgIntegrityChecker;

    public InvalidIdentityMapTest() {
        this.setDescription("This tests Invalid Identity Map (TL-ERROR 38)");
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.expectedException = DescriptorException.invalidIdentityMap(null, null);
        this.descriptor = this.getSession().getDescriptor(Employee.class);
        this.orgIdentityMapClass = this.descriptor.getIdentityMapClass();
        this.descriptor.setIdentityMapClass(null);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
    }

    @Override
    public void reset() {
        this.descriptor.setIdentityMapClass(this.orgIdentityMapClass);
        this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
    }

    public void test() {
        try {
            IdentityMapManager identityMapManager = new IdentityMapManager((AbstractSession)this.getSession());
            identityMapManager.buildNewIdentityMap(this.getSession().getDescriptor(Employee.class));
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }
}

