/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.changeflag;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.collections.Menu;
import org.eclipse.persistence.testing.models.collections.Restaurant;

public class TransparentMapTest
extends AutoVerifyTestCase {
    public Menu transfer;
    public Menu transfer2;
    public Restaurant clone;
    public Restaurant clone2;
    public Object licenceKey;
    public Boolean licenceValue;
    public String licenceType;

    public TransparentMapTest() {
        this.setDescription("This test verifies that Tranparent Map works with change tracking");
    }

    public void reset() {
        if (this.getAbstractSession().isInTransaction()) {
            this.getAbstractSession().rollbackTransaction();
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        }
    }

    public void setup() {
        if (this.getSession() instanceof RemoteSession) {
            throw new TestWarningException("This test cannot be run through the remote.");
        }
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        Map.Entry object;
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.clone = (Restaurant)uow.readObject(Restaurant.class, new ExpressionBuilder().get("name").equal((Object)"Chez Abuse"));
        this.clone2 = (Restaurant)uow.readObject(Restaurant.class, new ExpressionBuilder().get("name").equal((Object)"Pedro's"));
        Set set = this.clone.getMenus().entrySet();
        Map.Entry entry = object = set.iterator().next();
        this.transfer = (Menu)this.clone.getMenus().values().iterator().next();
        this.transfer2 = (Menu)this.clone2.getMenus().values().iterator().next();
        Menu menu1 = this.transfer;
        Menu menu2 = this.transfer2;
        this.transfer = new Menu("LateAfternoon");
        this.transfer.setItems(menu1.getItems());
        this.transfer2 = new Menu("EarlyMorning");
        this.transfer2.setItems(menu2.getItems());
        this.clone2.removeMenu(menu2);
        HashMap<String, Menu> menues = new HashMap<String, Menu>(this.clone2.getMenus());
        menues.put(this.transfer.getKey(), this.transfer);
        this.transfer.setOwner(this.clone2);
        this.clone.removeMenu(menu1);
        this.clone.addMenu(this.transfer2);
        this.clone2.setMenus(menues);
        this.licenceKey = "Smoking License";
        this.clone.getLicenses().remove(this.licenceKey);
        this.clone.getLicenses().put("Site Licence", Boolean.TRUE);
        this.licenceType = "Alcohol License";
        this.licenceValue = (Boolean)this.clone.getLicenses().get(this.licenceType);
        this.clone.getLicenses().put(this.licenceType, this.licenceValue == false);
        uow.commit();
    }

    public void verify() {
        Restaurant cachedRestaurant = (Restaurant)this.getSession().readObject((Object)this.clone);
        Restaurant cachedRestaurant2 = (Restaurant)this.getSession().readObject((Object)this.clone2);
        Menu cachedTransfer = (Menu)this.getSession().readObject((Object)this.transfer);
        Menu cachedTransfer2 = (Menu)this.getSession().readObject((Object)this.transfer2);
        if (cachedRestaurant.getMenus().containsKey(cachedTransfer.getKey())) {
            throw new TestErrorException("Failed to track changes to Map without indirection");
        }
        if (!cachedRestaurant2.getMenus().containsKey(cachedTransfer.getKey())) {
            throw new TestErrorException("Failed to track changes when new entire map set without indirection");
        }
        if (cachedRestaurant2.getMenus().containsKey(cachedTransfer2.getKey())) {
            throw new TestErrorException("Failed to track changes when new entire map set without indirection");
        }
        if (!cachedRestaurant.getMenus().containsKey(cachedTransfer2.getKey())) {
            throw new TestErrorException("Failed to merge changes to Map with no indirection");
        }
        if (this.clone.getLicenses().containsKey(this.licenceKey)) {
            throw new TestErrorException("Failed to track remove from Indirect Map");
        }
        if (!this.clone.getLicenses().containsKey("Site Licence")) {
            throw new TestErrorException("Failed to track add to Indirect Map");
        }
        if (this.clone.getLicenses().get(this.licenceType).equals(this.licenceValue)) {
            throw new TestErrorException("Failed to track change to value of Indirect Map");
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        cachedRestaurant = (Restaurant)this.getSession().readObject((Object)this.clone);
        cachedRestaurant2 = (Restaurant)this.getSession().readObject((Object)this.clone2);
        cachedTransfer = (Menu)this.getSession().readObject((Object)this.transfer);
        cachedTransfer2 = (Menu)this.getSession().readObject((Object)this.transfer2);
        if (cachedRestaurant.getMenus().containsKey(cachedTransfer.getKey())) {
            throw new TestErrorException("Failed to track changes to Map without indirection on database");
        }
        if (!cachedRestaurant2.getMenus().containsKey(cachedTransfer.getKey())) {
            throw new TestErrorException("Failed to track changes when new entire map set without indirection on database");
        }
        if (cachedRestaurant2.getMenus().containsKey(cachedTransfer2.getKey())) {
            throw new TestErrorException("Failed to track changes when new entire map set without indirection on database");
        }
        if (!cachedRestaurant.getMenus().containsKey(cachedTransfer2.getKey())) {
            throw new TestErrorException("Failed to merge changes to Map with no indirection on database");
        }
        if (this.clone.getLicenses().containsKey(this.licenceKey)) {
            throw new TestErrorException("Failed to track remove from Indirect Map on database");
        }
        if (!this.clone.getLicenses().containsKey("Site Licence")) {
            throw new TestErrorException("Failed to track add to Indirect Map on database");
        }
        if (this.clone.getLicenses().get(this.licenceType).equals(this.licenceValue)) {
            throw new TestErrorException("Failed to track change to value of Indirect Map on database");
        }
    }
}

