/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.math.BigDecimal;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.unitofwork.Person;

public class WasTransactionBegunPrematurelyRollbackTest
extends AutoVerifyTestCase {
    protected BigDecimal id;
    protected Exception exception;
    protected boolean usesBatchWriting;
    protected boolean usesJDBCBatchWriting;

    public WasTransactionBegunPrematurelyRollbackTest() {
        this.setDescription("Failure during commit of prematurely started transaction should cause the right exception");
    }

    public void setup() {
        this.usesBatchWriting = this.getSession().getLogin().shouldUseBatchWriting();
        if (!this.usesBatchWriting) {
            this.getSession().getLogin().setUsesBatchWriting(true);
        }
        this.usesJDBCBatchWriting = this.getSession().getLogin().shouldUseJDBCBatchWriting();
        if (this.usesJDBCBatchWriting) {
            this.getSession().getLogin().setUsesJDBCBatchWriting(false);
        }
        if (this.getSession().getPlatform().getDefaultSequence().shouldAcquireValueAfterInsert()) {
            throw new TestWarningException("This test doesn't work with 'after-insert' native sequencing");
        }
        Person person = (Person)this.getSession().readObject(Person.class);
        if (person == null) {
            throw new TestProblemException("Failed to read a Person object");
        }
        this.id = person.id;
        this.exception = null;
    }

    public void test() {
        Person person = new Person();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Person clonePerson = (Person)uow.registerObject((Object)person);
        clonePerson.id = this.id;
        this.getAbstractSession().beginTransaction();
        ((UnitOfWorkImpl)uow).setWasTransactionBegunPrematurely(true);
        try {
            uow.commit();
        }
        catch (Exception ex) {
            this.exception = ex;
        }
    }

    public void verify() {
        if (this.exception == null) {
            throw new TestErrorException("No exception is thrown");
        }
        try {
            DatabaseException dbEx = (DatabaseException)((Object)this.exception);
            if (dbEx.getErrorCode() == 4002) {
                this.exception = null;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (this.exception != null) {
            throw new TestErrorException("Wrong exception: " + this.exception.getMessage());
        }
    }

    public void reset() {
        if (!this.usesBatchWriting) {
            this.getSession().getLogin().setUsesBatchWriting(false);
        }
        if (this.usesJDBCBatchWriting) {
            this.getSession().getLogin().setUsesJDBCBatchWriting(true);
        }
    }
}

