/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkEventTest;

public class PrepareUnitOfWorkTest
extends UnitOfWorkEventTest {
    @Override
    public void setup() {
        super.setup();
        this.setDescription("Test the prepareUnitOfWork Event");
        SessionEventAdapter tvAdapter = new SessionEventAdapter(){

            public void prepareUnitOfWork(SessionEvent event) {
                PrepareUnitOfWorkTest.this.setEventTriggered(true);
            }
        };
        this.getSession().getEventManager().addListener((SessionEventListener)tvAdapter);
    }

    public void test() {
        UnitOfWork tvUnitOfWork = this.getSession().acquireUnitOfWork();
        Employee employee = (Employee)tvUnitOfWork.readObject(Employee.class);
        employee.setFirstName(employee.getFirstName() + "modified");
        tvUnitOfWork.commit();
    }

    public void verify() {
        if (this.getSession().isRemoteSession()) {
            throw new TestWarningException("This feature is not supported at remoteSession");
        }
        if (!this.isEventTriggered()) {
            throw new TestErrorException("The prepareUnitOfWork event was not triggered.");
        }
    }
}

