/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.types;

import java.util.UUID;
import java.util.Vector;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.tests.types.TypeTester;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class UUIDTester
extends TypeTester {
    private static final String UUID_TEST_VALUE = "4ae8976b-635f-46dc-937a-6016db49bd96";
    public UUID uuidValue;

    public UUIDTester() {
        this(UUID.fromString(UUID_TEST_VALUE));
    }

    public UUIDTester(UUID testValue) {
        super("uuidTest");
        this.uuidValue = testValue;
    }

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(UUIDTester.class);
        descriptor.setTableName("UUIDS");
        descriptor.setPrimaryKeyFieldName("NAME");
        descriptor.addDirectMapping("testName", "getTestName", "setTestName", "NAME");
        descriptor.addDirectMapping("uuidValue", "UUIDV");
        return descriptor;
    }

    public static RelationalDescriptor descriptorWithAccessors() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(UUIDTester.class);
        descriptor.setTableName("UUIDS");
        descriptor.setPrimaryKeyFieldName("NAME");
        try {
            descriptor.addDirectMapping("testName", "getTestName", "setTestName", "NAME");
            descriptor.addDirectMapping("uuidValue", "getUuidValue", "setUuidValue", "UUIDV");
        }
        catch (DescriptorException descriptorException) {
            // empty catch block
        }
        return descriptor;
    }

    public UUID getUuidValue() {
        return this.uuidValue;
    }

    public void setUuidValue(UUID uuidValue) {
        this.uuidValue = uuidValue;
    }

    public static TableDefinition tableDefinition(Session session) {
        TableDefinition definition = TypeTester.tableDefinition();
        definition.setName("UUIDS");
        FieldDefinition fieldDef = new FieldDefinition("UUIDV", String.class, 50);
        fieldDef.setShouldAllowNull(false);
        definition.addField(fieldDef);
        return definition;
    }

    public static Vector testInstances() {
        Vector<UUIDTester> tests = new Vector<UUIDTester>(1);
        tests.addElement(new UUIDTester(UUID.fromString(UUID_TEST_VALUE)));
        return tests;
    }

    public String toString() {
        return "UUIDTester(" + this.getUuidValue() + ")";
    }
}

