/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.relationshipmaintenance;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.relationshipmaintenance.Dept;
import org.eclipse.persistence.testing.models.relationshipmaintenance.Emp;

public class UnitOfWorkRevertAndResumeTestDuplicates
extends AutoVerifyTestCase {
    protected int initialSize = 0;

    public UnitOfWorkRevertAndResumeTestDuplicates() {
        this.setDescription("This test checks for duplicates in a collection when a unitofwork is reverted");
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.beginTransaction();
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Vector allDepts = uow.readAllObjects(Dept.class);
        Dept cloneDept = (Dept)allDepts.get(0);
        this.initialSize = cloneDept.getEmpCollection().size();
        Dept deptToEdit = (Dept)allDepts.get(0);
        Iterator empIter = deptToEdit.getEmpCollection().iterator();
        empIter.next();
        Emp empToEdit = (Emp)empIter.next();
        empToEdit.setEname("whatever");
        uow.revertAndResume();
        Vector allDeptsAgain = uow.readAllObjects(Dept.class);
        cloneDept = (Dept)allDepts.get(0);
        if (cloneDept.getEmpCollection().size() != this.initialSize) {
            throw new TestErrorException("Revert cause duplicates to be entered in relationship maintenanced collection");
        }
    }
}

