/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.readonly;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.readonly.Actor;
import org.eclipse.persistence.testing.models.readonly.Charity;
import org.eclipse.persistence.testing.models.readonly.HollywoodAgent;
import org.eclipse.persistence.testing.models.readonly.ReadOnlyCharity;
import org.eclipse.persistence.testing.models.readonly.ReadOnlyHollywoodAgent;

public class WriteableMappingReadOnlyClassTest
extends TransactionalTestCase {
    protected UnitOfWork uow;
    protected Actor actorClone;

    protected void setup() {
        super.setup();
        this.getSession().getDescriptor(ReadOnlyCharity.class).setShouldBeReadOnly(true);
        this.getSession().getDescriptor(ReadOnlyHollywoodAgent.class).setShouldBeReadOnly(true);
    }

    protected void test() {
        Vector charities = this.getSession().readAllObjects(Charity.class);
        HollywoodAgent hollywoodAgent = (HollywoodAgent)this.getSession().readObject(HollywoodAgent.class);
        this.uow = this.getSession().acquireUnitOfWork();
        Actor actor = new Actor();
        Enumeration enumtr = charities.elements();
        while (enumtr.hasMoreElements()) {
            Charity charity = (Charity)enumtr.nextElement();
            ReadOnlyCharity readOnlyCharity = new ReadOnlyCharity();
            readOnlyCharity.id = charity.id;
            readOnlyCharity.setName(charity.getName());
            actor.addCharity(readOnlyCharity);
        }
        ReadOnlyHollywoodAgent readOnlyHollywoodAgent = new ReadOnlyHollywoodAgent();
        readOnlyHollywoodAgent.id = hollywoodAgent.id;
        readOnlyHollywoodAgent.setName(hollywoodAgent.getName());
        actor.setHollywoodAgent(readOnlyHollywoodAgent);
        this.setActorClone((Actor)this.uow.registerObject((Object)actor));
        this.uow.commit();
    }

    protected void verify() {
        try {
            this.uow = this.getSession().acquireUnitOfWork();
            Actor actorClone = this.getActorClone();
            actorClone.getCharities().removeAllElements();
            actorClone.setHollywoodAgent(null);
            Actor original = (Actor)this.uow.readObject((Object)actorClone);
            Actor sessionOriginal = (Actor)this.getSession().readObject((Object)actorClone);
            actorClone = (Actor)this.uow.deepMergeClone((Object)actorClone);
            this.uow.commit();
        }
        catch (Exception e) {
            throw new TestErrorException("The original commit corrupted the session cache.", (Throwable)e);
        }
        Actor verification = (Actor)this.getSession().readObject((Object)this.actorClone);
        if (verification.getHollywoodAgent() != null || verification.getCharities().size() != 0) {
            throw new TestErrorException("An exception was not thrown but the updates did not work.");
        }
    }

    public void reset() {
        super.reset();
    }

    protected Actor getActorClone() {
        return this.actorClone;
    }

    protected void setActorClone(Actor actorClone) {
        this.actorClone = actorClone;
    }
}

