/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.OrderingTest;

public class OrderingWithAnyOfTest
extends OrderingTest {
    @Override
    protected void setup() {
        this.customSQLRows = this.getSession().executeSelectingCall((Call)new SQLCall("SELECT DISTINCT t3.*, t1.* FROM ADDRESS t3, SALARY t2, EMPLOYEE t1, PHONE t0 WHERE ((((t0.AREA_CODE = '613') AND (t1.EMP_ID = t2.EMP_ID)) AND (t0.EMP_ID = t1.EMP_ID)) AND (t3.ADDRESS_ID = t1.ADDR_ID)) ORDER BY t3.CITY DESC , t1.F_NAME"));
    }

    @Override
    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        query.setSelectionCriteria(builder.anyOf("phoneNumbers").get("areaCode").equal((Object)"613"));
        query.addOrdering(builder.get("address").get("city").descending());
        query.addOrdering(builder.get("firstName"));
        this.orderedQueryObjects = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
    }

    @Override
    protected void verify() {
        for (int i = 0; i < this.orderedQueryObjects.size(); ++i) {
            DataRecord row = (DataRecord)this.customSQLRows.elementAt(i);
            Employee employee = (Employee)this.orderedQueryObjects.elementAt(i);
            String city = (String)row.get((Object)"CITY");
            String name = (String)row.get((Object)"F_NAME");
            if (employee.getAddress().getCity().equals(city) && employee.getFirstName().equals(name)) continue;
            throw new TestErrorException("The ordering test failed.  The results are not in the right order");
        }
    }
}

