/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.tests.queries.MultiNameQueriesTestCase;

public class NamedQueriesDescriptorQueryManagerTest
extends MultiNameQueriesTestCase {
    protected Server serverSession;
    protected ClientSession clientSession;
    protected Exception caughtException;
    protected ClassDescriptor descriptor;

    public NamedQueriesDescriptorQueryManagerTest() {
        this.setDescription("Verifies if a Named Query with different argument sets can be cached on DescriptorQueryManager");
    }

    public void reset() {
        this.descriptor.getQueryManager().removeQuery("namedQuerySameName");
        this.clientSession.release();
        this.serverSession.logout();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        EmployeeProject proj = new EmployeeProject();
        proj.setDatasourceLogin(this.getSession().getDatasourceLogin().clone());
        this.serverSession = proj.createServerSession(1, 1);
        this.serverSession.useReadConnectionPool(1, 1);
        this.serverSession.setSessionLog(this.getSession().getSessionLog());
        this.serverSession.login();
        this.clientSession = this.serverSession.acquireClientSession();
        this.setDescriptorNamedQueries(Employee.class);
        this.addNamedQueryFirstName();
        this.addNamedQueryFirstAndLastName();
        this.serverSession.getIdentityMapAccessor().initializeIdentityMaps();
    }

    public ClassDescriptor getDescriptorNamedQueries() {
        return this.descriptor;
    }

    public void setDescriptorNamedQueries(Class<?> cls) {
        this.descriptor = this.serverSession.getClassDescriptor(cls);
    }

    public void useNamedQueryFirstName() {
        Vector empsByFirstName = (Vector)this.clientSession.executeQuery("namedQuerySameName", Employee.class, (Object)new String("Jill"));
    }

    public void useNamedQueryFirstAndLastName() {
        Vector empsByFirstAndLastName = (Vector)this.clientSession.executeQuery("namedQuerySameName", Employee.class, (Object)new String("Jill"), (Object)new String("May"));
    }

    public void addNamedQueryFirstName() {
        this.descriptor.getQueryManager().addQuery("namedQuerySameName", (DatabaseQuery)this.getNamedQueryFirstName());
    }

    public void addNamedQueryFirstAndLastName() {
        this.descriptor.getQueryManager().addQuery("namedQuerySameName", (DatabaseQuery)this.getNamedQueryFirstAndLastName());
    }

    public void test() {
        try {
            this.useNamedQueryFirstName();
            this.useNamedQueryFirstAndLastName();
        }
        catch (ClassCastException e) {
            this.caughtException = e;
        }
    }

    public void verify() {
        if (this.caughtException != null) {
            throw new TestErrorException("Multiple queries with the same named cached on the DescriptorQueryManager.\nEach with different argument sets.\nThis exception thrown while testing test case.\n----- NamedQueriesDescriptorQueryManagerTest() -----\n");
        }
    }
}

