/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.math.BigDecimal;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class CursoredStreamWithUnitOfWorkTest
extends TestCase {
    public String firstName;
    public String lastName;
    public BigDecimal employeeId;

    public BigDecimal getEmployeeId() {
        return this.employeeId;
    }

    private String getFirstName() {
        return this.firstName;
    }

    private String getLastName() {
        return this.lastName;
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void setEmployeeId(BigDecimal newValue) {
        this.employeeId = newValue;
    }

    private void setFirstName(String newValue) {
        this.firstName = newValue;
    }

    private void setLastName(String newValue) {
        this.lastName = newValue;
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    private Employee swapNames(Employee employee) {
        String firstName = employee.getFirstName();
        String lastName = employee.getLastName();
        employee.setFirstName(lastName);
        employee.setLastName(firstName);
        return employee;
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.useCursoredStream(2, 1);
        CursoredStream stream = (CursoredStream)uow.executeQuery((DatabaseQuery)query);
        Employee employee = (Employee)stream.nextElement();
        this.setFirstName(employee.getFirstName());
        this.setLastName(employee.getLastName());
        this.setEmployeeId(employee.getId());
        employee = this.swapNames(employee);
        stream.close();
        uow.commit();
    }

    public void verify() {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("id").equal((Object)this.getEmployeeId());
        query.setSelectionCriteria(exp);
        query.dontMaintainCache();
        query.dontCheckCache();
        Employee newEmployee = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
        if (newEmployee.getFirstName().equals(this.getFirstName())) {
            throw new TestErrorException("first Name was not changed");
        }
        if (newEmployee.getLastName().equals(this.getLastName())) {
            throw new TestErrorException("last Name was not changed");
        }
    }
}

