/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.ownership;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.ownership.ObjectA;
import org.eclipse.persistence.testing.models.ownership.ObjectB;
import org.eclipse.persistence.testing.models.ownership.ObjectC;
import org.eclipse.persistence.testing.models.ownership.ObjectD;
import org.eclipse.persistence.testing.models.ownership.ObjectE;

public class UnitOfWorkTest
extends WriteObjectTest {
    public Object unitOfWorkWorkingCopy;
    public UnitOfWork unitOfWork;
    public UnitOfWork nestedUnitOfWork;

    public UnitOfWorkTest() {
    }

    public UnitOfWorkTest(Object originalObject) {
        super(originalObject);
    }

    public void changeObjectC(ObjectC objectC) {
        ObjectD objectD = (ObjectD)objectC.getOneToOne().getValue();
        Vector objectECollection = (Vector)objectD.getOneToMany().getValue();
        objectECollection.removeElement(objectECollection.firstElement());
        objectECollection.addElement(new ObjectE(objectD));
    }

    protected void changeUnitOfWorkWorkingCopy() {
        ObjectA objectA = (ObjectA)this.unitOfWorkWorkingCopy;
        ObjectB objectB = (ObjectB)objectA.getOneToOne().getValue();
        Vector objectCCollection = (Vector)objectB.getOneToMany().getValue();
        Enumeration enumtr = objectCCollection.elements();
        while (enumtr.hasMoreElements()) {
            ObjectC objectC = (ObjectC)enumtr.nextElement();
            this.changeObjectC(objectC);
        }
        objectCCollection.addElement(ObjectC.example4(objectB));
        objectCCollection.addElement(ObjectC.example5(objectB));
    }

    protected void setup() {
        super.setup();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.unitOfWorkWorkingCopy = this.unitOfWork.registerObject(this.objectToBeWritten);
    }

    protected void test() {
        this.changeUnitOfWorkWorkingCopy();
        if (!this.compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
        this.unitOfWork.commit();
    }

    protected void verify() {
        if (!this.compareObjects(this.unitOfWorkWorkingCopy, this.objectToBeWritten)) {
            throw new TestErrorException("The object in the unit of work has not been commited properly to its parent");
        }
        super.verify();
    }
}

