/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.mapping.Cubicle;
import org.eclipse.persistence.testing.models.mapping.EmergencyExit;

public class AddObjectNonPrimaryKeyManyToManyTest
extends AutoVerifyTestCase {
    public Cubicle cubicle;

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        if (this.getSession().getLogin().getPlatform().getDefaultSequence().shouldAcquireValueAfterInsert()) {
            throw new TestWarningException("This test doesn't work with 'after-insert' native sequencing");
        }
        this.beginTransaction();
    }

    public void test() {
        try {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            this.cubicle = (Cubicle)uow.readObject(Cubicle.class);
            this.cubicle.emergencyExits.add(EmergencyExit.example1());
            uow.commit();
        }
        catch (DatabaseException exception) {
            throw new TestErrorException("CR 3819, Sent Null to database when source foreign key for many to many is not a primary key " + exception.toString());
        }
    }

    public void verify() {
    }
}

