/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.expressions;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class LiteralSQLExpressionWithQuestionMarkTest
extends TestCase {
    protected Exception caughtException;
    protected Vector<ReportQueryResult> results;
    protected boolean useBinding;
    protected String literalString;

    public LiteralSQLExpressionWithQuestionMarkTest(String literalString, boolean useBinding) {
        this.literalString = literalString;
        this.useBinding = useBinding;
        this.setDescription("LiteralExpression Query with emp.firstName not equal " + literalString + " binding: " + useBinding);
    }

    public void test() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery query = new ReportQuery(Employee.class, builder);
        query.setShouldBindAllParameters(this.useBinding);
        query.setCacheUsage(0);
        query.addAttribute("id");
        query.addArgument("nameParameter", String.class);
        Expression expression = builder.get("firstName").notEqual(builder.literal(this.literalString));
        expression = expression.and(builder.get("lastName").equal(builder.getParameter("nameParameter")));
        expression = expression.and(builder.get("gender").notEqual(builder.literal("'?'")));
        query.setSelectionCriteria(expression);
        Vector<String> parameters = new Vector<String>();
        parameters.addElement("Smith");
        try {
            this.results = (Vector)this.getSession().executeQuery((DatabaseQuery)query, parameters);
        }
        catch (Exception ex) {
            this.caughtException = ex;
        }
    }

    public void verify() {
        if (this.caughtException != null) {
            throw new TestErrorException("Exception occurred executing ReportQuery with literal expression: " + this.literalString, (Throwable)this.caughtException);
        }
        if (this.results == null || this.results.isEmpty()) {
            throw new TestErrorException("Unexpected error - no ReportQuery results returned");
        }
    }
}

