/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.AggregateEntityMapHolder;
import org.eclipse.persistence.testing.models.collections.map.AggregateMapKey;
import org.eclipse.persistence.testing.models.collections.map.EntityMapValue;

public class TestUpdateKeyOnAggregateKeyCollectionTableMapping
extends TestCase {
    private AggregateEntityMapHolder holder = null;

    public void setup() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holder = new AggregateEntityMapHolder();
        EntityMapValue value = new EntityMapValue();
        value.setId(1);
        AggregateMapKey key = new AggregateMapKey();
        key.setKey(11);
        this.holder.addAggregateToEntityMapItem(key, value);
        EntityMapValue value2 = new EntityMapValue();
        value2.setId(2);
        key = new AggregateMapKey();
        key.setKey(22);
        this.holder.addAggregateToEntityMapItem(key, value2);
        uow.registerObject((Object)this.holder);
        uow.registerObject((Object)value);
        uow.registerObject((Object)value2);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holder = (AggregateEntityMapHolder)uow.readObject((Object)this.holder);
        for (AggregateMapKey key : this.holder.getAggregateToEntityMap().keySet()) {
            key.setKey(key.getKey() + 1);
        }
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.holder = (AggregateEntityMapHolder)this.getSession().readObject((Object)this.holder);
        if (this.holder == null) {
            throw new TestErrorException("AggregateKeyMapHolder could not be read.");
        }
        if (this.holder.getAggregateToEntityMap().size() != 2) {
            throw new TestErrorException("Incorrect Number of MapEntityValues was read.");
        }
        AggregateMapKey mapKey = new AggregateMapKey();
        mapKey.setKey(11);
        EntityMapValue value = (EntityMapValue)this.holder.getAggregateToEntityMap().get(mapKey);
        if (value != null) {
            throw new TestErrorException("EntityMapValue 11 not changed.");
        }
        mapKey = new AggregateMapKey();
        mapKey.setKey(12);
        value = (EntityMapValue)this.holder.getAggregateToEntityMap().get(mapKey);
        if (value == null) {
            throw new TestErrorException("EntityMapValue 11 not changed to 12.");
        }
        mapKey = new AggregateMapKey();
        mapKey.setKey(22);
        value = (EntityMapValue)this.holder.getAggregateToEntityMap().get(mapKey);
        if (value != null) {
            throw new TestErrorException("EntityMapValue 22 not changed.");
        }
        mapKey = new AggregateMapKey();
        mapKey.setKey(23);
        value = (EntityMapValue)this.holder.getAggregateToEntityMap().get(mapKey);
        if (value == null) {
            throw new TestErrorException("EntityMapValue 22 not changed to 23.");
        }
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject((Object)this.holder);
        Vector keys = uow.readAllObjects(EntityMapValue.class);
        uow.deleteAllObjects((Collection)keys);
        uow.commit();
    }
}

