/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.transparentindirection;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.transparentindirection.Player;
import org.eclipse.persistence.testing.models.transparentindirection.Team;

public class BidirectionalRelationshipProject
extends Project {
    public BidirectionalRelationshipProject(DatabaseSession session) {
        this.setName("BidirectionalRelationshipProject");
        this.applyLogin(session);
        this.addDescriptor((ClassDescriptor)this.buildTeamDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildPlayerDescriptor());
    }

    public void applyLogin(DatabaseSession session) {
        DatabaseLogin login = (DatabaseLogin)session.getLogin().clone();
        this.setLogin(login);
    }

    public RelationalDescriptor buildTeamDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Team.class);
        descriptor.addTableName("TEAM");
        descriptor.addPrimaryKeyFieldName("TEAM.ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("TEAM.ID");
        descriptor.setSequenceNumberName("team_seq");
        descriptor.setAlias("Team");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("m_id");
        idMapping.setFieldName("TEAM.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        OneToManyMapping onetomanymapping = new OneToManyMapping();
        onetomanymapping.setAttributeName("m_players");
        onetomanymapping.setReferenceClass(Player.class);
        onetomanymapping.useTransparentMap("getId");
        onetomanymapping.addTargetForeignKeyFieldName("PLAYER.TEAM_ID", "TEAM.ID");
        descriptor.addMapping((DatabaseMapping)onetomanymapping);
        return descriptor;
    }

    public RelationalDescriptor buildPlayerDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Player.class);
        descriptor.addTableName("PLAYER");
        descriptor.addPrimaryKeyFieldName("PLAYER.ID");
        descriptor.setAlias("Player");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("m_id");
        idMapping.setFieldName("PLAYER.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("m_team");
        onetoonemapping.setReferenceClass(Team.class);
        onetoonemapping.useBasicIndirection();
        onetoonemapping.addForeignKeyFieldName("PLAYER.TEAM_ID", "TEAM.ID");
        onetoonemapping.setRelationshipPartnerAttributeName("m_players");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        return descriptor;
    }
}

