/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.events;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.events.AboutToInsertProject;
import org.eclipse.persistence.testing.models.events.AboutToInsertProjectTableCreator;
import org.eclipse.persistence.testing.models.events.Address;
import org.eclipse.persistence.testing.models.events.AddressDescriptorEventListener;
import org.eclipse.persistence.testing.models.events.CreditCard;
import org.eclipse.persistence.testing.models.events.Customer;
import org.eclipse.persistence.testing.models.events.CustomerDescriptorEventListener;
import org.eclipse.persistence.testing.models.events.EmailAccount;
import org.eclipse.persistence.testing.models.events.Order;
import org.eclipse.persistence.testing.models.events.Phone;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class EventHookSystem
extends TestSystem {
    public static int POST_CALCULATE_UOW_CHANGE_SET = 0;

    public void addDescriptors(DatabaseSession session) {
        Vector<Object> descriptors = new Vector<Object>();
        descriptors.add(Order.descriptor());
        descriptors.add(CreditCard.descriptor());
        descriptors.add(this.getCustomerDescriptor());
        descriptors.add(this.getEmailAccountDescriptor());
        session.getEventManager().addListener((SessionEventListener)new SessionEventAdapter(){

            public void postCalculateUnitOfWorkChangeSet(SessionEvent event) {
                ++POST_CALCULATE_UOW_CHANGE_SET;
            }
        });
        descriptors.add(Phone.descriptor());
        descriptors.add(this.getAddressDescriptor());
        session.addDescriptors(descriptors);
        session.addDescriptors((Project)new AboutToInsertProject());
    }

    public void createTables(DatabaseSession session) {
        SchemaManager schemaManager = new SchemaManager(session);
        schemaManager.replaceObject((DatabaseObjectDefinition)Customer.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Customer.directCollectionTableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Order.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)EmailAccount.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Phone.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Address.tableDefinition());
        new AboutToInsertProjectTableCreator().replaceTables(session);
        schemaManager.createSequences();
    }

    public ClassDescriptor getAddressDescriptor() {
        RelationalDescriptor addressDescriptor = Address.descriptor();
        DescriptorEventManager eventManager = addressDescriptor.getDescriptorEventManager();
        eventManager.addListener((DescriptorEventListener)new AddressDescriptorEventListener());
        return addressDescriptor;
    }

    public ClassDescriptor getCustomerDescriptor() {
        RelationalDescriptor customerDescriptor = Customer.descriptor();
        customerDescriptor.getEventManager().addListener((DescriptorEventListener)new CustomerDescriptorEventListener());
        return customerDescriptor;
    }

    public ClassDescriptor getEmailAccountDescriptor() {
        RelationalDescriptor emailDescriptor = EmailAccount.descriptor();
        DescriptorEventManager eventManager = emailDescriptor.getDescriptorEventManager();
        eventManager.setPreInsertSelector("preInsertMethod");
        eventManager.setPostInsertSelector("postInsertMethod");
        eventManager.setPreDeleteSelector("preDeleteMethod");
        eventManager.setPostDeleteSelector("postDeleteMethod");
        eventManager.setPreUpdateSelector("preUpdateMethod");
        eventManager.setPostUpdateSelector("postUpdateMethod");
        eventManager.setPreWriteSelector("preWriteMethod");
        eventManager.setPostWriteSelector("postWriteMethod");
        eventManager.setPostBuildSelector("postBuildMethod");
        eventManager.setAboutToInsertSelector("aboutToInsertMethod");
        eventManager.setAboutToUpdateSelector("aboutToUpdateMethod");
        eventManager.setAboutToDeleteSelector("aboutToDeleteMethod");
        eventManager.setPostCloneSelector("postCloneMethod");
        eventManager.setPostMergeSelector("postMergeMethod");
        eventManager.setPostRefreshSelector("postRefreshMethod");
        return emailDescriptor;
    }

    public void populate(DatabaseSession session) {
    }
}

