/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.registry.ssl;

import oracle.kv.impl.security.ssl.SSLControl;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.ssl.SSLClientSocketFactory;

public class SSLSocketPolicy
implements RMISocketPolicy {
    final SSLControl serverSSLControl;
    final SSLControl clientSSLControl;

    public SSLSocketPolicy(SSLControl serverSSLControl, SSLControl clientSSLControl) {
        this.serverSSLControl = serverSSLControl;
        this.clientSSLControl = clientSSLControl;
    }

    @Override
    public void prepareClient(String storeContext) {
        if (this.isTrusted()) {
            SSLClientSocketFactory.setTrustedControl(this.clientSSLControl);
        } else {
            SSLClientSocketFactory.setUserControl(this.clientSSLControl, storeContext);
        }
    }

    @Override
    public RMISocketPolicy.SocketFactoryPair getRegistryPair(RMISocketPolicy.SocketFactoryArgs args) {
        throw new UnsupportedOperationException("Not supported on the client");
    }

    @Override
    public ClientSocketFactory getRegistryCSF(RMISocketPolicy.SocketFactoryArgs args) {
        return new SSLClientSocketFactory(args.getCsfName(), args.getCsfConnectTimeout(), args.getCsfReadTimeout(), args.getKvStoreName());
    }

    @Override
    public RMISocketPolicy.SocketFactoryPair getBindPair(RMISocketPolicy.SocketFactoryArgs args) {
        throw new UnsupportedOperationException("Not supported on the client");
    }

    @Override
    public boolean isTrustCapable() {
        return this.isTrusted();
    }

    boolean isTrusted() {
        return this.serverSSLControl != null && this.serverSSLControl.peerAuthenticator() != null;
    }
}

