/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.async.IterationHandleNotifier;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.SortSpec;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.ReceiveIter;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.util.SizeOf;

public class SortIter
extends PlanIter {
    private static final long theFixedMemoryConsumption = 2 * SizeOf.OBJECT_REF_OVERHEAD + SizeOf.ARRAYLIST_OVERHEAD + SizeOf.OBJECT_OVERHEAD + 12;
    private final PlanIter theInput;
    private final FieldDefImpl theInputType;
    private final int[] theSortFieldPositions;
    private final SortSpec[] theSortSpecs;

    public SortIter(Expr e, int resultReg, PlanIter input, FieldDefImpl inputType, int[] sortFieldPositions, SortSpec[] sortSpecs) {
        super(e, resultReg);
        this.theInput = input;
        this.theInputType = inputType;
        this.theSortFieldPositions = sortFieldPositions;
        this.theSortSpecs = sortSpecs;
    }

    public SortIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theInput = SortIter.deserializeIter(in, serialVersion);
        this.theInputType = (FieldDefImpl)SortIter.deserializeFieldDef(in, serialVersion);
        this.theSortFieldPositions = SortIter.deserializeIntArray(in, serialVersion);
        this.theSortSpecs = SortIter.deserializeSortSpecs(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SortIter.serializeIter(this.theInput, out, serialVersion);
        SortIter.serializeFieldDef(this.theInputType, out, serialVersion);
        SortIter.serializeIntArray(this.theSortFieldPositions, out, serialVersion);
        SortIter.serializeSortSpecs(this.theSortSpecs, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.SORT;
    }

    @Override
    public void setIterationHandleNotifier(IterationHandleNotifier iterHandleNotifier) {
        this.theInput.setIterationHandleNotifier(iterHandleNotifier);
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        SortIterState state = new SortIterState(this);
        rcb.setState(this.theStatePos, state);
        rcb.incMemoryConsumption(state.theMemoryConsumption);
        this.theInput.open(rcb);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInput.reset(rcb);
        SortIterState state = (SortIterState)rcb.getState(this.theStatePos);
        rcb.decMemoryConsumption(state.theMemoryConsumption - theFixedMemoryConsumption);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInput.close(rcb);
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        return this.nextInternal(rcb);
    }

    @Override
    public boolean nextLocal(RuntimeControlBlock rcb) {
        return this.nextInternal(rcb);
    }

    private boolean nextInternal(RuntimeControlBlock rcb) {
        SortIterState state = (SortIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        if (state.isOpen()) {
            boolean more = this.theInput.next(rcb);
            while (more) {
                FieldValueImpl v = rcb.getRegVal(this.theInput.getResultReg());
                if (v.isTuple()) {
                    v = ((TupleValue)v).toRecord();
                }
                state.theResults.add(v);
                long sz = v.sizeof() + (long)SizeOf.OBJECT_REF_OVERHEAD;
                state.theMemoryConsumption += sz;
                rcb.incMemoryConsumption(sz);
                more = this.theInput.next(rcb);
            }
            state.theResults.sort(state.theComparator);
            state.setState(PlanIterState.StateEnum.RUNNING);
        }
        if (state.theCurrResult < state.theResults.size()) {
            rcb.setRegVal(this.theResultReg, state.theResults.get(state.theCurrResult));
            ++state.theCurrResult;
            return true;
        }
        state.done();
        return false;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
    }

    private static class SortIterState
    extends PlanIterState {
        final ArrayList<FieldValueImpl> theResults;
        int theCurrResult;
        CompareFunction theComparator;
        long theMemoryConsumption = SortIter.access$300();

        public SortIterState(SortIter iter) {
            this.theResults = new ArrayList(4096);
            SortIter sortIter = iter;
            Objects.requireNonNull(sortIter);
            this.theComparator = sortIter.new CompareFunction();
        }

        @Override
        public void done() {
            super.done();
            this.theCurrResult = 0;
            this.theResults.clear();
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.theCurrResult = 0;
            this.theResults.clear();
            this.theMemoryConsumption = theFixedMemoryConsumption;
        }

        @Override
        public void close() {
            super.close();
            this.theResults.clear();
        }
    }

    private class CompareFunction
    implements Comparator<FieldValueImpl> {
        private CompareFunction() {
        }

        @Override
        public int compare(FieldValueImpl v1, FieldValueImpl v2) {
            if (SortIter.this.theInputType.isRecord()) {
                return ReceiveIter.compareRecords((RecordValueImpl)v1, (RecordValueImpl)v2, SortIter.this.theSortFieldPositions, SortIter.this.theSortSpecs);
            }
            return ReceiveIter.compareAtomics(v1, v2, 0, SortIter.this.theSortSpecs);
        }
    }
}

