/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

public class ExprMapFilter
extends Expr {
    private FilterKind theFilterKind;
    private Expr theInput;
    private Expr thePredExpr;
    private boolean theConstValue;
    private ExprVar theCtxItemVar;
    private ExprVar theCtxElemVar;
    private ExprVar theCtxKeyVar;

    ExprMapFilter(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, FilterKind kind, Expr input) {
        super(qcb, sctx, Expr.ExprKind.MAP_FILTER, location);
        this.theFilterKind = kind;
        this.theInput = input;
        this.theInput.addParent(this);
        this.theConstValue = true;
    }

    void addCtxVars(ExprVar ctxItemVar, ExprVar ctxElemVar, ExprVar ctxKeyVar) {
        this.theCtxItemVar = ctxItemVar;
        this.theCtxElemVar = ctxElemVar;
        this.theCtxKeyVar = ctxKeyVar;
    }

    void addPredExpr(Expr pred) {
        assert (this.thePredExpr == null && pred != null);
        this.thePredExpr = pred;
        this.thePredExpr.addParent(this);
        this.checkConst();
        if (!this.isConst()) {
            ExprType predType = this.thePredExpr.getType();
            if (!(predType.isAny() || predType.isAnyJson() || predType.isAnyAtomic() || predType.isAnyJsonAtomic() || predType.isSubType(TypeManager.BOOLEAN_STAR()))) {
                throw new QueryException("Predicate expression in filter step has invalid type:\nExpected type is boolean. Actual type is\n" + predType, pred.getLocation());
            }
            this.thePredExpr = ExprPromote.create(this, this.thePredExpr, TypeManager.BOOLEAN_QSTN());
        }
        this.removeCtxVars();
    }

    public FilterKind getFilterKind() {
        return this.theFilterKind;
    }

    @Override
    int getNumChildren() {
        return this.thePredExpr != null ? 2 : 1;
    }

    @Override
    Expr getInput() {
        return this.theInput;
    }

    void setInput(Expr newExpr, boolean destroy) {
        this.theInput.removeParent(this, destroy);
        this.theInput = newExpr;
        newExpr.addParent(this);
    }

    Expr getPredExpr() {
        return this.thePredExpr;
    }

    void setPredExpr(Expr newExpr, boolean destroy) {
        this.thePredExpr.removeParent(this, destroy);
        this.thePredExpr = newExpr;
        newExpr.addParent(this);
        this.checkConst();
        this.removeCtxVars();
    }

    ExprVar getCtxItemVar() {
        return this.theCtxItemVar;
    }

    ExprVar getCtxElemVar() {
        return this.theCtxElemVar;
    }

    ExprVar getCtxKeyVar() {
        return this.theCtxKeyVar;
    }

    boolean getConstValue() {
        return this.theConstValue;
    }

    boolean isConst() {
        return this.thePredExpr == null;
    }

    void checkConst() {
        if (this.isConst()) {
            assert (this.theCtxItemVar == null);
            assert (this.theCtxElemVar == null);
            assert (this.theCtxKeyVar == null);
            return;
        }
        if (this.thePredExpr.getKind() == Expr.ExprKind.CONST) {
            FieldValueImpl value = ((ExprConst)this.thePredExpr).getValue();
            if (!value.isBoolean()) {
                throw new QueryException("Predicate expression in filter step has invalid type.\nExpected type is boolean. Actual type is\n" + this.thePredExpr.getType(), this.thePredExpr.getLocation());
            }
            this.theConstValue = ((BooleanValueImpl)value).getBoolean();
            this.thePredExpr.removeParent(this, true);
            this.thePredExpr = null;
            this.theCtxItemVar = null;
            this.theCtxElemVar = null;
            this.theCtxKeyVar = null;
        }
    }

    void removeCtxVars() {
        if (this.theCtxItemVar != null && !this.theCtxItemVar.hasParents()) {
            this.theCtxItemVar = null;
        }
        if (this.theCtxElemVar != null && !this.theCtxElemVar.hasParents()) {
            this.theCtxElemVar = null;
        }
        if (this.theCtxKeyVar != null && !this.theCtxKeyVar.hasParents()) {
            this.theCtxKeyVar = null;
        }
    }

    @Override
    public ExprType computeType() {
        ExprType inType = this.theInput.getType();
        if (inType.isEmpty()) {
            return TypeManager.EMPTY();
        }
        this.checkConst();
        if (this.isConst() && !this.theConstValue) {
            return TypeManager.EMPTY();
        }
        while (inType.isArray()) {
            inType = inType.getArrayElementType(ExprType.Quantifier.STAR);
        }
        if (this.theQCB.strictMode() && inType.isAtomic()) {
            throw new QueryException("Wrong input type for path step (must be a record, array, or map type): " + inType.getDef().getDDLString(), this.theLocation);
        }
        if (this.theFilterKind == FilterKind.KEYS) {
            return TypeManager.STRING_STAR();
        }
        return inType.getMapElementType(ExprType.Quantifier.STAR);
    }

    @Override
    public boolean mayReturnNULL() {
        return this.theInput.mayReturnNULL() || this.getType().isAny() || this.getType().isAnyJson();
    }

    @Override
    void display(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        if (this.theFilterKind == FilterKind.KEYS) {
            sb.append("KEYS\n");
        } else {
            sb.append("VALUES\n");
        }
        formatter.indent(sb);
        sb.append("[\n");
        formatter.incIndent();
        formatter.indent(sb);
        sb.append("type :\n");
        formatter.indent(sb);
        this.getType().display(sb, formatter);
        sb.append("\n");
        this.theInput.display(sb, formatter);
        sb.append(".\n");
        formatter.indent(sb);
        if (this.isConst()) {
            sb.append(this.theConstValue);
        } else {
            this.thePredExpr.display(sb, formatter);
        }
        sb.append("\n");
        formatter.decIndent();
        formatter.indent(sb);
        sb.append("]");
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
    }

    public static enum FilterKind {
        KEYS,
        VALUES,
        KEYVALUES;

    }
}

