/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprArrayConstr;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

public class ExprMapConstr
extends Expr {
    final ArrayList<Expr> theArgs;
    private boolean theMustBeJson;

    ExprMapConstr(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, ArrayList<Expr> args) {
        super(qcb, sctx, Expr.ExprKind.MAP_CONSTR, location);
        this.theArgs = args;
        int numArgs = args.size();
        for (int i = 0; i < numArgs; ++i) {
            Expr arg = args.get(i);
            if (i % 2 == 0) {
                arg = ExprPromote.create(null, arg, TypeManager.STRING_QSTN());
                this.theArgs.set(i, arg);
            } else if (arg.isMultiValued()) {
                ArrayList<Expr> arrargs = new ArrayList<Expr>(1);
                arrargs.add(arg);
                arg = new ExprArrayConstr(this.theQCB, this.theSctx, arg.theLocation, arrargs, true);
                this.theArgs.set(i, arg);
            }
            arg.addParent(this);
        }
        this.theType = this.computeType();
    }

    @Override
    int getNumChildren() {
        return this.theArgs.size();
    }

    int getNumArgs() {
        return this.theArgs.size();
    }

    Expr getArg(int i) {
        return this.theArgs.get(i);
    }

    void setArg(int i, Expr newExpr, boolean destroy) {
        this.theArgs.get(i).removeParent(this, destroy);
        if (i % 2 == 0) {
            newExpr = ExprPromote.create(null, newExpr, TypeManager.STRING_QSTN());
        } else if (newExpr.isMultiValued()) {
            ArrayList<Expr> arrargs = new ArrayList<Expr>(1);
            arrargs.add(newExpr);
            newExpr = new ExprArrayConstr(this.theQCB, this.theSctx, newExpr.theLocation, arrargs, true);
        }
        this.theArgs.set(i, newExpr);
        newExpr.addParent(this);
    }

    void removeArg(int i, boolean destroy) {
        if (!this.theArgs.get(i).getType().isEmpty()) {
            throw new QueryStateException("Cannot remove non-empty input expr from map constructor expr");
        }
        this.theArgs.get(i).removeParent(this, destroy);
        this.theArgs.remove(i);
    }

    void setJsonMapType() {
        this.theMustBeJson = true;
    }

    public MapDefImpl getMapType() {
        return (MapDefImpl)this.getType().getDef();
    }

    @Override
    ExprType computeType() {
        ExprType type;
        int numArgs = this.theArgs.size();
        if (numArgs == 0) {
            return TypeManager.createMapType(TypeManager.JSON_ONE(), ExprType.Quantifier.ONE);
        }
        ExprType elemType = this.theArgs.get(1).getType();
        for (int i = 3; i < numArgs && !(elemType = TypeManager.getConcatType(elemType, type = this.theArgs.get(i).getType())).isAny(); i += 2) {
        }
        if (this.theMustBeJson && elemType.getDef().isSubtype(FieldDefImpl.jsonDef)) {
            elemType = TypeManager.JSON_ONE();
        }
        if (elemType.isAnyJson()) {
            this.theQCB.theHaveJsonConstructors = true;
        }
        return TypeManager.createMapType(elemType, ExprType.Quantifier.ONE);
    }

    @Override
    public boolean mayReturnNULL() {
        return false;
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        for (int i = 0; i < this.theArgs.size(); ++i) {
            this.theArgs.get(i).display(sb, formatter);
            if (i >= this.theArgs.size() - 1) continue;
            sb.append(",\n");
        }
    }
}

