/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.List;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.FieldDef;

class ExprIsOfType
extends Expr {
    private Expr theInput;
    private List<FieldDef> theTargetTypes;
    private List<ExprType.Quantifier> theTargetQuantifiers;
    private List<Boolean> theOnlyTargetFlags;
    private boolean theNotFlag;

    ExprIsOfType(QueryControlBlock qcb, StaticContext sctx, QueryException.Location loc, Expr input, boolean notFlag, List<FieldDef> types, List<ExprType.Quantifier> quantifiers, List<Boolean> onlyFlags) {
        super(qcb, sctx, Expr.ExprKind.IS_OF_TYPE, loc);
        this.theInput = input;
        this.theInput.addParent(this);
        this.theNotFlag = notFlag;
        this.theTargetTypes = types;
        this.theTargetQuantifiers = quantifiers;
        this.theOnlyTargetFlags = onlyFlags;
    }

    @Override
    int getNumChildren() {
        return 1;
    }

    @Override
    Expr getInput() {
        return this.theInput;
    }

    void setInput(Expr newExpr, boolean destroy) {
        this.theInput.removeParent(this, destroy);
        this.theInput = newExpr;
        newExpr.addParent(this);
    }

    List<FieldDef> getTargetTypes() {
        return this.theTargetTypes;
    }

    List<ExprType.Quantifier> getTargetQuantifiers() {
        return this.theTargetQuantifiers;
    }

    List<Boolean> getOnlyTargetFlags() {
        return this.theOnlyTargetFlags;
    }

    boolean isNot() {
        return this.theNotFlag;
    }

    @Override
    ExprType computeType() {
        return TypeManager.BOOLEAN_ONE();
    }

    @Override
    public boolean mayReturnNULL() {
        return this.theInput.mayReturnNULL();
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
        sb.append("\n");
        formatter.indent(sb);
        sb.append(" IS ");
        if (this.theNotFlag) {
            sb.append("NOT ");
        }
        sb.append("OF TYPE (");
        for (int i = 0; i < this.theTargetTypes.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (this.theOnlyTargetFlags.get(i).booleanValue()) {
                sb.append("ONLY ");
            }
            ((FieldDefImpl)this.theTargetTypes.get(i)).display(sb, formatter);
            sb.append(this.theTargetQuantifiers.get(i).toString());
        }
        sb.append("),\n");
    }
}

