/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.fault;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.kv.FastExternalizableException;
import oracle.kv.KVVersion;
import oracle.kv.impl.util.SerializationUtil;

public abstract class InternalFaultException
extends FastExternalizableException {
    private static final long serialVersionUID = 1L;
    private final String faultClassName;
    private final String originalStackTrace;

    public InternalFaultException(Throwable cause) {
        super(cause.getMessage() + " (" + KVVersion.CURRENT_VERSION.getNumericVersionString() + ")");
        StringWriter sw = new StringWriter(500);
        cause.printStackTrace(new PrintWriter(sw));
        this.originalStackTrace = sw.toString();
        this.faultClassName = cause.getClass().getName();
    }

    public InternalFaultException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.originalStackTrace = SerializationUtil.readString(in, serialVersion);
        this.faultClassName = SerializationUtil.readString(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writeString(out, serialVersion, this.originalStackTrace);
        SerializationUtil.writeString(out, serialVersion, this.faultClassName);
    }

    public String getFaultClassName() {
        return this.faultClassName;
    }

    @Override
    public String toString() {
        return this.getMessage() + " " + this.originalStackTrace;
    }
}

