/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.nio;

import com.sleepycat.util.PackedInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.ListIterator;
import oracle.kv.impl.async.BytesInput;
import oracle.kv.impl.async.BytesUtil;
import oracle.kv.impl.async.dialog.ChannelInput;
import oracle.kv.impl.async.dialog.nio.NioBytesInput;

class NioChannelInput
implements ChannelInput {
    private static final Charset utf8 = Charset.forName("UTF-8");
    private static final int BUFFER_SIZE = 4096;
    private final int bufferSize;
    private final ByteBuffer[] chnlArray = new ByteBuffer[2];
    private ByteBuffer chnlBuf0;
    private ByteBuffer chnlBuf1;
    private int chnlPos;
    private LinkedList<ByteBuffer> protoBufList;
    private ListIterator<ByteBuffer> protoIter;
    private ByteBuffer protoBuf;
    private int protoPos;
    private int markPos;
    private int readableBytes = 0;
    private final byte[] packedLongBytes = new byte[9];

    NioChannelInput() {
        this(4096);
    }

    NioChannelInput(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.bufferSize = bufferSize;
        this.chnlBuf0 = ByteBuffer.allocate(bufferSize);
        this.chnlBuf1 = ByteBuffer.allocate(bufferSize);
        this.chnlArray[0] = this.chnlBuf0;
        this.chnlArray[1] = this.chnlBuf1;
        this.chnlPos = 0;
        this.protoBufList = new LinkedList();
        this.protoBufList.add(this.chnlBuf0);
        this.protoBuf = this.chnlBuf0;
        this.protoPos = 0;
        this.markPos = 0;
    }

    @Override
    public void mark() {
        this.pollUntilProtoBuf();
        this.markPos = this.protoBuf.position();
    }

    @Override
    public void reset() {
        for (ByteBuffer buf : this.protoBufList) {
            this.readableBytes += buf.position();
            buf.position(0);
            if (buf != this.protoBuf) continue;
            break;
        }
        this.protoIter = this.protoBufList.listIterator();
        this.protoBuf = this.protoIter.next();
        this.protoBuf.position(this.markPos);
        this.readableBytes -= this.markPos;
    }

    @Override
    public int readableBytes() {
        return this.readableBytes;
    }

    @Override
    public byte readByte() {
        this.ensureProtoBufNotConsumed();
        byte b = this.protoBuf.get();
        --this.readableBytes;
        return b;
    }

    @Override
    public BytesInput readBytes(int len) {
        if (len == 0) {
            return new NioBytesInput(0, null);
        }
        LinkedList<ByteBuffer> bufs = new LinkedList<ByteBuffer>();
        int n = len;
        while (true) {
            int chunkLen = Math.min(n, this.protoBuf.remaining());
            int newPos = this.protoBuf.position() + chunkLen;
            ByteBuffer chunk = this.protoBuf.duplicate();
            chunk.limit(newPos);
            bufs.add(chunk);
            this.protoBuf.position(newPos);
            if ((n -= chunkLen) == 0) break;
            this.ensureProtoBufNotConsumed();
        }
        this.readableBytes -= len;
        return new NioBytesInput(len, bufs);
    }

    @Override
    public boolean canReadPackedLong() {
        if (this.readableBytes == 0) {
            return false;
        }
        return this.readableBytes >= this.peekPackedLongLength();
    }

    @Override
    public long readPackedLong() {
        int rest;
        int len = this.peekPackedLongLength();
        if (len <= (rest = this.protoBuf.remaining())) {
            this.protoBuf.get(this.packedLongBytes, 0, len);
        } else {
            this.protoBuf.get(this.packedLongBytes, 0, rest);
            this.ensureProtoBufNotConsumed();
            this.protoBuf.get(this.packedLongBytes, rest, len - rest);
        }
        this.readableBytes -= len;
        return PackedInteger.readLong(this.packedLongBytes, 0);
    }

    private int peekPackedLongLength() {
        this.ensureProtoBufNotConsumed();
        this.packedLongBytes[0] = this.protoBuf.get(this.protoBuf.position());
        return PackedInteger.getReadLongLength(this.packedLongBytes, 0);
    }

    @Override
    public String readUTF8(int length) {
        if (this.readableBytes < length) {
            return null;
        }
        int len = length;
        byte[] bytes = new byte[length];
        int offset = 0;
        while (true) {
            int n = Math.min(length, this.protoBuf.remaining());
            this.protoBuf.get(bytes, offset, n);
            offset += n;
            if ((length -= n) == 0) break;
            this.ensureProtoBufNotConsumed();
        }
        this.readableBytes -= len;
        return utf8.decode(ByteBuffer.wrap(bytes)).toString();
    }

    @Override
    public void close() {
        this.protoBufList.clear();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChannelInput");
        builder.append(" chnlPos=").append(this.chnlPos);
        builder.append(" markPos=").append(this.markPos);
        builder.append(" protoPos=").append(this.protoPos);
        builder.append(" readable=").append(this.readableBytes);
        builder.append(" bufs=");
        for (ByteBuffer buf : this.protoBufList) {
            if (buf == this.protoBuf) {
                builder.append("Pr");
            }
            if (buf == this.chnlBuf0) {
                builder.append("Ch");
            }
            builder.append(BytesUtil.toString(buf, buf.limit()));
        }
        builder.append(" Ch1");
        builder.append(BytesUtil.toString(this.chnlBuf1, this.chnlBuf1.limit()));
        return builder.toString();
    }

    ByteBuffer[] flipToChannelRead() {
        this.markPos = 0;
        this.pollUntilProtoBuf();
        this.protoPos = this.protoBuf.position();
        this.chnlBuf0.position(this.chnlPos);
        this.chnlBuf0.limit(this.chnlBuf0.capacity());
        return this.chnlArray;
    }

    void flipToProtocolRead() {
        this.readableBytes += this.chnlBuf0.position() - this.chnlPos;
        this.readableBytes += this.chnlBuf1.position();
        while (this.chnlBuf0.remaining() == 0) {
            this.chnlBuf0.limit(this.chnlBuf0.capacity());
            this.chnlBuf0.position(0);
            this.protoBufList.add(this.chnlBuf1);
            this.chnlBuf0 = this.chnlBuf1;
            this.chnlBuf1 = ByteBuffer.allocate(this.bufferSize);
            this.chnlArray[0] = this.chnlBuf0;
            this.chnlArray[1] = this.chnlBuf1;
        }
        this.chnlPos = this.chnlBuf0.position();
        this.chnlBuf0.limit(this.chnlPos);
        this.chnlBuf0.position(0);
        this.pollUntilProtoBuf();
        this.protoBuf.position(this.protoPos);
    }

    private void pollUntilProtoBuf() {
        ByteBuffer buf;
        while ((buf = this.protoBufList.peek()) != null && buf != this.protoBuf) {
            this.protoBufList.poll();
        }
        this.protoIter = this.protoBufList.listIterator();
        this.protoBuf = this.protoIter.next();
    }

    private void ensureProtoBufNotConsumed() {
        while (this.protoBuf.remaining() <= 0) {
            if (!this.protoIter.hasNext()) {
                throw new IllegalStateException(String.format("There is not enough data, should check readableBytes before read, input=%s", this.toString()));
            }
            this.protoBuf = this.protoIter.next();
        }
        return;
    }
}

