/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.dialog.nio.ChannelAccepter;
import oracle.kv.impl.async.dialog.nio.ChannelExecutor;
import oracle.kv.impl.async.dialog.nio.ChannelHandler;
import oracle.kv.impl.async.dialog.nio.NioChannelThreadPool;
import oracle.kv.impl.async.dialog.nio.NioHandler;
import oracle.kv.impl.util.CommonLoggerUtils;

public class NioChannelExecutor
extends AbstractExecutorService
implements Runnable,
ChannelExecutor {
    private final Logger logger;
    private final NioChannelThreadPool parent;
    private final int childId;
    private final String id;
    private static final AtomicLong sequencer = new AtomicLong();
    private final long startTimeNs = System.nanoTime();
    private final Queue<RegisterEntry> registerQueue = new ConcurrentLinkedQueue<RegisterEntry>();
    private final Queue<Runnable> taskQueue = new ConcurrentLinkedQueue<Runnable>();
    private final PriorityQueue<ScheduledFutureTask<?>> delayedQueue = new PriorityQueue();
    private final List<Runnable> remainingTasks = new ArrayList<Runnable>();
    private volatile Thread thread;
    private long currTimeNs = this.nanoTime();
    private static final int UPDATE_INTERVAL = 64;
    private int updateCountdown = 0;
    private static final int REMOVE_INTERVAL = 1024;
    private int cancelledTaskCountdown = 1024;
    private final Selector selector;
    private final AtomicBoolean pendingWakeup = new AtomicBoolean(false);
    private final TaskTimeCalculator taskTimeCalculator = new DefaultTaskTimeCalculator(100000L);
    private volatile State state = State.RUNNING;

    public NioChannelExecutor(Logger logger, NioChannelThreadPool parent, int childId) throws IOException {
        this.logger = logger;
        this.parent = parent;
        this.childId = childId;
        this.id = String.format("%x#%x", parent.getId(), childId);
        this.selector = Selector.open();
    }

    public String getId() {
        return this.id;
    }

    public int getChildId() {
        return this.childId;
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        if (this.isShutdownOrAfter()) {
            throw new RejectedExecutionException("Executor is shut down");
        }
        PrintableFutureTask task = new PrintableFutureTask(command);
        this.taskQueue.add(task);
        this.wakeup();
        if (this.isShutdownOrAfter() && task.cancel(false)) {
            throw new RejectedExecutionException("Executor is shut down");
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        ScheduledFutureTask<Object> task = new ScheduledFutureTask<Object>(command, null, this.getDelayedTime(delay, unit));
        this.addDelayedTask(task);
        return task;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (callable == null || unit == null) {
            throw new NullPointerException();
        }
        ScheduledFutureTask<V> task = new ScheduledFutureTask<V>(callable, this.getDelayedTime(delay, unit));
        this.addDelayedTask(task);
        return task;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        ScheduledFutureTask<Object> task = new ScheduledFutureTask<Object>(command, null, this.getDelayedTime(initialDelay, unit), unit.toNanos(period));
        this.addDelayedTask(task);
        return task;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        ScheduledFutureTask<Object> task = new ScheduledFutureTask<Object>(command, null, this.getDelayedTime(initialDelay, unit), -unit.toNanos(delay));
        this.addDelayedTask(task);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        NioChannelExecutor nioChannelExecutor = this;
        synchronized (nioChannelExecutor) {
            if (this.isShuttingDownOrAfter()) {
                return;
            }
            this.state = State.SHUTTINGDOWN;
        }
        this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        NioChannelExecutor nioChannelExecutor = this;
        synchronized (nioChannelExecutor) {
            if (this.isTerminated()) {
                return this.remainingTasks;
            }
            this.state = State.STOP;
        }
        if (this.inExecutorThread()) {
            this.terminate();
            return this.remainingTasks;
        }
        this.wakeup();
        try {
            this.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.isTerminated()) {
            throw new IllegalStateException("The executor is not terminated after 10 seconds; something is wrong: " + this.toString());
        }
        return this.remainingTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long waitTimeMillis;
        if (this.inExecutorThread()) {
            throw new IllegalStateException("Cannot wait for termination inside executor thread");
        }
        if (!this.isShuttingDownOrAfter()) {
            throw new IllegalStateException("Should only call awaitTermination after executor is shutting down");
        }
        long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, unit);
        long deadlineMillis = System.currentTimeMillis() + timeoutMillis;
        while ((waitTimeMillis = deadlineMillis - System.currentTimeMillis()) > 0L) {
            NioChannelExecutor nioChannelExecutor = this;
            synchronized (nioChannelExecutor) {
                boolean done = this.isTerminated();
                if (done) {
                    return done;
                }
                this.wait(waitTimeMillis);
            }
        }
        return this.isTerminated();
    }

    @Override
    public boolean isShutdown() {
        return this.isShuttingDownOrAfter();
    }

    @Override
    public boolean isTerminated() {
        return this.state == State.TERMINATED;
    }

    @Override
    public boolean inExecutorThread() {
        return Thread.currentThread() == this.thread;
    }

    @Override
    public void registerAccept(ServerSocketChannel channel, ChannelAccepter handler) throws IOException {
        if (this.isShuttingDownOrAfter()) {
            throw new IllegalStateException("Executor is shut down");
        }
        channel.configureBlocking(false);
        if (!this.inExecutorThread()) {
            this.registerQueue.add(new RegisterEntry(channel, 16, handler));
            this.wakeup();
        } else {
            if (!this.registerQueue.isEmpty()) {
                this.doRegister();
            }
            this.registerChannel(channel, 16, handler);
        }
    }

    @Override
    public void registerConnect(SocketChannel channel, ChannelHandler handler) throws IOException {
        if (this.isShuttingDownOrAfter()) {
            throw new IllegalStateException("Executor is shut down");
        }
        channel.configureBlocking(false);
        if (!this.inExecutorThread()) {
            this.registerQueue.add(new RegisterEntry(channel, 8, handler));
            this.wakeup();
        } else {
            if (!this.registerQueue.isEmpty()) {
                this.doRegister();
            }
            this.registerChannel(channel, 8, handler);
        }
    }

    @Override
    public void registerRead(SocketChannel channel, ChannelHandler handler) throws IOException {
        if (this.isShuttingDownOrAfter()) {
            throw new IllegalStateException("Executor is shut down");
        }
        channel.configureBlocking(false);
        if (!this.inExecutorThread()) {
            this.registerQueue.add(new RegisterEntry(channel, 1, handler));
            this.wakeup();
        } else {
            if (!this.registerQueue.isEmpty()) {
                this.doRegister();
            }
            this.registerChannel(channel, 1, handler);
        }
    }

    @Override
    public void registerReadWrite(SocketChannel channel, ChannelHandler handler) throws IOException {
        if (this.isShuttingDownOrAfter()) {
            throw new IllegalStateException("Executor is shut down");
        }
        channel.configureBlocking(false);
        if (!this.inExecutorThread()) {
            this.registerQueue.add(new RegisterEntry(channel, 5, handler));
            this.wakeup();
        } else {
            if (!this.registerQueue.isEmpty()) {
                this.doRegister();
            }
            this.registerChannel(channel, 5, handler);
        }
    }

    @Override
    public void deregister(SelectableChannel channel) throws IOException {
        if (!this.inExecutorThread()) {
            this.registerQueue.add(new RegisterEntry(channel, 0, null));
            this.wakeup();
        } else {
            if (!this.registerQueue.isEmpty()) {
                this.doRegister();
            }
            this.deregisterChannel(channel);
        }
    }

    @Override
    public boolean writeInterested(SelectableChannel channel) {
        try {
            SelectionKey key = channel.keyFor(this.selector);
            if (key == null) {
                return false;
            }
            return (key.interestOps() & 4) != 0;
        }
        catch (CancelledKeyException e) {
            return false;
        }
    }

    @Override
    public boolean deregistered(SelectableChannel channel) {
        SelectionKey key = channel.keyFor(this.selector);
        return key == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: {
            this.thread = Thread.currentThread();
            this.logger.log(Level.FINE, "Executor starts running: {0}", this);
            try {
                this.scheduleAtFixedRate(new DumpTask(), 0L, 10L, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException re) {
                if (this.isShutdownOrAfter()) break block10;
                throw new IllegalStateException("Executor not shut down but cannot schedule tasks.");
            }
        }
        while (!this.isShutdownOrAfter()) {
            try {
                this.runOnce();
                if (!this.isShuttingDownOrAfter() || !this.selector.keys().isEmpty()) continue;
                NioChannelExecutor re = this;
                synchronized (re) {
                    if (this.state == State.SHUTTINGDOWN) {
                        this.state = State.SHUTDOWN;
                    }
                    break;
                }
            }
            catch (Throwable cause) {
                if (!this.logger.isLoggable(Level.INFO)) continue;
                this.logger.log(Level.INFO, "Unexpected exception during execution: {0}", new Object[]{CommonLoggerUtils.getStackTrace(cause)});
            }
        }
        if (!this.isStoppedOrAfter()) {
            this.runTasks(Integer.MAX_VALUE);
        }
        this.terminate();
    }

    public void runOnce() throws IOException, InterruptedException {
        long procTime = this.selectAndProcess();
        long taskTime = this.taskTimeCalculator.getTaskTimeNanos(procTime);
        this.runTasks(this.getDelayedTime(taskTime));
    }

    public boolean isShuttingDownOrAfter() {
        return this.state.compareTo(State.SHUTTINGDOWN) >= 0;
    }

    public boolean isShutdownOrAfter() {
        return this.state.compareTo(State.SHUTDOWN) >= 0;
    }

    public boolean isStoppedOrAfter() {
        return this.state.compareTo(State.STOP) >= 0;
    }

    public long nanoTime() {
        return System.nanoTime() - this.startTimeNs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(": parent=").append(Integer.toHexString(this.parent.getId()));
        builder.append(" childId=").append(Integer.toHexString(this.childId));
        builder.append("\n");
        builder.append("\tnanoTime at startup=").append(this.startTimeNs);
        builder.append(" elapsedNs=").append(this.nanoTime());
        builder.append("\n");
        builder.append("\tthread=").append(this.thread);
        builder.append(" selector=").append(this.selector);
        builder.append("\n");
        builder.append("\tstate=").append((Object)this.state);
        builder.append(" #taskQueue=").append(this.taskQueue.size());
        builder.append(" #delayedQueue=").append(this.delayedQueue.size());
        builder.append(" #remainingTasks=").append(this.remainingTasks.size());
        builder.append("\n");
        builder.append("\tnext task: ").append(this.taskQueue.peek()).append("\n");
        builder.append("\tnext delayed: ").append(this.delayedQueue.peek()).append("\n");
        builder.append("\tselecting channels:\n");
        try {
            for (SelectionKey key : this.selector.keys()) {
                try {
                    builder.append("\t\tch=").append(key.channel()).append("\tops=").append(Integer.toBinaryString(key.interestOps())).append("\n");
                }
                catch (Throwable t) {
                    builder.append("\t\tch=").append(key.channel()).append(" error=").append(t);
                }
            }
        }
        catch (Throwable t) {
            builder.append("\terror=").append(t);
        }
        return builder.toString();
    }

    public String tasksToString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append("taskQueue=[");
        for (Runnable runnable : this.taskQueue) {
            builder.append(runnable.toString());
            builder.append(", ");
        }
        builder.append("]");
        builder.append("delayedQueue=[");
        for (Runnable runnable : this.delayedQueue) {
            builder.append(runnable.toString());
            builder.append(", ");
        }
        builder.append("]");
        builder.append("remainingTasks=[");
        for (Runnable runnable : this.remainingTasks) {
            builder.append(runnable.toString());
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    private long getDelayedTime(long delay, TimeUnit unit) {
        return this.getDelayedTime(unit.toNanos(delay < 0L ? 0L : delay));
    }

    private long getDelayedTime(long delayNs) {
        long curr = this.nanoTime();
        long result = curr + delayNs;
        result = result < curr ? Long.MAX_VALUE : result;
        return result;
    }

    private void addDelayedTask(final ScheduledFutureTask<?> task) {
        if (this.isShutdownOrAfter()) {
            throw new RejectedExecutionException("Executor is shut down");
        }
        if (this.inExecutorThread()) {
            this.delayedQueue.add(task);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    NioChannelExecutor.this.delayedQueue.add(task);
                }

                public String toString() {
                    return "Adding to delayed queue: " + task;
                }
            });
            this.wakeup();
        }
    }

    private void wakeup() {
        if (!this.inExecutorThread() && this.pendingWakeup.compareAndSet(false, true)) {
            this.selector.wakeup();
        }
    }

    private long selectAndProcess() throws InterruptedException, IOException {
        assert (this.inExecutorThread());
        if (this.isShutdownOrAfter()) {
            return 0L;
        }
        this.doSelect();
        long start = this.nanoTime();
        this.doProcess();
        this.currTimeNs = this.nanoTime();
        return this.currTimeNs - start;
    }

    private void doSelect() throws InterruptedException, IOException {
        try {
            long timeoutMillis = (this.getUntilDeadline() - 100000L) / 1000000L;
            if (!this.taskQueue.isEmpty() || timeoutMillis <= 0L) {
                this.selector.selectNow();
                this.pendingWakeup.set(false);
                return;
            }
            do {
                this.doRegister();
                int selectedKeys = this.selector.select(timeoutMillis);
                this.pendingWakeup.set(false);
                if (selectedKeys != 0) {
                    return;
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (!this.taskQueue.isEmpty()) {
                    return;
                }
                timeoutMillis = (this.getUntilDeadline() - 100000L) / 1000000L;
                if (timeoutMillis > 0L) continue;
                return;
            } while (!this.isShuttingDownOrAfter());
            return;
        }
        catch (CancelledKeyException e) {
            this.logger.log(Level.FINE, "CancelledKeyException during select: {0}", e);
            return;
        }
    }

    private void doRegister() {
        while (!this.registerQueue.isEmpty()) {
            RegisterEntry entry = this.registerQueue.remove();
            if (entry.attach == null) {
                this.deregisterChannel(entry.channel);
                continue;
            }
            try {
                entry.channel.configureBlocking(false);
                this.registerChannel(entry.channel, entry.ops, entry.attach);
            }
            catch (IOException ioe) {
                this.logAndHandleError((NioHandler)entry.attach, ioe, entry.channel);
            }
        }
        this.pendingWakeup.set(false);
        if (!this.registerQueue.isEmpty() && !this.pendingWakeup.get()) {
            this.selector.wakeup();
        }
    }

    private void registerChannel(SelectableChannel channel, int ops, Object att) throws IOException {
        channel.register(this.selector, ops, att);
    }

    private void deregisterChannel(SelectableChannel channel) {
        SelectionKey key = channel.keyFor(this.selector);
        if (key != null) {
            key.cancel();
        }
    }

    private long getUntilDeadline() {
        this.currTimeNs = this.nanoTime();
        ScheduledFutureTask<?> task = this.delayedQueue.peek();
        if (task == null) {
            return Integer.MAX_VALUE;
        }
        long diff = Math.min(Integer.MAX_VALUE, ((ScheduledFutureTask)task).execTimeNanos - this.currTimeNs);
        return diff < 0L ? 0L : diff;
    }

    private void doProcess() {
        Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
        if (selectedKeys.isEmpty()) {
            return;
        }
        Iterator<SelectionKey> iter = selectedKeys.iterator();
        while (iter.hasNext()) {
            SocketChannel socketChannel;
            NioHandler handler;
            int readyOps;
            SelectionKey key = iter.next();
            Object attach = key.attachment();
            iter.remove();
            try {
                readyOps = key.readyOps();
            }
            catch (CancelledKeyException e) {
                continue;
            }
            if ((readyOps & 0x10) != 0) {
                ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
                assert (!serverSocketChannel.isBlocking());
                handler = (ChannelAccepter)attach;
                this.handleAccept(serverSocketChannel, (ChannelAccepter)handler);
            }
            if ((readyOps & 8) != 0) {
                socketChannel = (SocketChannel)key.channel();
                handler = (ChannelHandler)attach;
                this.handleConnect(socketChannel, (ChannelHandler)handler);
            }
            if ((readyOps & 1) != 0) {
                socketChannel = (SocketChannel)key.channel();
                handler = (ChannelHandler)attach;
                this.handleRead(socketChannel, (ChannelHandler)handler);
            }
            if ((readyOps & 4) == 0) continue;
            socketChannel = (SocketChannel)key.channel();
            handler = (ChannelHandler)attach;
            this.handleWrite(socketChannel, (ChannelHandler)handler);
        }
    }

    private void runTasks(long until) {
        assert (this.inExecutorThread());
        block2: while (true) {
            this.fetchScheduledTasks();
            if (this.taskQueue.isEmpty()) {
                return;
            }
            do {
                block8: {
                    if (this.taskQueue.isEmpty()) continue block2;
                    Runnable task = this.taskQueue.poll();
                    try {
                        task.run();
                    }
                    catch (Throwable t) {
                        if (!this.logger.isLoggable(Level.INFO)) break block8;
                        this.logger.log(Level.INFO, "An error occurs to the task {0}: {1}", new Object[]{task, CommonLoggerUtils.getStackTrace(t)});
                    }
                }
                this.updateCurrTime();
                if (this.currTimeNs >= until) {
                    return;
                }
                assert (this.state != State.TERMINATED);
            } while (this.state != State.STOP);
            break;
        }
    }

    private void fetchScheduledTasks() {
        ScheduledFutureTask<?> task;
        this.currTimeNs = this.nanoTime();
        while ((task = this.delayedQueue.peek()) != null && ((ScheduledFutureTask)task).execTimeNanos <= this.currTimeNs) {
            task = this.delayedQueue.poll();
            this.taskQueue.add(task);
        }
    }

    private void updateCurrTime() {
        if (this.updateCountdown == 0) {
            this.currTimeNs = this.nanoTime();
            this.updateCountdown = 64;
        }
        --this.updateCountdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        assert (this.inExecutorThread());
        if (this.isTerminated()) {
            return;
        }
        NioChannelExecutor nioChannelExecutor = this;
        synchronized (nioChannelExecutor) {
            if (this.isTerminated()) {
                return;
            }
            this.state = State.STOP;
        }
        this.remainingTasks.addAll(this.taskQueue);
        this.remainingTasks.addAll(this.delayedQueue);
        this.closeSelector();
        nioChannelExecutor = this;
        synchronized (nioChannelExecutor) {
            this.state = State.TERMINATED;
            this.notifyAll();
        }
        this.logger.log(Level.FINE, "Executor terminated: {0}", this);
    }

    private void closeSelector() {
        if (this.isTerminated()) {
            return;
        }
        for (SelectionKey key : this.selector.keys()) {
            key.cancel();
            Object attach = key.attachment();
            NioHandler handler = (NioHandler)attach;
            try {
                handler.onClosing();
            }
            catch (Throwable throwable) {
                if (!this.logger.isLoggable(Level.INFO)) continue;
                this.logger.log(Level.INFO, "Executor encountered error when calling handler onClosing, handler={0}: {1}", new Object[]{handler, CommonLoggerUtils.getStackTrace(throwable)});
            }
        }
        try {
            this.selector.close();
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, "Error close selector: {0}", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAccept(ServerSocketChannel serverSocketChannel, ChannelAccepter handler) {
        SocketChannel socketChannel = null;
        try {
            socketChannel = serverSocketChannel.accept();
            if (socketChannel != null) {
                handler.onAccept(socketChannel);
            }
        }
        catch (Throwable t) {
            try {
                if (socketChannel != null) {
                    try {
                        socketChannel.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.logAndHandleError(handler, t, serverSocketChannel);
            }
        }
    }

    private void handleConnect(SocketChannel socketChannel, ChannelHandler handler) {
        try {
            if (socketChannel.finishConnect()) {
                handler.onConnected();
            }
        }
        catch (Throwable t) {
            this.logAndHandleError(handler, t, socketChannel);
        }
    }

    private void handleRead(SocketChannel socketChannel, ChannelHandler handler) {
        try {
            handler.onRead();
        }
        catch (Throwable t) {
            this.logAndHandleError(handler, t, socketChannel);
        }
    }

    private void handleWrite(SocketChannel socketChannel, ChannelHandler handler) {
        try {
            handler.onWrite();
        }
        catch (Throwable t) {
            this.logAndHandleError(handler, t, socketChannel);
        }
    }

    private void logAndHandleError(NioHandler handler, Throwable t, SelectableChannel channel) {
        block3: {
            Level level;
            Level level2 = level = t instanceof IOException ? Level.FINE : Level.INFO;
            if (this.logger.isLoggable(level)) {
                this.logger.log(level, "Executor encountered error, channel={0}, handler={1}: {2}", new Object[]{channel, handler, CommonLoggerUtils.getStackTrace(t)});
            }
            try {
                handler.onError(t, channel);
            }
            catch (Throwable throwable) {
                if (!this.logger.isLoggable(Level.INFO)) break block3;
                this.logger.log(Level.INFO, "Executor encountered error when calling handler onError, handler={0}: {1}", new Object[]{handler, CommonLoggerUtils.getStackTrace(throwable)});
            }
        }
    }

    public class PrintableFutureTask
    extends FutureTask<Void> {
        private final Runnable r;

        public PrintableFutureTask(Runnable r) {
            super(r, null);
            this.r = r;
        }

        @Override
        public String toString() {
            return this.r.toString();
        }
    }

    public class DumpTask
    implements Runnable {
        @Override
        public void run() {
            if (NioChannelExecutor.this.logger.isLoggable(Level.FINEST)) {
                NioChannelExecutor.this.logger.log(Level.FINEST, "[Dump]" + NioChannelExecutor.this.toString());
            }
        }

        public String toString() {
            return "Dump task";
        }
    }

    private class DefaultTaskTimeCalculator
    implements TaskTimeCalculator {
        private final long timeToRunTask;

        public DefaultTaskTimeCalculator(long timeToRunTask) {
            this.timeToRunTask = timeToRunTask;
        }

        @Override
        public long getTaskTimeNanos(long procTime) {
            return this.timeToRunTask;
        }
    }

    private class RegisterEntry {
        final SelectableChannel channel;
        final int ops;
        final Object attach;

        RegisterEntry(SelectableChannel channel, int ops, Object attach) {
            this.channel = channel;
            this.ops = ops;
            this.attach = attach;
        }
    }

    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final Object innerTask;
        private volatile long execTimeNanos;
        private final long seqno;
        private final long period;

        ScheduledFutureTask(Callable<V> c, long execTimeNanos) {
            super(c);
            this.innerTask = c;
            this.execTimeNanos = execTimeNanos;
            this.period = 0L;
            this.seqno = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Runnable r, V result, long execTimeNanos) {
            super(r, result);
            this.innerTask = r;
            this.execTimeNanos = execTimeNanos;
            this.period = 0L;
            this.seqno = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Runnable r, V result, long execTimeNanos, long period) {
            super(r, result);
            this.innerTask = r;
            this.execTimeNanos = execTimeNanos;
            this.period = period;
            this.seqno = sequencer.getAndIncrement();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.execTimeNanos - NioChannelExecutor.this.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            if (delayed == this) {
                return 0;
            }
            if (delayed instanceof ScheduledFutureTask) {
                ScheduledFutureTask that = (ScheduledFutureTask)delayed;
                long diff = this.execTimeNanos - that.execTimeNanos;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.seqno < that.seqno) {
                    return -1;
                }
                return 1;
            }
            long diff = this.getDelay(TimeUnit.NANOSECONDS) - delayed.getDelay(TimeUnit.NANOSECONDS);
            return Long.signum(diff);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        @Override
        public void run() {
            boolean periodic = this.isPeriodic();
            if (!this.canRunTask(periodic)) {
                this.cancel(false);
            } else if (!periodic) {
                super.run();
            } else if (super.runAndReset()) {
                this.setNextTime();
                NioChannelExecutor.this.delayedQueue.add(this);
            }
        }

        @Override
        public void done() {
            if (!this.isCancelled()) {
                try {
                    this.get();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected exception: " + e, e);
                }
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled) {
                if (NioChannelExecutor.this.inExecutorThread()) {
                    this.removeCancelledTaskIfNeeded();
                } else {
                    NioChannelExecutor.this.execute(new PrintableFutureTask(new Runnable(){

                        @Override
                        public void run() {
                            ScheduledFutureTask.this.removeCancelledTaskIfNeeded();
                        }

                        public String toString() {
                            return "Removing " + ScheduledFutureTask.this.innerTask;
                        }
                    }));
                }
            }
            return cancelled;
        }

        private void removeCancelledTaskIfNeeded() {
            if (NioChannelExecutor.this.cancelledTaskCountdown-- == 0) {
                Iterator iter = NioChannelExecutor.this.delayedQueue.iterator();
                while (iter.hasNext()) {
                    if (!((ScheduledFutureTask)iter.next()).isCancelled()) continue;
                    iter.remove();
                }
                NioChannelExecutor.this.cancelledTaskCountdown = 1024;
            }
        }

        private void setNextTime() {
            if (this.period > 0L) {
                this.execTimeNanos += this.period;
            } else if (this.period < 0L) {
                this.execTimeNanos = NioChannelExecutor.this.getDelayedTime(-this.period);
            }
        }

        private boolean canRunTask(boolean periodic) {
            if (NioChannelExecutor.this.state == State.RUNNING) {
                return true;
            }
            return NioChannelExecutor.this.state == State.SHUTDOWN && !periodic;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append(": seqno=").append(this.seqno).append(" execTimeNanos=").append(this.execTimeNanos).append(" period=").append(this.period).append(" task=").append(this.innerTask);
            return builder.toString();
        }
    }

    public static interface TaskTimeCalculator {
        public long getTaskTimeNanos(long var1);
    }

    static enum State {
        RUNNING,
        SHUTTINGDOWN,
        SHUTDOWN,
        STOP,
        TERMINATED;

    }
}

