/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;
import oracle.kv.impl.async.AsyncIterationHandleImpl;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class AsyncPublisherImpl<E>
implements Publisher<E> {
    private final Supplier<AsyncIterationHandleImpl<E>> handleSupplier;
    private boolean used;
    private final Logger logger;

    private AsyncPublisherImpl(Supplier<AsyncIterationHandleImpl<E>> handleSupplier, Logger logger) {
        this.handleSupplier = handleSupplier;
        this.logger = logger;
    }

    public static <E> Publisher<E> newInstance(Supplier<AsyncIterationHandleImpl<E>> handleSupplier, Logger logger) {
        return new AsyncPublisherImpl<E>(handleSupplier, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Subscriber<? super E> subscriber) {
        AsyncIterationHandleImpl<? super E> handle;
        Objects.requireNonNull(subscriber, "The subscriber must not be null");
        AsyncPublisherImpl asyncPublisherImpl = this;
        synchronized (asyncPublisherImpl) {
            if (this.used) {
                this.logger.warning("Calling subscribe more than once on this publisher is not permitted, subscriber: " + subscriber);
                return;
            }
            this.used = true;
        }
        try {
            handle = this.handleSupplier.get();
        }
        catch (Exception e) {
            subscriber.onSubscribe(new Subscription(){

                @Override
                public void cancel() {
                }

                @Override
                public void request(long n) {
                }
            });
            subscriber.onError(e);
            return;
        }
        handle.subscribe(subscriber);
    }
}

