/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.util.logging.Logger;
import oracle.kv.impl.async.AbstractEndpointGroup;
import oracle.kv.impl.async.AbstractListener;
import oracle.kv.impl.async.DialogHandler;
import oracle.kv.impl.async.EndpointHandler;
import oracle.kv.impl.async.EndpointHandlerManager;
import oracle.kv.impl.async.ListenerConfig;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.NullDialogStart;
import oracle.kv.impl.async.ResponderEndpoint;
import oracle.kv.impl.async.exception.ConnectionNotEstablishedException;
import oracle.kv.impl.util.ObjectUtil;

public abstract class AbstractResponderEndpoint
implements ResponderEndpoint,
EndpointHandlerManager {
    private final AbstractEndpointGroup endpointGroup;
    private final NetworkAddress remoteAddress;
    private final ListenerConfig listenerConfig;
    private final AbstractListener listener;
    protected volatile EndpointHandler handler;

    public AbstractResponderEndpoint(AbstractEndpointGroup endpointGroup, NetworkAddress remoteAddress, ListenerConfig listenerConfig, AbstractListener listener) {
        ObjectUtil.checkNull("endpointGroup", remoteAddress);
        ObjectUtil.checkNull("remoteAddress", remoteAddress);
        ObjectUtil.checkNull("listenerConfig", listenerConfig);
        ObjectUtil.checkNull("listener", listener);
        this.endpointGroup = endpointGroup;
        this.remoteAddress = remoteAddress;
        this.listenerConfig = listenerConfig;
        this.listener = listener;
    }

    @Override
    public void startDialog(int dialogType, DialogHandler dialogHandler, long timeoutMillis) {
        ObjectUtil.checkNull("dialogHandler", dialogHandler);
        if (this.handler != null) {
            this.handler.startDialog(dialogType, dialogHandler, timeoutMillis);
        } else {
            NullDialogStart.fail(dialogHandler, new ConnectionNotEstablishedException().getDialogException(false), this.endpointGroup.getSchedExecService());
        }
    }

    @Override
    public NetworkAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public ListenerConfig getListenerConfig() {
        return this.listenerConfig;
    }

    @Override
    public int getNumDialogsLimit() {
        if (this.handler == null) {
            return -1;
        }
        return this.handler.getNumDialogsLimit();
    }

    @Override
    public void onHandlerShutdown(EndpointHandler handlerToRemove) {
        if (handlerToRemove != this.handler && this.handler != null) {
            throw new IllegalStateException(String.format("Wrong endpoint handler calling onHandlerShutdown for a responder endpoint, expected=%s, got=%s", this.handler, handlerToRemove));
        }
        this.endpointGroup.removeResponderEndpoint(this);
        this.listener.removeResponderEndpoint(this);
    }

    public void shutdown(String detail, boolean force) {
        this.handler.shutdown(detail, force);
    }

    public Logger getLogger() {
        return this.endpointGroup.getLogger();
    }

    public static class NullEndpoint
    extends AbstractResponderEndpoint {
        NullEndpoint(AbstractEndpointGroup endpointGroup, NetworkAddress remoteAddress, ListenerConfig listenerConfig, AbstractListener listener) {
            super(endpointGroup, remoteAddress, listenerConfig, listener);
            this.handler = null;
        }
    }
}

