/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.BulkWriteOptions;
import oracle.kv.Consistency;
import oracle.kv.Direction;
import oracle.kv.Durability;
import oracle.kv.DurabilityException;
import oracle.kv.EntryStream;
import oracle.kv.FaultException;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.KeyValueVersion;
import oracle.kv.Operation;
import oracle.kv.OperationExecutionException;
import oracle.kv.OperationResult;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.bulk.BulkPut;
import oracle.kv.impl.api.ops.Execute;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiDeleteTable;
import oracle.kv.impl.api.ops.MultiGetTable;
import oracle.kv.impl.api.ops.MultiGetTableKeys;
import oracle.kv.impl.api.ops.Put;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKey;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.SingleKeyOperation;
import oracle.kv.impl.api.table.DeprecatedResults;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.IndexScan;
import oracle.kv.impl.api.table.NameUtils;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.ReturnRowImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.RowReaderImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableKey;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.api.table.TableMetadataHelper;
import oracle.kv.impl.api.table.TableMultiGetBatch;
import oracle.kv.impl.api.table.TableScan;
import oracle.kv.impl.api.table.TableVersionException;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.api.table.ValueReader;
import oracle.kv.impl.api.table.ValueSerializer;
import oracle.kv.impl.async.AsyncIterationHandleImpl;
import oracle.kv.impl.async.AsyncPublisherImpl;
import oracle.kv.impl.async.AsyncTableIterator;
import oracle.kv.impl.async.CompletableFutureHandler;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.client.admin.DdlFuture;
import oracle.kv.impl.query.runtime.QueryKeyRange;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.contextlogger.LogContext;
import oracle.kv.table.ExecutionFuture;
import oracle.kv.table.FieldRange;
import oracle.kv.table.FieldValue;
import oracle.kv.table.IndexKey;
import oracle.kv.table.KeyPair;
import oracle.kv.table.MultiGetResult;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.ReadOptions;
import oracle.kv.table.ReturnRow;
import oracle.kv.table.Row;
import oracle.kv.table.StatementResult;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import oracle.kv.table.TableIterator;
import oracle.kv.table.TableIteratorOptions;
import oracle.kv.table.TableOpExecutionException;
import oracle.kv.table.TableOperation;
import oracle.kv.table.TableOperationFactory;
import oracle.kv.table.TableOperationResult;
import oracle.kv.table.TimeToLive;
import oracle.kv.table.WriteOptions;
import org.reactivestreams.Publisher;

public class TableAPIImpl
implements TableAPI {
    private final KVStoreImpl store;
    private final OpFactory opFactory;
    private final ConcurrentHashMap<String, TableImpl> fetchedTables;
    private int metadataSeqNum;
    private TableMetadataCallback metadataCallback;
    private TableMetadataHelper metadataHelper;

    public TableAPIImpl(KVStoreImpl store) {
        this.store = store;
        this.opFactory = new OpFactory(store.getOperationFactory(), store);
        this.fetchedTables = new ConcurrentHashMap();
        this.metadataSeqNum = 0;
    }

    @Override
    public Table getTable(String fullNamespaceName) throws FaultException {
        return this.getTable(NameUtils.getNamespaceFromQualifiedName(fullNamespaceName), NameUtils.getFullNameFromQualifiedName(fullNamespaceName));
    }

    @Override
    public Table getTable(String namespace, String tableFullName) throws FaultException {
        return this.getTable(namespace, tableFullName, 0);
    }

    public Table getTable(String namespace, String tableFullName, int cost) throws FaultException {
        return this.store.getDispatcher().getTable(this.store, NameUtils.switchToInternalUse(namespace), tableFullName, cost);
    }

    @Override
    public Table getTableById(long tableId) throws FaultException {
        return this.store.getDispatcher().getTableById(this.store, tableId);
    }

    public void setTableMetadataCallback(TableMetadataCallback handler) {
        this.metadataCallback = handler;
    }

    public TableMetadataCallback getTableMetadataCallback() {
        return this.metadataCallback;
    }

    public void setCachedMetadataHelper(TableMetadataHelper helper) {
        this.metadataHelper = helper;
    }

    public TableMetadataHelper getCachedMetadataHelper() {
        return this.metadataHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metadataNotification(int remoteSeqNum) {
        if (this.metadataCallback != null && remoteSeqNum > this.metadataSeqNum) {
            TableAPIImpl tableAPIImpl = this;
            synchronized (tableAPIImpl) {
                if (remoteSeqNum > this.metadataSeqNum) {
                    if (this.metadataCallback != null) {
                        this.metadataCallback.metadataChanged(this.metadataSeqNum, remoteSeqNum);
                    }
                    this.metadataSeqNum = remoteSeqNum;
                }
            }
        }
    }

    @Override
    public Map<String, Table> getTables() throws FaultException {
        return this.getTables(null);
    }

    @Override
    public Map<String, Table> getTables(String namespace) throws FaultException {
        TableMetadata md = this.getTableMetadata();
        if (md == null) {
            return Collections.emptyMap();
        }
        return md.getTables(NameUtils.switchToInternalUse(namespace));
    }

    @Override
    public Set<String> listNamespaces() throws FaultException {
        TableMetadata md = this.getTableMetadata();
        return md == null ? Collections.emptySet() : md.listNamespaces();
    }

    public TableMetadata getTableMetadata() throws FaultException {
        return this.store.getDispatcher().getTableMetadata();
    }

    public List<TableImpl> getSystemTables() {
        ArrayList<TableImpl> sysTables = new ArrayList<TableImpl>();
        for (Table table : this.getTables(null).values()) {
            if (!((TableImpl)table).isSystemTable()) continue;
            sysTables.add((TableImpl)table);
        }
        return sysTables;
    }

    @Override
    public Row get(PrimaryKey rowKeyArg, ReadOptions readOptions) throws FaultException {
        PrimaryKeyImpl rowKey = (PrimaryKeyImpl)rowKeyArg;
        Result result = this.getInternal(rowKey, readOptions, null);
        return this.processGetResult(result, rowKey);
    }

    public Row processGetResult(Result result, PrimaryKeyImpl rowKey) {
        ValueReader<RowImpl> reader = rowKey.getTableImpl().initRowReader(null);
        this.createRowFromGetResult(result, rowKey, reader);
        return reader.getValue();
    }

    public void createRowFromGetResult(Result result, ValueSerializer.RowSerializer rowKey, ValueReader<?> reader) {
        ValueVersion vv = KVStoreImpl.processGetResult(result);
        if (vv == null) {
            reader.reset();
            return;
        }
        ((TableImpl)rowKey.getTable()).readKeyFields(reader, rowKey);
        this.getRowFromValueVersion(vv, rowKey, result.getPreviousExpirationTime(), false, reader);
    }

    public Result getInternal(ValueSerializer.RowSerializer rowKey, ReadOptions readOptions, LogContext lc) throws FaultException {
        return this.store.executeRequest(this.makeGetRequest(rowKey, readOptions, lc));
    }

    private Request makeGetRequest(ValueSerializer.RowSerializer rowKey, ReadOptions readOptions, LogContext lc) {
        TableImpl table = (TableImpl)rowKey.getTable();
        Key key = table.createKeyInternal(rowKey, false);
        return this.store.makeGetRequest(key, table.getId(), TableAPIImpl.getConsistency(readOptions), TableAPIImpl.getTimeout(readOptions), TableAPIImpl.getTimeoutUnit(readOptions), lc);
    }

    @Override
    public CompletableFuture<Row> getAsync(PrimaryKey key, ReadOptions readOptions) {
        ObjectUtil.checkNull("key", key);
        final PrimaryKeyImpl rowKey = (PrimaryKeyImpl)key;
        CompletableFutureHandler<Row> handler = new CompletableFutureHandler<Row>();
        this.store.executeRequest(this.makeGetRequest(rowKey, readOptions, null), new OperationResultHandler<Row>(handler){

            @Override
            Row getResultValue(Result result) {
                return TableAPIImpl.this.processGetResult(result, rowKey);
            }
        });
        return handler;
    }

    @Override
    public Version put(Row rowArg, ReturnRow prevRowArg, WriteOptions writeOptions) throws FaultException {
        RowImpl row = (RowImpl)rowArg;
        Result result = this.putInternal(row, prevRowArg, writeOptions, null);
        return this.processPutResult(result, row, prevRowArg);
    }

    public Version processPutResult(Result result, RowImpl row, ReturnRow prevRowArg) {
        if (result.getSuccess()) {
            row.setExpirationTime(result.getNewExpirationTime());
        }
        this.initReturnRow(prevRowArg, row, result, null);
        return KVStoreImpl.getPutResult(result);
    }

    public void initReturnRowFromResult(ReturnRow rr, ValueSerializer.RowSerializer row, Result result, ValueReader<?> reader) {
        this.initReturnRow(rr, row, result, reader);
    }

    public Result putInternal(ValueSerializer.RowSerializer row, ReturnRow prevRowArg, WriteOptions writeOptions, LogContext lc) throws FaultException {
        ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        return this.store.executeRequestWithPrev(this.makePutRequest(row, rvv, writeOptions, lc), rvv);
    }

    public static ValueSerializer.FieldValueSerializer fillIdentityValue(ValueSerializer.RecordValueSerializer rec, int pos, TableImpl table, int clientIdentityCacheSize, KVStoreImpl store) {
        int colPos;
        if (!table.hasIdentityColumn()) {
            return null;
        }
        ValueSerializer.FieldValueSerializer userValue = rec.get(pos);
        RecordDefImpl rowDef = table.getRowDef();
        FieldValueImpl identityValue = store.getIdentityNextValue(table, rowDef.getFieldDef(colPos = table.getIdentityColumn()), clientIdentityCacheSize, userValue, colPos);
        if (identityValue != null && rec instanceof RowImpl) {
            ((RowImpl)rec).putInternal(pos, (FieldValue)identityValue, false);
        }
        if (identityValue == null) {
            return userValue;
        }
        return identityValue;
    }

    private Request makePutRequest(ValueSerializer.RowSerializer row, ReturnValueVersion rvv, WriteOptions writeOptions, LogContext lc) {
        TableImpl table = (TableImpl)row.getTable();
        int clientIdentityCacheSize = writeOptions == null ? 0 : writeOptions.getIdentityCacheSize();
        Key key = table.createKeyInternal(row, false, this.store, clientIdentityCacheSize);
        Value value = table.createValueInternal(row, this.store, clientIdentityCacheSize);
        return this.store.makePutRequest(key, value, rvv, table.getId(), TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions), TableAPIImpl.getTTL(row.getTTL(), (Table)table), TableAPIImpl.getUpdateTTL(writeOptions), lc);
    }

    public CompletableFutureHandler<Version> putAsync(Row row, final ReturnRow prevRowArg, WriteOptions writeOptions) {
        ObjectUtil.checkNull("row", row);
        final RowImpl rowImpl = (RowImpl)row;
        final ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        CompletableFutureHandler<Version> handler = new CompletableFutureHandler<Version>();
        this.store.executeRequest(this.makePutRequest(rowImpl, rvv, writeOptions, null), new OperationResultHandler<Version>(handler){

            @Override
            Version getResultValue(Result result) {
                return TableAPIImpl.this.processPutResultWithPrev(result, rowImpl, prevRowArg, rvv);
            }
        });
        return handler;
    }

    Version processPutResultWithPrev(Result result, RowImpl row, ReturnRow prevRowArg, ReturnValueVersion prevValue) {
        KVStoreImpl.resultSetPreviousValue(result, prevValue);
        return this.processPutResult(result, row, prevRowArg);
    }

    @Override
    public Version putIfAbsent(Row rowArg, ReturnRow prevRowArg, WriteOptions writeOptions) throws FaultException {
        RowImpl row = (RowImpl)rowArg;
        Result result = this.putIfAbsentInternal(row, prevRowArg, writeOptions, null);
        return this.processPutResult(result, row, prevRowArg);
    }

    public Result putIfAbsentInternal(ValueSerializer.RowSerializer row, ReturnRow prevRowArg, WriteOptions writeOptions, LogContext lc) throws FaultException {
        ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        return this.store.executeRequestWithPrev(this.makePutIfAbsentRequest(row, rvv, writeOptions, lc), rvv);
    }

    private Request makePutIfAbsentRequest(ValueSerializer.RowSerializer row, ReturnValueVersion rvv, WriteOptions writeOptions, LogContext lc) {
        TableImpl table = (TableImpl)row.getTable();
        int clientIdentityCacheSize = writeOptions == null ? 0 : writeOptions.getIdentityCacheSize();
        Key key = table.createKeyInternal(row, false, this.store, clientIdentityCacheSize);
        Value value = table.createValueInternal(row, this.store, clientIdentityCacheSize);
        return this.store.makePutIfAbsentRequest(key, value, rvv, table.getId(), TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions), TableAPIImpl.getTTL(row.getTTL(), (Table)table), TableAPIImpl.getUpdateTTL(writeOptions), lc);
    }

    public CompletableFutureHandler<Version> putIfAbsentAsync(Row row, final ReturnRow prevRowArg, WriteOptions writeOptions) {
        ObjectUtil.checkNull("row", row);
        final RowImpl rowImpl = (RowImpl)row;
        final ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        CompletableFutureHandler<Version> handler = new CompletableFutureHandler<Version>();
        this.store.executeRequest(this.makePutIfAbsentRequest(rowImpl, rvv, writeOptions, null), new OperationResultHandler<Version>(handler){

            @Override
            Version getResultValue(Result result) {
                return TableAPIImpl.this.processPutResultWithPrev(result, rowImpl, prevRowArg, rvv);
            }
        });
        return handler;
    }

    @Override
    public Version putIfPresent(Row rowArg, ReturnRow prevRowArg, WriteOptions writeOptions) throws FaultException {
        RowImpl row = (RowImpl)rowArg;
        Result result = this.putIfPresentInternal(row, prevRowArg, writeOptions, null);
        return this.processPutResult(result, row, prevRowArg);
    }

    public Result putIfPresentInternal(ValueSerializer.RowSerializer row, ReturnRow prevRowArg, WriteOptions writeOptions, LogContext lc) throws FaultException {
        ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        return this.store.executeRequestWithPrev(this.makePutIfPresentRequest(row, rvv, writeOptions, lc), rvv);
    }

    private Request makePutIfPresentRequest(ValueSerializer.RowSerializer row, ReturnValueVersion rvv, WriteOptions writeOptions, LogContext lc) {
        TableImpl table = (TableImpl)row.getTable();
        int clientIdentityCacheSize = writeOptions == null ? 0 : writeOptions.getIdentityCacheSize();
        Key key = table.createKeyInternal(row, false, this.store, clientIdentityCacheSize);
        Value value = table.createValueInternal(row, this.store, clientIdentityCacheSize);
        return this.store.makePutIfPresentRequest(key, value, rvv, table.getId(), TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions), TableAPIImpl.getTTL(row.getTTL(), (Table)table), TableAPIImpl.getUpdateTTL(writeOptions), lc);
    }

    public CompletableFutureHandler<Version> putIfPresentAsync(Row row, final ReturnRow prevRowArg, WriteOptions writeOptions) {
        ObjectUtil.checkNull("row", row);
        final RowImpl rowImpl = (RowImpl)row;
        final ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        CompletableFutureHandler<Version> handler = new CompletableFutureHandler<Version>();
        this.store.executeRequest(this.makePutIfPresentRequest(rowImpl, rvv, writeOptions, null), new OperationResultHandler<Version>(handler){

            @Override
            Version getResultValue(Result result) {
                return TableAPIImpl.this.processPutResultWithPrev(result, rowImpl, prevRowArg, rvv);
            }
        });
        return handler;
    }

    @Override
    public Version putIfVersion(Row rowArg, Version matchVersion, ReturnRow prevRowArg, WriteOptions writeOptions) throws FaultException {
        RowImpl row = (RowImpl)rowArg;
        Result result = this.putIfVersionInternal(row, matchVersion, prevRowArg, writeOptions, null);
        return this.processPutResult(result, row, prevRowArg);
    }

    public Result putIfVersionInternal(ValueSerializer.RowSerializer row, Version matchVersion, ReturnRow prevRowArg, WriteOptions writeOptions, LogContext lc) throws FaultException {
        ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        return this.store.executeRequestWithPrev(this.makePutIfVersionRequest(row, matchVersion, rvv, writeOptions, lc), rvv);
    }

    private Request makePutIfVersionRequest(ValueSerializer.RowSerializer row, Version matchVersion, ReturnValueVersion rvv, WriteOptions writeOptions, LogContext lc) {
        TableImpl table = (TableImpl)row.getTable();
        int clientIdentityCacheSize = writeOptions == null ? 0 : writeOptions.getIdentityCacheSize();
        Key key = table.createKeyInternal(row, false, this.store, clientIdentityCacheSize);
        Value value = table.createValueInternal(row, this.store, clientIdentityCacheSize);
        return this.store.makePutIfVersionRequest(key, value, matchVersion, rvv, table.getId(), TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions), TableAPIImpl.getTTL(row.getTTL(), (Table)table), TableAPIImpl.getUpdateTTL(writeOptions), lc);
    }

    public CompletableFutureHandler<Version> putIfVersionAsync(Row row, Version matchVersion, final ReturnRow prevRowArg, WriteOptions writeOptions) {
        ObjectUtil.checkNull("row", row);
        final RowImpl rowImpl = (RowImpl)row;
        final ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        CompletableFutureHandler<Version> handler = new CompletableFutureHandler<Version>();
        this.store.executeRequest(this.makePutIfVersionRequest(rowImpl, matchVersion, rvv, writeOptions, null), new OperationResultHandler<Version>(handler){

            @Override
            Version getResultValue(Result result) {
                return TableAPIImpl.this.processPutResultWithPrev(result, rowImpl, prevRowArg, rvv);
            }
        });
        return handler;
    }

    @Override
    public void put(List<EntryStream<Row>> rowStreams, BulkWriteOptions writeOptions) {
        if (rowStreams == null || rowStreams.isEmpty()) {
            throw new IllegalArgumentException("The stream list cannot be null or empty.");
        }
        if (rowStreams.contains(null)) {
            throw new IllegalArgumentException("Elements of stream list must not be null.");
        }
        final HashMap tablesUsed = new HashMap();
        BulkWriteOptions options = writeOptions != null ? writeOptions : new BulkWriteOptions(TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions));
        BulkPut<Row> bulkPut = new BulkPut<Row>(this.store, options, rowStreams, this.store.getLogger()){

            @Override
            public BulkPut.StreamReader<Row> createReader(int streamId, EntryStream<Row> stream) {
                return new BulkPut.StreamReader<Row>(streamId, stream){

                    @Override
                    protected Key getKey(Row row) {
                        return ((RowImpl)row).getPrimaryKey(false);
                    }

                    @Override
                    protected Value getValue(Row row) {
                        return ((RowImpl)row).createValue();
                    }

                    @Override
                    protected long getTableId(Row row) {
                        TableImpl table = (TableImpl)row.getTable();
                        tablesUsed.put(table.getFullName(), table);
                        return table.getId();
                    }

                    @Override
                    protected TimeToLive getTTL(Row row) {
                        return TableAPIImpl.getTTL((RowImpl)row, row.getTable());
                    }
                };
            }

            @Override
            protected Row convertToEntry(Key key, Value value) {
                byte[] keyBytes = TableAPIImpl.this.store.getKeySerializer().toByteArray(key);
                TableImpl table = (TableImpl)this.findTableByKey(keyBytes);
                if (table == null) {
                    return null;
                }
                RowImpl row = table.createRowFromKeyBytes(keyBytes);
                assert (row != null);
                ValueVersion vv = new ValueVersion(value, null);
                return row.rowFromValueVersion(vv, false) ? row : null;
            }

            private Table findTableByKey(byte[] keyBytes) {
                for (TableImpl table : tablesUsed.values()) {
                    TableImpl target = table.findTargetTable(keyBytes);
                    if (target == null) continue;
                    return target;
                }
                return null;
            }
        };
        try {
            bulkPut.execute();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Unexpected interrupt during putBulk()", e);
        }
    }

    @Override
    @Deprecated
    public ExecutionFuture execute(String statement) throws IllegalArgumentException, FaultException {
        return new DeprecatedResults.ExecutionFutureWrapper(this.store.execute(statement));
    }

    @Override
    @Deprecated
    public StatementResult executeSync(String statement) throws FaultException {
        return new DeprecatedResults.StatementResultWrapper(this.store.executeSync(statement));
    }

    @Override
    @Deprecated
    public ExecutionFuture getFuture(int planId) {
        if (planId < 1) {
            throw new IllegalArgumentException("PlanId " + planId + " isn't valid, must be > 1");
        }
        byte[] futureBytes = DdlFuture.toByteArray(planId);
        return new DeprecatedResults.ExecutionFutureWrapper(this.store.getFuture(futureBytes));
    }

    @Override
    public List<Row> multiGet(PrimaryKey rowKeyArg, MultiRowOptions getOptions, ReadOptions readOptions) throws FaultException {
        return this.processMultiResults(rowKeyArg, getOptions, this.store.executeRequest(this.makeMultiGetTableRequest(rowKeyArg, getOptions, readOptions)));
    }

    private Request makeMultiGetTableRequest(PrimaryKey rowKey, MultiRowOptions getOptions, ReadOptions readOptions) {
        Table table = rowKey.getTable();
        TableKey key = TableKey.createKey(table, rowKey, true);
        if (!key.getMajorKeyComplete()) {
            throw new IllegalArgumentException("Cannot perform multiGet on a primary key without a complete major path");
        }
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, table, false);
        }
        byte[] parentKeyBytes = this.store.getKeySerializer().toByteArray(key.getKey());
        PartitionId partitionId = this.store.getDispatcher().getPartitionId(parentKeyBytes);
        MultiGetTable get = new MultiGetTable(parentKeyBytes, TableAPIImpl.makeTargetTables(table, getOptions), TableAPIImpl.makeKeyRange(key, getOptions));
        return this.store.makeReadRequest((InternalOperation)get, partitionId, TableAPIImpl.getConsistency(readOptions), TableAPIImpl.getTimeout(readOptions), TableAPIImpl.getTimeoutUnit(readOptions), null);
    }

    public CompletableFutureHandler<List<Row>> multiGetAsync(final PrimaryKey key, final MultiRowOptions getOptions, ReadOptions readOptions) {
        ObjectUtil.checkNull("key", key);
        CompletableFutureHandler<List<Row>> handler = new CompletableFutureHandler<List<Row>>();
        this.store.executeRequest(this.makeMultiGetTableRequest(key, getOptions, readOptions), new OperationResultHandler<List<Row>>(handler){

            @Override
            List<Row> getResultValue(Result result) {
                return TableAPIImpl.this.processMultiResults(key, getOptions, result);
            }
        });
        return handler;
    }

    @Override
    public List<PrimaryKey> multiGetKeys(PrimaryKey rowKeyArg, MultiRowOptions getOptions, ReadOptions readOptions) throws FaultException {
        Result result = this.store.executeRequest(this.makeMultiGetTableKeysRequest(rowKeyArg, getOptions, readOptions));
        return this.processMultiResults(rowKeyArg, getOptions, result.getKeyList());
    }

    private Request makeMultiGetTableKeysRequest(PrimaryKey rowKey, MultiRowOptions getOptions, ReadOptions readOptions) {
        Table table = rowKey.getTable();
        TableKey key = TableKey.createKey(table, rowKey, true);
        if (!key.getMajorKeyComplete()) {
            throw new IllegalArgumentException("Cannot perform multiGet on a primary key without a complete major path");
        }
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, table, false);
        }
        byte[] parentKeyBytes = this.store.getKeySerializer().toByteArray(key.getKey());
        PartitionId partitionId = this.store.getDispatcher().getPartitionId(parentKeyBytes);
        MultiGetTableKeys get = new MultiGetTableKeys(parentKeyBytes, TableAPIImpl.makeTargetTables(table, getOptions), TableAPIImpl.makeKeyRange(key, getOptions), 1);
        return this.store.makeReadRequest((InternalOperation)get, partitionId, TableAPIImpl.getConsistency(readOptions), TableAPIImpl.getTimeout(readOptions), TableAPIImpl.getTimeoutUnit(readOptions), null);
    }

    public CompletableFutureHandler<List<PrimaryKey>> multiGetKeysAsync(final PrimaryKey key, final MultiRowOptions getOptions, ReadOptions readOptions) {
        ObjectUtil.checkNull("key", key);
        CompletableFutureHandler<List<PrimaryKey>> handler = new CompletableFutureHandler<List<PrimaryKey>>();
        this.store.executeRequest(this.makeMultiGetTableKeysRequest(key, getOptions, readOptions), new OperationResultHandler<List<PrimaryKey>>(handler){

            @Override
            List<PrimaryKey> getResultValue(Result result) {
                return TableAPIImpl.this.processMultiResults(key, getOptions, result.getKeyList());
            }
        });
        return handler;
    }

    @Override
    public TableIterator<Row> tableIterator(PrimaryKey rowKeyArg, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        return this.tableIterator(rowKeyArg, getOptions, iterateOptions, null);
    }

    public TableIterator<Row> tableIterator(PrimaryKey rowKeyArg, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, Set<Integer> partitions) throws FaultException {
        return this.tableIterator(rowKeyArg, getOptions, iterateOptions, partitions, null);
    }

    private AsyncTableIterator<Row> tableIterator(PrimaryKey rowKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, Set<Integer> partitions, AsyncIterationHandleImpl<Row> iterationHandle) throws FaultException {
        Table table = rowKey.getTable();
        TableKey key = TableKey.createKey(table, rowKey, true);
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, table, false);
        }
        return TableScan.createTableIterator(this, key, getOptions, iterateOptions, partitions, iterationHandle);
    }

    @Override
    public Publisher<Row> tableIteratorAsync(PrimaryKey key, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        ObjectUtil.checkNull("key", key);
        Logger logger = this.store.getLogger();
        return AsyncPublisherImpl.newInstance(() -> {
            AsyncIterationHandleImpl<Row> iterationHandle = new AsyncIterationHandleImpl<Row>(logger);
            iterationHandle.setIterator(this.tableIterator(key, getOptions, iterateOptions, null, iterationHandle));
            return iterationHandle;
        }, logger);
    }

    public MultiGetResult<Row> multiGet(PrimaryKey rowKey, byte[] continuationKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, LogContext lc) throws FaultException {
        ObjectUtil.checkNull("rowKey", rowKey);
        TableKey key = this.getMultiGetKey(rowKey, getOptions, iterateOptions);
        return TableScan.multiGet(this, key, continuationKey, getOptions, iterateOptions, lc);
    }

    public CompletableFutureHandler<MultiGetResult<Row>> multiGetAsync(PrimaryKey rowKey, byte[] continuationKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        ObjectUtil.checkNull("rowKey", rowKey);
        TableKey key = this.getMultiGetKey(rowKey, getOptions, iterateOptions);
        CompletableFutureHandler<MultiGetResult<Row>> handler = new CompletableFutureHandler<MultiGetResult<Row>>();
        TableScan.multiGetAsync(this, key, continuationKey, getOptions, iterateOptions, handler, null);
        return handler;
    }

    public MultiGetResult<PrimaryKey> multiGetKeys(PrimaryKey rowKey, byte[] continuationKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, LogContext lc) throws FaultException {
        TableKey key = this.getMultiGetKey(rowKey, getOptions, iterateOptions);
        return TableScan.multiGetKeys(this, key, continuationKey, getOptions, iterateOptions, lc);
    }

    public CompletableFutureHandler<MultiGetResult<PrimaryKey>> multiGetKeysAsync(PrimaryKey rowKey, byte[] continuationKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        ObjectUtil.checkNull("rowKey", rowKey);
        TableKey key = this.getMultiGetKey(rowKey, getOptions, iterateOptions);
        CompletableFutureHandler<MultiGetResult<PrimaryKey>> handler = new CompletableFutureHandler<MultiGetResult<PrimaryKey>>();
        TableScan.multiGetKeysAsync(this, key, continuationKey, getOptions, iterateOptions, handler, null);
        return handler;
    }

    private TableKey getMultiGetKey(PrimaryKey rowKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        Table table = rowKey.getTable();
        TableKey key = TableKey.createKey(table, rowKey, true);
        boolean hasAncestorOrChild = false;
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, table, false);
            boolean bl = hasAncestorOrChild = getOptions.getIncludedParentTables() != null || getOptions.getIncludedChildTables() != null;
        }
        if (iterateOptions != null) {
            if (iterateOptions.getDirection() != Direction.UNORDERED) {
                throw new IllegalArgumentException("Direction must be Direction.UNORDERED for this operation");
            }
            if (hasAncestorOrChild && iterateOptions.getMaxReadKB() != 0) {
                throw new IllegalArgumentException("Ancestor or child table returns are not supported if the size limitation 'maxReadKB' of TableIteratorOptions is specified.");
            }
        }
        return key;
    }

    public MultiGetResult<Row> multiGet(IndexKey indexKeyArg, byte[] continuationKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, LogContext lc) throws FaultException {
        IndexKeyImpl indexKey = (IndexKeyImpl)indexKeyArg;
        this.checkIndexMultiGetKeyOptions(indexKey.getTable(), getOptions, iterateOptions);
        return IndexScan.multiGet(this, indexKey, continuationKey, getOptions, iterateOptions, lc);
    }

    public CompletableFutureHandler<MultiGetResult<Row>> multiGetAsync(IndexKey indexKeyArg, byte[] continuationKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        IndexKeyImpl indexKey = (IndexKeyImpl)ObjectUtil.checkNull("indexKeyArg", indexKeyArg);
        this.checkIndexMultiGetKeyOptions(indexKey.getTable(), getOptions, iterateOptions);
        CompletableFutureHandler<MultiGetResult<Row>> handler = new CompletableFutureHandler<MultiGetResult<Row>>();
        IndexScan.multiGetAsync(this, indexKey, continuationKey, getOptions, iterateOptions, handler);
        return handler;
    }

    public MultiGetResult<KeyPair> multiGetKeys(IndexKey indexKeyArg, byte[] continuationKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, LogContext lc) throws FaultException {
        IndexKeyImpl indexKey = (IndexKeyImpl)indexKeyArg;
        this.checkIndexMultiGetKeyOptions(indexKey.getTable(), getOptions, iterateOptions);
        return IndexScan.multiGetKeys(this, indexKey, continuationKey, getOptions, iterateOptions, lc);
    }

    public CompletableFutureHandler<MultiGetResult<KeyPair>> multiGetKeysAsync(IndexKey indexKeyArg, byte[] continuationKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        IndexKeyImpl indexKey = (IndexKeyImpl)ObjectUtil.checkNull("indexKeyArg", indexKeyArg);
        this.checkIndexMultiGetKeyOptions(indexKey.getTable(), getOptions, iterateOptions);
        CompletableFutureHandler<MultiGetResult<KeyPair>> hand = new CompletableFutureHandler<MultiGetResult<KeyPair>>();
        IndexScan.multiGetKeysAsync(this, indexKey, continuationKey, getOptions, iterateOptions, hand);
        return hand;
    }

    private void checkIndexMultiGetKeyOptions(Table table, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        boolean hasAncestor = false;
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, table, true);
            boolean bl = hasAncestor = getOptions.getIncludedParentTables() != null;
        }
        if (iterateOptions != null) {
            if (iterateOptions.getDirection() != Direction.UNORDERED) {
                throw new IllegalArgumentException("Direction must be Direction.UNORDERED for this operation");
            }
            if (hasAncestor && iterateOptions.getMaxReadKB() != 0) {
                throw new IllegalArgumentException("Ancestor returns are not supported if the size limitation 'maxReadKB' of TableIteratorOptions is specified");
            }
        }
    }

    @Override
    public TableIterator<PrimaryKey> tableKeysIterator(PrimaryKey rowKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        return this.tableKeysIterator(rowKey, getOptions, iterateOptions, null);
    }

    private AsyncTableIterator<PrimaryKey> tableKeysIterator(PrimaryKey rowKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, AsyncIterationHandleImpl<PrimaryKey> iterationHandle) throws FaultException {
        Table table = rowKey.getTable();
        TableKey key = TableKey.createKey(table, rowKey, true);
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, table, false);
        }
        return TableScan.createTableKeysIterator(this, key, getOptions, iterateOptions, iterationHandle);
    }

    @Override
    public Publisher<PrimaryKey> tableKeysIteratorAsync(PrimaryKey key, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        ObjectUtil.checkNull("key", key);
        Logger logger = this.store.getLogger();
        return AsyncPublisherImpl.newInstance(() -> {
            AsyncIterationHandleImpl<PrimaryKey> iterationHandle = new AsyncIterationHandleImpl<PrimaryKey>(logger);
            iterationHandle.setIterator(this.tableKeysIterator(key, getOptions, iterateOptions, iterationHandle));
            return iterationHandle;
        }, logger);
    }

    @Override
    public boolean delete(PrimaryKey rowKeyArg, ReturnRow prevRowArg, WriteOptions writeOptions) throws FaultException {
        PrimaryKeyImpl rowKey = (PrimaryKeyImpl)rowKeyArg;
        Result result = this.deleteInternal(rowKey, prevRowArg, writeOptions, null);
        this.initReturnRow(prevRowArg, rowKey, result, null);
        return result.getSuccess();
    }

    public Result deleteInternal(ValueSerializer.RowSerializer rowKey, ReturnRow prevRowArg, WriteOptions writeOptions, LogContext lc) throws FaultException {
        ObjectUtil.checkNull("rowKey", rowKey);
        ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        return this.store.executeRequestWithPrev(this.makeDeleteRequest(rowKey, rvv, writeOptions, lc), rvv);
    }

    private Request makeDeleteRequest(ValueSerializer.RowSerializer rowKey, ReturnValueVersion rvv, WriteOptions writeOptions, LogContext lc) {
        TableImpl table = (TableImpl)rowKey.getTable();
        Key key = table.createKeyInternal(rowKey, false);
        return this.store.makeDeleteRequest(key, rvv, TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions), table.getId(), lc);
    }

    public CompletableFutureHandler<Boolean> deleteAsync(PrimaryKey key, final ReturnRow prevRowArg, WriteOptions writeOptions) {
        ObjectUtil.checkNull("key", key);
        final PrimaryKeyImpl rowKey = (PrimaryKeyImpl)key;
        final ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        CompletableFutureHandler<Boolean> handler = new CompletableFutureHandler<Boolean>();
        this.store.executeRequest(this.makeDeleteRequest(rowKey, rvv, writeOptions, null), new OperationResultHandler<Boolean>(handler){

            @Override
            Boolean getResultValue(Result result) {
                KVStoreImpl.resultSetPreviousValue(result, rvv);
                TableAPIImpl.this.initReturnRow(prevRowArg, rowKey, result, null);
                return result.getSuccess();
            }
        });
        return handler;
    }

    @Override
    public boolean deleteIfVersion(PrimaryKey rowKeyArg, Version matchVersion, ReturnRow prevRowArg, WriteOptions writeOptions) throws FaultException {
        PrimaryKeyImpl rowKey = (PrimaryKeyImpl)rowKeyArg;
        Result result = this.deleteIfVersionInternal(rowKey, matchVersion, prevRowArg, writeOptions, null);
        this.initReturnRow(prevRowArg, rowKey, result, null);
        return result.getSuccess();
    }

    public Result deleteIfVersionInternal(ValueSerializer.RowSerializer rowKey, Version matchVersion, ReturnRow prevRowArg, WriteOptions writeOptions, LogContext lc) throws FaultException {
        ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        return this.store.executeRequestWithPrev(this.makeDeleteIfVersionRequest(rowKey, matchVersion, rvv, writeOptions, lc), rvv);
    }

    private Request makeDeleteIfVersionRequest(ValueSerializer.RowSerializer rowKey, Version matchVersion, ReturnValueVersion rvv, WriteOptions writeOptions, LogContext lc) {
        TableImpl table = (TableImpl)rowKey.getTable();
        Key key = table.createKeyInternal(rowKey, false);
        return this.store.makeDeleteIfVersionRequest(key, matchVersion, rvv, TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions), table.getId(), lc);
    }

    public CompletableFutureHandler<Boolean> deleteIfVersionAsync(PrimaryKey key, Version matchVersion, final ReturnRow prevRowArg, WriteOptions writeOptions) {
        ObjectUtil.checkNull("key", key);
        final PrimaryKeyImpl rowKey = (PrimaryKeyImpl)key;
        final ReturnValueVersion rvv = this.makeRVV(prevRowArg);
        CompletableFutureHandler<Boolean> handler = new CompletableFutureHandler<Boolean>();
        this.store.executeRequest(this.makeDeleteIfVersionRequest(rowKey, matchVersion, rvv, writeOptions, null), new OperationResultHandler<Boolean>(handler){

            @Override
            Boolean getResultValue(Result result) {
                KVStoreImpl.resultSetPreviousValue(result, rvv);
                TableAPIImpl.this.initReturnRow(prevRowArg, rowKey, result, null);
                return result.getSuccess();
            }
        });
        return handler;
    }

    @Override
    public int multiDelete(PrimaryKey rowKeyArg, MultiRowOptions getOptions, WriteOptions writeOptions) throws FaultException {
        PrimaryKeyImpl rowKey = (PrimaryKeyImpl)rowKeyArg;
        Result result = this.multiDeleteInternal(rowKey, null, getOptions, writeOptions, null);
        return result.getNDeletions();
    }

    public Result multiDeleteInternal(ValueSerializer.RowSerializer rowKey, byte[] continuationKey, MultiRowOptions getOptions, WriteOptions writeOptions, LogContext lc) throws FaultException {
        return this.store.executeRequest(this.makeMultiDeleteTableRequest(rowKey, continuationKey, getOptions, writeOptions, lc));
    }

    private Request makeMultiDeleteTableRequest(ValueSerializer.RowSerializer rowKey, byte[] continuationKey, MultiRowOptions getOptions, WriteOptions writeOptions, LogContext lc) {
        Table table = rowKey.getTable();
        TableKey key = TableKey.createKeyInternal(table, rowKey, true);
        if (!key.getMajorKeyComplete()) {
            throw new IllegalArgumentException("Cannot perform multiDelete on a primary key without a complete major path.  Key: " + rowKey);
        }
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, table, false);
        }
        KeyRange keyRange = TableAPIImpl.makeKeyRange(key, getOptions);
        byte[] parentKeyBytes = this.store.getKeySerializer().toByteArray(key.getKey());
        PartitionId partitionId = this.store.getDispatcher().getPartitionId(parentKeyBytes);
        MultiDeleteTable del = new MultiDeleteTable(parentKeyBytes, TableAPIImpl.makeTargetTables(table, getOptions), keyRange, continuationKey, TableAPIImpl.getMaxWriteKB(writeOptions));
        return this.store.makeWriteRequest((InternalOperation)del, partitionId, TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions), lc);
    }

    public CompletableFutureHandler<Integer> multiDeleteAsync(PrimaryKey key, MultiRowOptions getOptions, WriteOptions writeOptions) {
        ObjectUtil.checkNull("key", key);
        PrimaryKeyImpl rowKey = (PrimaryKeyImpl)key;
        CompletableFutureHandler<Integer> handler = new CompletableFutureHandler<Integer>();
        this.store.executeRequest(this.makeMultiDeleteTableRequest(rowKey, null, getOptions, writeOptions, null), new OperationResultHandler<Integer>(handler){

            @Override
            Integer getResultValue(Result result) {
                return result.getNDeletions();
            }
        });
        return handler;
    }

    @Override
    public TableIterator<Row> tableIterator(IndexKey indexKeyArg, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        return this.tableIterator(indexKeyArg, getOptions, iterateOptions, null);
    }

    @Override
    public Publisher<Row> tableIteratorAsync(IndexKey key, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        ObjectUtil.checkNull("key", key);
        Logger logger = this.store.getLogger();
        return AsyncPublisherImpl.newInstance(() -> {
            AsyncIterationHandleImpl<Row> iterationHandle = new AsyncIterationHandleImpl<Row>(logger);
            iterationHandle.setIterator(this.tableIterator(key, getOptions, iterateOptions, null, iterationHandle));
            return iterationHandle;
        }, logger);
    }

    public TableIterator<Row> tableIterator(IndexKey indexKeyArg, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, Set<RepGroupId> shardSet) throws FaultException {
        return this.tableIterator(indexKeyArg, getOptions, iterateOptions, shardSet, null);
    }

    private AsyncTableIterator<Row> tableIterator(IndexKey indexKeyArg, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, Set<RepGroupId> shardSet, AsyncIterationHandleImpl<Row> iterationHandle) throws FaultException {
        IndexKeyImpl indexKey = (IndexKeyImpl)indexKeyArg;
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, indexKey.getTable(), true);
        }
        return IndexScan.createTableIterator(this, indexKey, getOptions, iterateOptions, shardSet, iterationHandle);
    }

    @Override
    public TableIterator<KeyPair> tableKeysIterator(IndexKey indexKeyArg, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        return this.tableKeysIterator(indexKeyArg, getOptions, iterateOptions, null);
    }

    @Override
    public Publisher<KeyPair> tableKeysIteratorAsync(IndexKey key, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        ObjectUtil.checkNull("key", key);
        Logger logger = this.store.getLogger();
        return AsyncPublisherImpl.newInstance(() -> {
            AsyncIterationHandleImpl<KeyPair> iterationHandle = new AsyncIterationHandleImpl<KeyPair>(logger);
            iterationHandle.setIterator(this.tableKeysIterator(key, getOptions, iterateOptions, iterationHandle));
            return iterationHandle;
        }, logger);
    }

    private AsyncTableIterator<KeyPair> tableKeysIterator(IndexKey indexKeyArg, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, AsyncIterationHandleImpl<KeyPair> iterationHandle) throws FaultException {
        IndexKeyImpl indexKey = (IndexKeyImpl)indexKeyArg;
        if (getOptions != null) {
            TableAPIImpl.validateMultiRowOptions(getOptions, indexKey.getTable(), true);
        }
        return IndexScan.createTableKeysIterator(this, indexKey, getOptions, iterateOptions, iterationHandle);
    }

    @Override
    public TableOperationFactory getTableOperationFactory() {
        return this.opFactory;
    }

    @Override
    public TableIterator<Row> tableIterator(Iterator<PrimaryKey> primaryKeyIterator, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        if (primaryKeyIterator == null) {
            throw new IllegalArgumentException("Parent key iterator should not be null");
        }
        return this.tableIterator(Collections.singletonList(primaryKeyIterator), getOptions, iterateOptions);
    }

    @Override
    public Publisher<Row> tableIteratorAsync(Iterator<PrimaryKey> primaryKeyIterator, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        ObjectUtil.checkNull("primaryKeyIterator", primaryKeyIterator);
        return this.tableIteratorAsync(Collections.singletonList(primaryKeyIterator), getOptions, iterateOptions);
    }

    @Override
    public TableIterator<PrimaryKey> tableKeysIterator(Iterator<PrimaryKey> primaryKeyIterator, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        if (primaryKeyIterator == null) {
            throw new IllegalArgumentException("Parent key iterator should not be null");
        }
        return this.tableKeysIterator(Collections.singletonList(primaryKeyIterator), getOptions, iterateOptions);
    }

    @Override
    public Publisher<PrimaryKey> tableKeysIteratorAsync(Iterator<PrimaryKey> primaryKeyIterator, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        ObjectUtil.checkNull("primaryKeyIterator", primaryKeyIterator);
        return this.tableKeysIteratorAsync(Collections.singletonList(primaryKeyIterator), getOptions, iterateOptions);
    }

    @Override
    public TableIterator<Row> tableIterator(List<Iterator<PrimaryKey>> primaryKeyIterators, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        return this.tableIterator(primaryKeyIterators, getOptions, iterateOptions, null);
    }

    @Override
    public Publisher<Row> tableIteratorAsync(List<Iterator<PrimaryKey>> primaryKeyIterators, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        ObjectUtil.checkNull("primaryKeyIterators", primaryKeyIterators);
        Logger logger = this.store.getLogger();
        return AsyncPublisherImpl.newInstance(() -> {
            AsyncIterationHandleImpl<Row> iterationHandle = new AsyncIterationHandleImpl<Row>(logger);
            iterationHandle.setIterator(this.tableIterator(primaryKeyIterators, getOptions, iterateOptions, iterationHandle));
            return iterationHandle;
        }, logger);
    }

    private AsyncTableIterator<Row> tableIterator(List<Iterator<PrimaryKey>> primaryKeyIterators, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, AsyncIterationHandleImpl<Row> iterationHandle) throws FaultException {
        if (primaryKeyIterators == null || primaryKeyIterators.isEmpty()) {
            throw new IllegalArgumentException("The key iterator list cannot be null or empty");
        }
        if (primaryKeyIterators.contains(null)) {
            throw new IllegalArgumentException("The element of key iterator list cannot be null.");
        }
        if (iterateOptions != null && iterateOptions.getDirection() != Direction.UNORDERED) {
            throw new IllegalArgumentException("Direction must be Direction.UNORDERED for this operation");
        }
        return new TableMultiGetBatch(this, primaryKeyIterators, getOptions, iterateOptions, iterationHandle).createIterator();
    }

    @Override
    public TableIterator<PrimaryKey> tableKeysIterator(List<Iterator<PrimaryKey>> primaryKeyIterators, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        return this.tableKeysIterator(primaryKeyIterators, getOptions, iterateOptions, null);
    }

    @Override
    public Publisher<PrimaryKey> tableKeysIteratorAsync(List<Iterator<PrimaryKey>> primaryKeyIterators, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        ObjectUtil.checkNull("primaryKeyIterators", primaryKeyIterators);
        Logger logger = this.store.getLogger();
        return AsyncPublisherImpl.newInstance(() -> {
            AsyncIterationHandleImpl<PrimaryKey> iterationHandle = new AsyncIterationHandleImpl<PrimaryKey>(logger);
            iterationHandle.setIterator(this.tableKeysIterator(primaryKeyIterators, getOptions, iterateOptions, iterationHandle));
            return iterationHandle;
        }, logger);
    }

    private AsyncTableIterator<PrimaryKey> tableKeysIterator(List<Iterator<PrimaryKey>> primaryKeyIterators, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, AsyncIterationHandleImpl<PrimaryKey> iterationHandle) throws FaultException {
        if (primaryKeyIterators == null || primaryKeyIterators.isEmpty()) {
            throw new IllegalArgumentException("The key iterator list cannot be null or empty");
        }
        if (primaryKeyIterators.contains(null)) {
            throw new IllegalArgumentException("The element of key iterator list cannot be null.");
        }
        if (iterateOptions != null && iterateOptions.getDirection() != Direction.UNORDERED) {
            throw new IllegalArgumentException("Direction must be Direction.UNORDERED for this operation");
        }
        return new TableMultiGetBatch(this, primaryKeyIterators, getOptions, iterateOptions, iterationHandle).createKeysIterator();
    }

    public TableIterator<KeyValueVersion> tableKVIterator(PrimaryKey rowKeyArg, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) throws FaultException {
        return this.tableKVIterator(rowKeyArg, getOptions, iterateOptions, null);
    }

    public TableIterator<KeyValueVersion> tableKVIterator(PrimaryKey rowKeyArg, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, Set<Integer> partitions) throws FaultException {
        PrimaryKeyImpl rowKey = (PrimaryKeyImpl)rowKeyArg;
        TableImpl table = rowKey.getTable();
        TableKey key = TableKey.createKey(table, rowKey, true);
        if (getOptions != null) {
            throw new IllegalArgumentException("MultiRowOption currently not supported by tableKVIterator");
        }
        return TableScan.createTableKVIterator(this, key, getOptions, iterateOptions, partitions);
    }

    private Put unwrapPut(Operation op) {
        SingleKeyOperation iop = ((Execute.OperationImpl)op).getInternalOp();
        return iop instanceof Put ? (Put)iop : null;
    }

    @Override
    public List<TableOperationResult> execute(List<TableOperation> operations, WriteOptions writeOptions) throws TableOpExecutionException, DurabilityException, FaultException {
        Result result = this.executeInternal(operations, writeOptions, null);
        return this.createResultsFromExecuteResult(result, operations);
    }

    public Result executeInternal(List<TableOperation> operations, WriteOptions writeOptions, LogContext lc) throws TableOpExecutionException, DurabilityException, FaultException {
        Table table = ((OpWrapper)operations.get(0)).getTable();
        List<Operation> kvOperations = this.makeExecuteOps(operations, writeOptions, table);
        Request req = this.store.makeExecuteRequest(kvOperations, ((TableImpl)table).getId(), TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions), lc);
        return this.processExecuteResult(this.store.executeRequest(req), operations, kvOperations);
    }

    private Result processExecuteResult(Result result, List<TableOperation> operations, List<Operation> kvOperations) throws TableOpExecutionException {
        try {
            return KVStoreImpl.processExecuteResult(result, kvOperations);
        }
        catch (OperationExecutionException e) {
            int failedOpIndex = e.getFailedOperationIndex();
            PrimaryKey pkey = operations.get(failedOpIndex).getPrimaryKey();
            OperationResult opResult = e.getFailedOperationResult();
            OpResultWrapper failedResult = new OpResultWrapper(this, opResult, pkey);
            throw new TableOpExecutionException(operations.get(failedOpIndex), failedOpIndex, failedResult, result.getReadKB(), result.getWriteKB());
        }
    }

    public List<TableOperationResult> createResultsFromExecuteResult(Result result, List<TableOperation> operations) {
        List<OperationResult> results = result.getExecuteResult();
        ArrayList<TableOperationResult> tableResults = new ArrayList<TableOperationResult>(results.size());
        int index = 0;
        for (OperationResult opRes : results) {
            PrimaryKey pkey = operations.get(index).getPrimaryKey();
            tableResults.add(new OpResultWrapper(this, opRes, pkey));
            ++index;
        }
        return tableResults;
    }

    private List<Operation> makeExecuteOps(List<TableOperation> operations, WriteOptions writeOptions, Table table) {
        if (operations == null || operations.isEmpty()) {
            throw new IllegalArgumentException("operations must be non-null and non-empty");
        }
        ArrayList<Operation> opList = new ArrayList<Operation>(operations.size());
        for (TableOperation op : operations) {
            Operation operation = ((OpWrapper)op).getOperation(writeOptions);
            opList.add(operation);
            Put putOp = this.unwrapPut(operation);
            if (putOp == null) continue;
            boolean updateTTL = TableAPIImpl.getUpdateTTL(writeOptions) || op.getUpdateTTL();
            putOp.setTTLOptions(TableAPIImpl.getTTL(((OpWrapper)op).getTTL(), table), updateTTL);
        }
        return opList;
    }

    public CompletableFutureHandler<List<TableOperationResult>> executeAsync(final List<TableOperation> operations, WriteOptions writeOptions) {
        ObjectUtil.checkNull("operations", operations);
        Table table = operations.get(0).getPrimaryKey().getTable();
        final List<Operation> kvOperations = this.makeExecuteOps(operations, writeOptions, table);
        CompletableFutureHandler<List<TableOperationResult>> handler = new CompletableFutureHandler<List<TableOperationResult>>();
        this.store.executeRequest(this.store.makeExecuteRequest(kvOperations, ((TableImpl)table).getId(), TableAPIImpl.getDurability(writeOptions), TableAPIImpl.getTimeout(writeOptions), TableAPIImpl.getTimeoutUnit(writeOptions), null), new OperationResultHandler<List<TableOperationResult>>(handler){

            @Override
            List<TableOperationResult> getResultValue(Result result) throws TableOpExecutionException {
                return TableAPIImpl.this.createResultsFromExecuteResult(TableAPIImpl.this.processExecuteResult(result, operations, kvOperations), operations);
            }
        });
        return handler;
    }

    RowImpl getRowFromValueVersion(ValueVersion vv, RowImpl row, long expirationTime, boolean keyOnly) {
        ValueReader<RowImpl> reader = row.initRowReader();
        this.getRowFromValueVersion(vv, row, expirationTime, keyOnly, reader);
        return reader.getValue();
    }

    void getRowFromValueVersion(ValueVersion vv, ValueSerializer.RowSerializer row, long expirationTime, boolean keyOnly, ValueReader<?> reader) {
        TableImpl table = (TableImpl)row.getTable();
        int requiredVersion = 0;
        assert (reader != null);
        try {
            if (keyOnly && row instanceof RowImpl) {
                ((RowImpl)row).removeValueFields();
            }
            reader.setExpirationTime(expirationTime);
            if (!table.readRowFromValueVersion(reader, vv)) {
                reader.reset();
            }
            return;
        }
        catch (TableVersionException tve) {
            requiredVersion = tve.getRequiredVersion();
            assert (requiredVersion > table.getTableVersion());
            reader.reset();
            TableImpl newTable = this.fetchTable(table.getFullName(), requiredVersion);
            assert (requiredVersion == newTable.getTableVersion());
            newTable = (TableImpl)newTable.getVersion(table.getTableVersion());
            RowImpl newRow = newTable.createRow();
            if (reader instanceof RowReaderImpl) {
                RowReaderImpl rr = (RowReaderImpl)reader;
                rr.setValue(newRow);
            }
            newTable.readKeyFields(reader, row);
            reader.setExpirationTime(expirationTime);
            if (!newTable.readRowFromValueVersion(reader, vv)) {
                reader.reset();
            }
            return;
        }
    }

    TableImpl fetchTable(String tableName, int tableVersion) {
        TableImpl table = this.fetchedTables.get(tableName);
        if (table != null && table.numTableVersions() >= tableVersion) {
            return (TableImpl)table.getVersion(tableVersion);
        }
        table = (TableImpl)this.getTable(tableName);
        if (table != null && table.numTableVersions() >= tableVersion) {
            TableImpl t = this.fetchedTables.putIfAbsent(tableName, table);
            if (t != null && table.numTableVersions() > t.numTableVersions()) {
                this.fetchedTables.put(tableName, table);
            }
            return (TableImpl)table.getVersion(tableVersion);
        }
        throw new IllegalArgumentException("Table or version does not exist.  It may have been removed: " + tableName + ", version " + tableVersion);
    }

    public KVStoreImpl getStore() {
        return this.store;
    }

    private ReturnValueVersion makeRVV(ReturnRow rr) {
        if (rr != null) {
            return ((ReturnRowImpl)rr).makeReturnValueVersion();
        }
        return null;
    }

    private void initReturnRow(ReturnRow rr, ValueSerializer.RowSerializer row, Result result, ValueReader<?> reader) {
        if (rr != null) {
            ReturnValueVersion rvv = this.makeRVV(rr);
            rvv.setValue(result.getPreviousValue());
            rvv.setVersion(result.getPreviousVersion());
            ValueReader<?> rowReader = reader != null ? reader : ((RowImpl)((Object)rr)).initRowReader();
            ((ReturnRowImpl)rr).init(this, rvv, row, result.getPreviousExpirationTime(), rowReader);
        }
    }

    static KeyRange makeKeyRange(TableKey key, MultiRowOptions getOptions) {
        if (getOptions != null) {
            FieldRange range = getOptions.getFieldRange();
            if (range != null) {
                if (key.getKeyComplete()) {
                    throw new IllegalArgumentException("Cannot specify a FieldRange with a complete primary key");
                }
                key.validateFieldOrder(range);
                return TableAPIImpl.createKeyRange(range);
            }
        } else {
            key.validateFields();
        }
        return null;
    }

    public static KeyRange createKeyRange(FieldRange range) {
        return TableAPIImpl.createKeyRange(range, false);
    }

    public static KeyRange createKeyRange(FieldRange range, boolean forQuery) {
        if (range == null) {
            return null;
        }
        String start = null;
        String end = null;
        boolean startInclusive = true;
        boolean endInclusive = true;
        if (range.getStart() != null) {
            start = ((FieldValueImpl)range.getStart()).formatForKey(range.getDefinition(), range.getStorageSize());
            startInclusive = range.getStartInclusive();
        }
        if (range.getEnd() != null) {
            end = ((FieldValueImpl)range.getEnd()).formatForKey(range.getDefinition(), range.getStorageSize());
            endInclusive = range.getEndInclusive();
        }
        if (forQuery) {
            return new QueryKeyRange(start, startInclusive, end, endInclusive);
        }
        return new KeyRange(start, startInclusive, end, endInclusive);
    }

    private List<PrimaryKey> processMultiResults(PrimaryKey rowKey, MultiRowOptions getOptions, List<ResultKey> keys) {
        ArrayList<PrimaryKey> list = new ArrayList<PrimaryKey>(keys.size());
        boolean hasAncestorTables = getOptions != null && getOptions.getIncludedParentTables() != null;
        TableImpl t = (TableImpl)rowKey.getTable();
        if (hasAncestorTables) {
            t = t.getTopLevelTable();
        }
        for (ResultKey key : keys) {
            PrimaryKeyImpl pk = t.createPrimaryKeyFromResultKey(key);
            if (pk == null) continue;
            list.add(pk);
        }
        return list;
    }

    private List<Row> processMultiResults(PrimaryKey rowKey, MultiRowOptions getOptions, Result result) {
        List<ResultKeyValueVersion> resultList = result.getKeyValueVersionList();
        ArrayList<Row> list = new ArrayList<Row>(resultList.size());
        boolean hasAncestorTables = getOptions != null && getOptions.getIncludedParentTables() != null;
        TableImpl t = (TableImpl)rowKey.getTable();
        if (hasAncestorTables) {
            t = t.getTopLevelTable();
        }
        for (ResultKeyValueVersion rkvv : result.getKeyValueVersionList()) {
            RowImpl row = t.createRowFromKeyBytes(rkvv.getKeyBytes());
            if (row == null) continue;
            ValueVersion vv = new ValueVersion(rkvv.getValue(), rkvv.getVersion());
            list.add(this.getRowFromValueVersion(vv, row, rkvv.getExpirationTime(), false));
        }
        return list;
    }

    static void validateMultiRowOptions(MultiRowOptions mro, Table targetTable, boolean isIndex) {
        if (mro.getIncludedParentTables() != null) {
            for (Table t : mro.getIncludedParentTables()) {
                if (((TableImpl)targetTable).isAncestor(t)) continue;
                throw new IllegalArgumentException("Ancestor table \"" + t.getFullName() + "\" is not an ancestor of target table \"" + targetTable.getFullName() + "\"");
            }
        }
        if (mro.getIncludedChildTables() != null) {
            if (isIndex) {
                throw new UnsupportedOperationException("Child table returns are not supported for index scan operations");
            }
            for (Table t : mro.getIncludedChildTables()) {
                if (((TableImpl)t).isAncestor(targetTable)) continue;
                throw new IllegalArgumentException("Child table \"" + t.getFullName() + "\" is not a descendant of target table \"" + targetTable.getFullName() + "\"");
            }
        }
    }

    public static Consistency getConsistency(ReadOptions opts) {
        return opts != null ? opts.getConsistency() : null;
    }

    public static long getTimeout(ReadOptions opts) {
        return opts != null ? opts.getTimeout() : 0L;
    }

    public static TimeUnit getTimeoutUnit(ReadOptions opts) {
        return opts != null ? opts.getTimeoutUnit() : null;
    }

    static Direction getDirection(TableIteratorOptions opts, TableKey key) {
        if (opts == null) {
            return key.getMajorKeyComplete() ? Direction.FORWARD : Direction.UNORDERED;
        }
        return opts.getDirection();
    }

    public static int getBatchSize(TableIteratorOptions opts) {
        return opts != null && opts.getResultsBatchSize() != 0 ? opts.getResultsBatchSize() : (opts != null && opts.getMaxReadKB() == 0 ? KVStoreImpl.DEFAULT_ITERATOR_BATCH_SIZE : 0);
    }

    public static int getMaxReadKB(TableIteratorOptions opts) {
        return opts != null && opts.getMaxReadKB() != 0 ? opts.getMaxReadKB() : 0;
    }

    static Durability getDurability(WriteOptions opts) {
        return opts != null ? opts.getDurability() : null;
    }

    static long getTimeout(WriteOptions opts) {
        return opts != null ? opts.getTimeout() : 0L;
    }

    static TimeUnit getTimeoutUnit(WriteOptions opts) {
        return opts != null ? opts.getTimeoutUnit() : null;
    }

    public static TimeToLive getTTL(RowImpl row, Table table) {
        TimeToLive ttl = row.getTTLAndClearExpiration();
        return TableAPIImpl.getTTL(ttl, table);
    }

    private static TimeToLive getTTL(TimeToLive ttl, Table table) {
        return ttl != null ? ttl : table.getDefaultTTL();
    }

    static boolean getUpdateTTL(WriteOptions opts) {
        return opts != null ? opts.getUpdateTTL() : false;
    }

    static int getMaxWriteKB(WriteOptions opts) {
        return opts != null && opts.getMaxWriteKB() != 0 ? opts.getMaxWriteKB() : 0;
    }

    static TargetTables makeTargetTables(Table target, MultiRowOptions getOptions) {
        List<Table> childTables = getOptions != null ? getOptions.getIncludedChildTables() : null;
        List<Table> ancestorTables = getOptions != null ? getOptions.getIncludedParentTables() : null;
        return new TargetTables(target, childTables, ancestorTables);
    }

    public TableMetadataHelper getTableMetadataHelper() {
        if (this.metadataHelper != null) {
            return this.metadataHelper;
        }
        return new MetadataHelper(this);
    }

    public static interface TableMetadataCallback {
        public void metadataChanged(int var1, int var2);
    }

    private static class MetadataHelper
    implements TableMetadataHelper {
        private final TableAPIImpl tableAPI;

        MetadataHelper(TableAPIImpl tableAPI) {
            this.tableAPI = tableAPI;
        }

        @Override
        public TableImpl getTable(String namespace, String tableName) {
            return (TableImpl)this.tableAPI.getTable(namespace, tableName);
        }

        @Override
        public TableImpl getTable(String namespace, String[] tablePath, int cost) {
            if (tablePath == null || tablePath.length == 0) {
                return null;
            }
            TableImpl targetTable = (TableImpl)this.tableAPI.getTable(namespace, tablePath[0], cost);
            if (tablePath.length > 1) {
                for (int i = 1; i < tablePath.length && targetTable != null; targetTable = targetTable.getChildTable(tablePath[i]), ++i) {
                    try {
                        continue;
                    }
                    catch (IllegalArgumentException ignored) {
                        targetTable = null;
                        break;
                    }
                }
            }
            return targetTable;
        }
    }

    public static class OpFactory
    implements TableOperationFactory {
        private final Execute.OperationFactoryImpl factory;
        private final KVStoreImpl store;

        private OpFactory(Execute.OperationFactoryImpl factory, KVStoreImpl store) {
            this.factory = factory;
            this.store = store;
        }

        @Override
        public TableOperation createPut(Row rowArg, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            return new OpWrapper(TableOperation.Type.PUT, (ValueSerializer.RowSerializer)((RowImpl)rowArg), prevReturn, abortIfUnsuccessful, this.factory, this.store);
        }

        public TableOperation createPutInternal(ValueSerializer.RowSerializer row, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            ReturnValueVersion.Choice choice = ReturnRowImpl.mapChoice(prevReturn);
            TableImpl table = (TableImpl)row.getTable();
            Key key = table.createKeyInternal(row, false);
            Value value = table.createValueInternal(row);
            Operation op = this.factory.createPut(key, value, choice, abortIfUnsuccessful, table.getId());
            return new OpWrapper(op, TableOperation.Type.PUT, row);
        }

        @Override
        public TableOperation createPutIfAbsent(Row rowArg, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            return new OpWrapper(TableOperation.Type.PUT_IF_ABSENT, (ValueSerializer.RowSerializer)((RowImpl)rowArg), prevReturn, abortIfUnsuccessful, this.factory, this.store);
        }

        public TableOperation createPutIfAbsentInternal(ValueSerializer.RowSerializer row, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            ReturnValueVersion.Choice choice = ReturnRowImpl.mapChoice(prevReturn);
            TableImpl table = (TableImpl)row.getTable();
            Key key = table.createKeyInternal(row, false);
            Value value = table.createValueInternal(row);
            Operation op = this.factory.createPutIfAbsent(key, value, choice, abortIfUnsuccessful, table.getId());
            return new OpWrapper(op, TableOperation.Type.PUT_IF_ABSENT, row);
        }

        @Override
        public TableOperation createPutIfPresent(Row rowArg, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            return new OpWrapper(TableOperation.Type.PUT_IF_PRESENT, (ValueSerializer.RowSerializer)((RowImpl)rowArg), prevReturn, abortIfUnsuccessful, this.factory, this.store);
        }

        public TableOperation createPutIfPresentInternal(ValueSerializer.RowSerializer row, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            ReturnValueVersion.Choice choice = ReturnRowImpl.mapChoice(prevReturn);
            TableImpl table = (TableImpl)row.getTable();
            Key key = table.createKeyInternal(row, false);
            Value value = table.createValueInternal(row);
            Operation op = this.factory.createPutIfPresent(key, value, choice, abortIfUnsuccessful, table.getId());
            return new OpWrapper(op, TableOperation.Type.PUT_IF_PRESENT, row);
        }

        @Override
        public TableOperation createPutIfVersion(Row rowArg, Version versionMatch, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            return new OpWrapper(TableOperation.Type.PUT_IF_VERSION, (RowImpl)rowArg, prevReturn, abortIfUnsuccessful, versionMatch, this.factory, this.store);
        }

        public TableOperation createPutIfVersionInternal(ValueSerializer.RowSerializer row, Version versionMatch, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            ReturnValueVersion.Choice choice = ReturnRowImpl.mapChoice(prevReturn);
            TableImpl table = (TableImpl)row.getTable();
            Key key = table.createKeyInternal(row, false);
            Value value = table.createValueInternal(row);
            Operation op = this.factory.createPutIfVersion(key, value, versionMatch, choice, abortIfUnsuccessful, table.getId());
            return new OpWrapper(op, TableOperation.Type.PUT_IF_VERSION, row);
        }

        @Override
        public TableOperation createDelete(PrimaryKey keyArg, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            return new OpWrapper(TableOperation.Type.DELETE, (ValueSerializer.RowSerializer)((PrimaryKeyImpl)keyArg), prevReturn, abortIfUnsuccessful, this.factory, this.store);
        }

        public TableOperation createDeleteInternal(ValueSerializer.RowSerializer rowKey, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            ReturnValueVersion.Choice choice = ReturnRowImpl.mapChoice(prevReturn);
            TableImpl table = (TableImpl)rowKey.getTable();
            Key key = table.createKeyInternal(rowKey, false);
            Operation op = this.factory.createDelete(key, choice, abortIfUnsuccessful, table.getId());
            return new OpWrapper(op, TableOperation.Type.DELETE, rowKey);
        }

        @Override
        public TableOperation createDeleteIfVersion(PrimaryKey keyArg, Version versionMatch, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            return new OpWrapper(TableOperation.Type.DELETE_IF_VERSION, (PrimaryKeyImpl)keyArg, prevReturn, abortIfUnsuccessful, versionMatch, this.factory, this.store);
        }

        public TableOperation createDeleteIfVersionInternal(ValueSerializer.RowSerializer rowKey, Version versionMatch, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful) {
            ReturnValueVersion.Choice choice = ReturnRowImpl.mapChoice(prevReturn);
            TableImpl table = (TableImpl)rowKey.getTable();
            Key key = table.createKeyInternal(rowKey, false);
            Operation op = this.factory.createDeleteIfVersion(key, versionMatch, choice, abortIfUnsuccessful, table.getId());
            return new OpWrapper(op, TableOperation.Type.DELETE_IF_VERSION, rowKey);
        }
    }

    public static class OpResultWrapper
    implements TableOperationResult {
        private final TableAPIImpl impl;
        private final OperationResult opRes;
        private final PrimaryKey key;

        private OpResultWrapper(TableAPIImpl impl, OperationResult opRes, PrimaryKey key) {
            this.impl = impl;
            this.opRes = opRes;
            this.key = key;
        }

        @Override
        public Version getNewVersion() {
            return this.opRes.getNewVersion();
        }

        @Override
        public Row getPreviousRow() {
            ValueReader<RowImpl> reader = ((TableImpl)this.key.getTable()).createRow().initRowReader();
            return this.getPreviousRow(reader) ? (Row)reader.getValue() : null;
        }

        @Override
        public Version getPreviousVersion() {
            return this.opRes.getPreviousVersion();
        }

        @Override
        public boolean getSuccess() {
            return this.opRes.getSuccess();
        }

        @Override
        public long getPreviousExpirationTime() {
            return this.opRes.getPreviousExpirationTime();
        }

        public boolean getPreviousRow(ValueReader<?> reader) {
            Value value = this.opRes.getPreviousValue();
            Version version = this.opRes.getPreviousVersion();
            if (value != null && this.key != null) {
                PrimaryKeyImpl rowKey = (PrimaryKeyImpl)this.key;
                ((TableImpl)this.key.getTable()).readKeyFields(reader, rowKey);
                this.impl.getRowFromValueVersion(new ValueVersion(value, version), rowKey, this.opRes.getPreviousExpirationTime(), false, reader);
                return true;
            }
            return false;
        }
    }

    private static class OpWrapper
    implements TableOperation {
        private Operation op;
        private final TableOperation.Type type;
        private final ValueSerializer.RowSerializer record;
        private boolean updateTTL;
        private ReturnRow.Choice prevReturn;
        private boolean abortIfUnsuccessful;
        private Version versionMatch;
        private final Execute.OperationFactoryImpl factory;
        private final KVStoreImpl store;

        private OpWrapper(TableOperation.Type type, ValueSerializer.RowSerializer record, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful, Version versionMatch, Execute.OperationFactoryImpl factory, KVStoreImpl store) {
            this.op = null;
            this.type = type;
            this.record = record;
            this.prevReturn = prevReturn;
            this.abortIfUnsuccessful = abortIfUnsuccessful;
            this.versionMatch = versionMatch;
            this.factory = factory;
            this.store = store;
        }

        private OpWrapper(TableOperation.Type type, ValueSerializer.RowSerializer record, ReturnRow.Choice prevReturn, boolean abortIfUnsuccessful, Execute.OperationFactoryImpl factory, KVStoreImpl store) {
            this(type, record, prevReturn, abortIfUnsuccessful, null, factory, store);
        }

        private OpWrapper(Operation op, TableOperation.Type type, ValueSerializer.RowSerializer record) {
            this.op = op;
            this.type = type;
            this.record = record;
            this.factory = null;
            this.store = null;
        }

        @Override
        public Row getRow() {
            if (this.record instanceof Row) {
                return (Row)((Object)this.record);
            }
            return null;
        }

        @Override
        public PrimaryKey getPrimaryKey() {
            if (this.record instanceof PrimaryKey) {
                return (PrimaryKey)((Object)this.record);
            }
            TableImpl table = (TableImpl)this.record.getTable();
            PrimaryKeyImpl key = table.createPrimaryKey();
            table.readKeyFields(key.initRowReader(), this.record);
            return key;
        }

        @Override
        public TableOperation.Type getType() {
            return this.type;
        }

        @Override
        public boolean getAbortIfUnsuccessful() {
            return this.op.getAbortIfUnsuccessful();
        }

        private Operation getOperation(WriteOptions writeOptions) {
            if (this.op == null) {
                ReturnValueVersion.Choice choice = ReturnRowImpl.mapChoice(this.prevReturn);
                TableImpl table = (TableImpl)this.record.getTable();
                int clientIdentityCacheSize = writeOptions == null ? 0 : writeOptions.getIdentityCacheSize();
                switch (this.type) {
                    case PUT: {
                        Key key = table.createKeyInternal(this.record, false, this.store, clientIdentityCacheSize);
                        Value value = table.createValueInternal(this.record, this.store, clientIdentityCacheSize);
                        this.op = this.factory.createPut(key, value, choice, this.abortIfUnsuccessful, table.getId());
                        break;
                    }
                    case PUT_IF_ABSENT: {
                        Key key = table.createKeyInternal(this.record, false, this.store, clientIdentityCacheSize);
                        Value value = table.createValueInternal(this.record, this.store, clientIdentityCacheSize);
                        this.op = this.factory.createPutIfAbsent(key, value, choice, this.abortIfUnsuccessful, table.getId());
                        break;
                    }
                    case PUT_IF_PRESENT: {
                        Key key = table.createKeyInternal(this.record, false, this.store, clientIdentityCacheSize);
                        Value value = table.createValueInternal(this.record, this.store, clientIdentityCacheSize);
                        this.op = this.factory.createPutIfPresent(key, value, choice, this.abortIfUnsuccessful, table.getId());
                        break;
                    }
                    case PUT_IF_VERSION: {
                        Key key = table.createKeyInternal(this.record, false, this.store, clientIdentityCacheSize);
                        Value value = table.createValueInternal(this.record, this.store, clientIdentityCacheSize);
                        this.op = this.factory.createPutIfVersion(key, value, this.versionMatch, choice, this.abortIfUnsuccessful, table.getId());
                        break;
                    }
                    case DELETE: {
                        Key key = table.createKeyInternal(this.record, false);
                        this.op = this.factory.createDelete(key, choice, this.abortIfUnsuccessful, table.getId());
                        break;
                    }
                    case DELETE_IF_VERSION: {
                        Key key = table.createKeyInternal(this.record, false);
                        this.op = this.factory.createDeleteIfVersion(key, this.versionMatch, choice, this.abortIfUnsuccessful, table.getId());
                    }
                }
            }
            return this.op;
        }

        @Override
        public void setUpdateTTL(boolean flag) {
            this.updateTTL = flag;
        }

        @Override
        public boolean getUpdateTTL() {
            return this.updateTTL;
        }

        TimeToLive getTTL() {
            return this.record.getTTL();
        }

        Table getTable() {
            return this.record.getTable();
        }
    }

    private abstract class OperationResultHandler<V>
    implements ResultHandler<Result> {
        private final ResultHandler<V> handler;

        OperationResultHandler(ResultHandler<V> handler) {
            this.handler = ObjectUtil.checkNull("handler", handler);
        }

        abstract V getResultValue(Result var1) throws Exception;

        @Override
        public void onResult(Result result, Throwable exception) {
            block11: {
                V value;
                if (exception != null) {
                    block9: {
                        try {
                            this.handler.onResult(null, exception);
                        }
                        catch (Throwable t) {
                            Logger logger = TableAPIImpl.this.store.getLogger();
                            if (!logger.isLoggable(Level.FINEST)) break block9;
                            logger.finest("Problem delivering exception to result handler: " + this.handler + " exception being delivered: " + exception + " exception from handler: " + t);
                        }
                    }
                    return;
                }
                try {
                    value = this.getResultValue(result);
                }
                catch (Throwable t) {
                    block10: {
                        try {
                            this.handler.onResult(null, t);
                        }
                        catch (Throwable t2) {
                            Logger logger = TableAPIImpl.this.store.getLogger();
                            if (!logger.isLoggable(Level.FINEST)) break block10;
                            logger.finest("Problem delivering exception to result handler: " + this.handler + " exception being delivered: " + t + " exception from handler: " + t2);
                        }
                    }
                    return;
                }
                try {
                    this.handler.onResult(value, null);
                }
                catch (Throwable t) {
                    Logger logger = TableAPIImpl.this.store.getLogger();
                    if (!logger.isLoggable(Level.FINEST)) break block11;
                    logger.finest("Problem delivering result to result handler: " + this.handler + " result: " + value + " exception from handler: " + t);
                }
            }
        }
    }
}

