/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.Value;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultValue;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;

public class ResultKeyValueVersion
implements FastExternalizable {
    private final byte[] keyBytes;
    private final ResultValue resultValue;
    private final Version version;
    private final long expirationTime;

    public ResultKeyValueVersion(byte[] keyBytes, byte[] valueBytes, Version version, long expirationTime) {
        ObjectUtil.checkNull("keyBytes", keyBytes);
        ObjectUtil.checkNull("version", version);
        this.keyBytes = keyBytes;
        this.resultValue = new ResultValue(valueBytes);
        this.version = version;
        this.expirationTime = expirationTime;
    }

    public ResultKeyValueVersion(DataInput in, short serialVersion) throws IOException {
        this.keyBytes = SerializationUtil.readNonNullByteArrayOldShortLength(in, serialVersion);
        this.resultValue = new ResultValue(in, serialVersion);
        this.version = Version.createVersion(in, serialVersion);
        this.expirationTime = Result.readExpirationTime(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        SerializationUtil.writeNonNullByteArrayOldShortLength(out, serialVersion, this.keyBytes);
        this.resultValue.writeFastExternal(out, serialVersion);
        this.version.writeFastExternal(out, serialVersion);
        Result.writeExpirationTime(out, this.expirationTime, serialVersion);
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public Value getValue() {
        return this.resultValue.getValue();
    }

    public byte[] getValueBytes() {
        return this.resultValue.getBytes();
    }

    public Version getVersion() {
        return this.version;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }
}

