/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.KVStoreImpl;

public class StoreIteratorParams {
    protected final byte[] parentKeyBytes;
    protected final Direction direction;
    protected int batchSize;
    protected int maxReadKB;
    protected final KeyRange subRange;
    protected final Depth depth;
    protected final Consistency consistency;
    protected final long timeout;
    protected final TimeUnit timeoutUnit;
    private final Set<Integer> partitions;

    public StoreIteratorParams(Direction direction, int batchSize, byte[] parentKeyBytes, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit) {
        this(direction, batchSize, parentKeyBytes, subRange, depth, consistency, timeout, timeoutUnit, null);
    }

    public StoreIteratorParams(Direction direction, int batchSize, byte[] parentKeyBytes, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, Set<Integer> partitions) {
        this(direction, batchSize, 0, parentKeyBytes, subRange, depth, consistency, timeout, timeoutUnit, partitions);
    }

    public StoreIteratorParams(Direction direction, int batchSize, int maxReadKB, byte[] parentKeyBytes, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, Set<Integer> partitions) {
        this.batchSize = batchSize > 0 ? batchSize : (maxReadKB == 0 ? KVStoreImpl.DEFAULT_ITERATOR_BATCH_SIZE : 0);
        this.depth = depth != null ? depth : Depth.PARENT_AND_DESCENDANTS;
        this.maxReadKB = maxReadKB;
        this.direction = direction;
        this.parentKeyBytes = parentKeyBytes;
        this.subRange = subRange;
        this.consistency = consistency;
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        this.partitions = partitions;
    }

    public byte[] getParentKeyBytes() {
        return this.parentKeyBytes;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Direction getPartitionDirection() {
        return this.direction == Direction.UNORDERED ? Direction.FORWARD : this.direction;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setMaxReadKB(int maxReadKB) {
        this.maxReadKB = maxReadKB;
    }

    public int getMaxReadKB() {
        return this.maxReadKB;
    }

    public KeyRange getSubRange() {
        return this.subRange;
    }

    public Depth getDepth() {
        return this.depth;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public Set<Integer> getPartitions() {
        return this.partitions;
    }
}

