/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.ValueVersion;
import oracle.kv.impl.util.FastExternalizable;

public class ReturnValueVersion
extends ValueVersion {
    private final Choice returnChoice;

    public ReturnValueVersion(Choice returnChoice) {
        this.returnChoice = returnChoice;
    }

    public Choice getReturnChoice() {
        return this.returnChoice;
    }

    public static enum Choice implements FastExternalizable
    {
        VALUE(0, true, false),
        VERSION(1, false, true),
        ALL(2, true, true),
        NONE(3, false, false);

        private static final Choice[] VALUES;
        private boolean needValue;
        private boolean needVersion;

        private Choice(int ordinal, boolean needValue, boolean needVersion) {
            if (ordinal != this.ordinal()) {
                throw new IllegalArgumentException("Wrong ordinal");
            }
            this.needValue = needValue;
            this.needVersion = needVersion;
        }

        public boolean needValue() {
            return this.needValue;
        }

        public boolean needVersion() {
            return this.needVersion;
        }

        public boolean needValueOrVersion() {
            return this.needValue || this.needVersion;
        }

        public static Choice readFastExternal(DataInput in, short serialVersion) throws IOException {
            int ordinal = in.readUnsignedByte();
            try {
                return VALUES[ordinal];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("unknown Choice: " + ordinal);
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            out.writeByte(this.ordinal());
        }

        static {
            VALUES = Choice.values();
        }
    }
}

