/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.LoadBuildSummary;
import org.eclipse.persistence.testing.framework.LoadBuildSystem;
import org.eclipse.persistence.testing.framework.ResultInterface;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestCollection;
import org.eclipse.persistence.testing.framework.TestResult;
import org.eclipse.persistence.testing.framework.TestWarningException;

public class TestResultsSummary
implements ResultInterface,
Comparable<TestResultsSummary>,
Serializable {
    protected BigDecimal id;
    protected ValueHolderInterface<TestResultsSummary> parent;
    protected String name;
    protected String description;
    protected ValueHolderInterface<Vector<TestResult>> results;
    protected ValueHolderInterface<LoadBuildSummary> loadBuildSummary;
    protected Throwable setupException;
    protected int passed;
    protected int warnings;
    protected int errors;
    protected int problems;
    protected int fatalErrors;
    protected int setupFailures;
    protected int setupWarnings;
    protected int totalTests;
    protected transient TestCollection testCollection;
    protected long totalTime;

    public TestResultsSummary() {
        this.name = "";
        this.description = "";
        this.parent = new ValueHolder();
        this.loadBuildSummary = new ValueHolder();
        this.results = new ValueHolder(new Vector());
        this.passed = 0;
        this.warnings = 0;
        this.errors = 0;
        this.fatalErrors = 0;
        this.setupFailures = 0;
        this.setupWarnings = 0;
        this.totalTests = 0;
    }

    public TestResultsSummary(TestCollection testCollection) {
        this.testCollection = testCollection;
        this.name = testCollection.getName();
        this.description = testCollection.getDescription();
        this.parent = new ValueHolder();
        this.loadBuildSummary = new ValueHolder();
        this.results = new ValueHolder(new Vector());
        this.passed = 0;
        this.warnings = 0;
        this.errors = 0;
        this.fatalErrors = 0;
        this.totalTests = 0;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    @Override
    public int compareTo(TestResultsSummary summary) {
        return this.getName().compareTo(summary.getName());
    }

    public void appendTestCaseResult(TestCase testCase) {
        String testOutcome = testCase.getTestResult().getOutcome();
        this.incrementTotalTests();
        if (testOutcome.equals("Passed")) {
            this.incrementPassed();
        } else if (testOutcome.equals("Warning")) {
            this.incrementWarnings();
        } else if (testOutcome.equals("FatalError")) {
            this.incrementFatalErrors();
        } else if (testOutcome.equals("Error")) {
            this.incrementErrors();
        } else if (testOutcome.equals("Problem")) {
            this.incrementProblems();
        } else if (!testOutcome.equals("You decide")) {
            throw new Error("Wrong test result");
        }
        this.getResults().addElement(testCase.getTestResult());
        testCase.getTestResult().setSummary(this);
        LoadBuildSystem.loadBuild.addSummary(this);
    }

    public void appendTestCollectionResult(TestCollection testCollection) {
        TestResultsSummary testSummary = testCollection.getSummary();
        this.setErrors(this.getErrors() + testSummary.getErrors());
        this.setPassed(this.getPassed() + testSummary.getPassed());
        this.setWarnings(this.getWarnings() + testSummary.getWarnings());
        this.setProblems(this.getProblems() + testSummary.getProblems());
        this.setFatalErrors(this.getFatalErrors() + testSummary.getFatalErrors());
        this.setTotalTests(this.getTotalTests() + testSummary.getTotalTests());
        this.setSetupFailures(this.getSetupFailures() + testSummary.getSetupFailures());
        this.setSetupWarnings(this.getSetupWarnings() + testSummary.getSetupWarnings());
        if (testSummary.didSetupFail()) {
            this.setSetupFailures(this.getSetupFailures() + 1);
        } else if (testSummary.didSetupWarn()) {
            this.setSetupWarnings(this.getSetupWarnings() + 1);
        }
        testCollection.getSummary().setParent(this);
        LoadBuildSystem.loadBuild.addSummary(this);
    }

    public void appendTestResult(junit.framework.TestResult result) {
        this.setErrors(this.getErrors() + result.failureCount());
        this.setPassed(this.getPassed() + result.runCount() - result.failureCount() - result.errorCount());
        this.setFatalErrors(this.getFatalErrors() + result.errorCount());
        this.setTotalTests(this.getTotalTests() + result.runCount());
        LoadBuildSystem.loadBuild.addSummary(this);
    }

    public boolean didSetupFail() {
        return this.getSetupException() != null && !this.didSetupWarn();
    }

    public boolean didSetupWarn() {
        return this.getSetupException() != null && this.getSetupException() instanceof TestWarningException;
    }

    public String getDescription() {
        return this.description;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getFatalErrors() {
        return this.fatalErrors;
    }

    public void setSetupFailures(int setupFailures) {
        this.setupFailures = setupFailures;
    }

    public int getSetupFailures() {
        return this.setupFailures;
    }

    public void setSetupWarnings(int setupWarnings) {
        this.setupWarnings = setupWarnings;
    }

    public int getSetupWarnings() {
        return this.setupWarnings;
    }

    public BigDecimal getId() {
        return this.id;
    }

    public LoadBuildSummary getLoadBuildSummary() {
        return (LoadBuildSummary)this.loadBuildSummary.getValue();
    }

    public ValueHolderInterface<LoadBuildSummary> getLoadBuildSummaryHolder() {
        return this.loadBuildSummary;
    }

    public String getName() {
        return this.name;
    }

    public TestResultsSummary getParent() {
        return (TestResultsSummary)this.parent.getValue();
    }

    public ValueHolderInterface<TestResultsSummary> getParentHolder() {
        return this.parent;
    }

    public int getPassed() {
        return this.passed;
    }

    public int getProblems() {
        return this.problems;
    }

    public Vector<TestResult> getResults() {
        return (Vector)this.results.getValue();
    }

    public ValueHolderInterface<Vector<TestResult>> getResultsHolder() {
        return this.results;
    }

    public Throwable getSetupException() {
        return this.setupException;
    }

    public String getSetupExceptionStackTrace() {
        if (this.setupException != null) {
            StringWriter writer = new StringWriter();
            this.setupException.printStackTrace(new PrintWriter(writer));
            return writer.toString();
        }
        return null;
    }

    public TestCollection getTestCollection() {
        return this.testCollection;
    }

    public int getTotalTests() {
        return this.totalTests;
    }

    public int getWarnings() {
        return this.warnings;
    }

    @Override
    public boolean shouldLogResult() {
        return !this.hasPassed();
    }

    @Override
    public boolean hasPassed() {
        return this.getWarnings() == 0 && this.getFatalErrors() == 0 && this.getProblems() == 0 && this.getErrors() == 0 && !this.didSetupFail() && this.getSetupFailures() == 0 && !this.didSetupWarn() && this.getSetupWarnings() == 0;
    }

    protected void incrementErrors() {
        this.setErrors(this.getErrors() + 1);
    }

    protected void incrementFatalErrors() {
        this.setFatalErrors(this.getFatalErrors() + 1);
    }

    protected void incrementPassed() {
        this.setPassed(this.getPassed() + 1);
    }

    protected void incrementProblems() {
        this.setProblems(this.getProblems() + 1);
    }

    protected void incrementTotalTests() {
        this.setTotalTests(this.getTotalTests() + 1);
    }

    protected void incrementWarnings() {
        this.setWarnings(this.getWarnings() + 1);
    }

    @Override
    public void logResult(Writer log) {
        String indentationString = this.getTestCollection().getIndentationString();
        try {
            if (this.didSetupFail()) {
                log.write(indentationString + Helper.cr() + "## SETUP FAILURE: " + Helper.cr() + this.getSetupException() + Helper.cr());
                PrintWriter printWriter = new PrintWriter(log);
                this.getSetupException().printStackTrace(printWriter);
                log.flush();
            } else if (this.didSetupWarn()) {
                log.write(indentationString + "SETUP WARNING: " + Helper.cr());
                ((TestWarningException)((Object)this.getSetupException())).setIndentationString(indentationString);
                log.write(this.getSetupException() + Helper.cr());
                log.flush();
            } else {
                if (this.getErrors() > 0 || this.getFatalErrors() > 0 || this.getProblems() > 0) {
                    log.write(indentationString + "###ERRORS###" + Helper.cr());
                }
                log.write(indentationString + "Warnings: " + this.getWarnings() + Helper.cr());
                log.write(indentationString + "Problems: " + this.getProblems() + Helper.cr());
                log.write(indentationString + "Errors: " + this.getErrors() + Helper.cr());
                log.write(indentationString + "Fatal Errors: " + this.getFatalErrors() + Helper.cr());
                log.write(indentationString + "Passed: " + this.getPassed() + Helper.cr());
                log.write(indentationString + "Setup Warnings: " + this.getSetupWarnings() + Helper.cr());
                log.write(indentationString + "Setup Failures: " + this.getSetupFailures() + Helper.cr());
                log.write(indentationString + "Total Time: " + this.getTotalTime() + Helper.cr());
                log.write(indentationString + "Total Tests: " + this.getTotalTests() + Helper.cr() + Helper.cr());
                log.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void logRegressionResult(Writer log) {
        String indentationString = this.getTestCollection().getIndentationString();
        try {
            if (this.didSetupFail()) {
                log.write(indentationString + Helper.cr() + "## SETUP FAILURE: " + Helper.cr() + this.getSetupException() + Helper.cr());
                PrintWriter printWriter = new PrintWriter(log);
                this.getSetupException().printStackTrace(printWriter);
                log.flush();
            } else {
                if (this.getErrors() > 0 || this.getFatalErrors() > 0 || this.getProblems() > 0) {
                    log.write(indentationString + "###ERRORS###" + Helper.cr());
                }
                log.write(indentationString + "Problems: " + this.getProblems() + Helper.cr());
                log.write(indentationString + "Errors: " + this.getErrors() + Helper.cr());
                log.write(indentationString + "Fatal Errors: " + this.getFatalErrors() + Helper.cr());
                log.write(indentationString + "Setup Failures: " + this.getSetupFailures() + Helper.cr() + Helper.cr());
                log.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void resetTotals() {
        this.setResults(new Vector<TestResult>());
        this.setPassed(0);
        this.setWarnings(0);
        this.setErrors(0);
        this.setFatalErrors(0);
        this.setSetupFailures(0);
        this.setSetupWarnings(0);
        this.setTotalTests(0);
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
    }

    public void setErrors(int anError) {
        this.errors = anError;
    }

    public void setFatalErrors(int theFatalError) {
        this.fatalErrors = theFatalError;
    }

    public void setId(BigDecimal anId) {
        this.id = anId;
    }

    public void setLoadBuildSummary(LoadBuildSummary summary) {
        this.loadBuildSummary.setValue((Object)summary);
    }

    public void setLoadBuildSummaryHolder(ValueHolderInterface<LoadBuildSummary> holder) {
        this.loadBuildSummary = holder;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void setParent(TestResultsSummary result) {
        this.parent.setValue((Object)result);
    }

    public void setParentHolder(ValueHolderInterface<TestResultsSummary> holder) {
        this.parent = holder;
    }

    public void setPassed(int thePassed) {
        this.passed = thePassed;
    }

    public void setProblems(int theProblem) {
        this.problems = theProblem;
    }

    public void setResults(Vector<TestResult> theResults) {
        this.results.setValue(theResults);
    }

    public void setResultsHolder(ValueHolderInterface<Vector<TestResult>> holder) {
        this.results = holder;
    }

    public void setSetupException(Throwable setupException) {
        this.setupException = setupException;
    }

    public void setSetupExceptionStackTrace(String stackTrace) {
        if (stackTrace != null && this.setupException != null) {
            this.setupException = new Exception(stackTrace);
        }
    }

    public void setTestCollection(TestCollection testCollection) {
        this.testCollection = testCollection;
    }

    public void settName(String aName) {
        this.name = aName;
    }

    public void setTotalTests(int tests) {
        this.totalTests = tests;
    }

    public void setWarnings(int theWarnings) {
        this.warnings = theWarnings;
    }
}

