/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.tinybundles.core.intern;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.ops4j.lang.Ops4jException;
import org.ops4j.pax.tinybundles.core.BuildStrategy;
import org.ops4j.pax.tinybundles.core.InnerClassStrategy;
import org.ops4j.pax.tinybundles.core.TinyBundle;
import org.ops4j.pax.tinybundles.core.TinyBundles;
import org.ops4j.pax.tinybundles.finder.ClassDescriptor;
import org.ops4j.pax.tinybundles.finder.ClassFinder;
import org.ops4j.store.Store;

public class TinyBundleImpl
implements TinyBundle {
    private Map<String, URL> m_resources = new HashMap<String, URL>();
    private Map<String, String> m_headers = new HashMap<String, String>();
    private final Store<InputStream> m_store;

    public TinyBundleImpl(Store<InputStream> bstore) {
        this.m_store = bstore;
    }

    @Override
    public TinyBundle read(InputStream in, boolean readData) {
        if (in != null) {
            try {
                JarInputStream jarOut = new JarInputStream(in);
                Manifest manifest = jarOut.getManifest();
                Attributes att = manifest.getMainAttributes();
                for (Object o : att.keySet()) {
                    String k = o.toString();
                    String v = att.getValue(k);
                    this.set(k, v);
                }
                if (readData) {
                    JarEntry entry = null;
                    while ((entry = jarOut.getNextJarEntry()) != null) {
                        this.add(entry.getName(), jarOut);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Problem loading bundle.", e);
            }
        }
        return this;
    }

    @Override
    public TinyBundle read(InputStream in) {
        return this.read(in, true);
    }

    @Override
    public TinyBundle add(Class<?> clazz) {
        this.add(clazz, InnerClassStrategy.ALL);
        return this;
    }

    @Override
    public TinyBundle add(Class<?> clazz, InnerClassStrategy strategy) {
        Collection<ClassDescriptor> embeddedClasses;
        block6: {
            String name = ClassFinder.asResource(clazz);
            URL resource = clazz.getResource("/" + name);
            if (resource == null) {
                throw new IllegalArgumentException("Class " + clazz.getName() + " not found! (resource: " + name + " )");
            }
            this.add(name, resource);
            try {
                ClassFinder finder = new ClassFinder();
                if (strategy == InnerClassStrategy.ALL) {
                    embeddedClasses = finder.findAllEmbeddedClasses(clazz);
                    break block6;
                }
                if (strategy == InnerClassStrategy.ANONYMOUS) {
                    embeddedClasses = finder.findAnonymousClasses(clazz);
                    break block6;
                }
                return this;
            }
            catch (IOException exc) {
                throw new Ops4jException((Throwable)exc);
            }
        }
        for (ClassDescriptor descriptor : embeddedClasses) {
            this.m_resources.put(descriptor.getResourcePath(), descriptor.getUrl());
        }
        return this;
    }

    @Override
    public TinyBundle remove(Class<?> content) {
        String name = ClassFinder.asResource(content);
        this.removeResource(name);
        return this;
    }

    @Override
    public TinyBundle add(String name, URL url) {
        this.m_resources.put(name, url);
        return this;
    }

    @Override
    public TinyBundle add(String name, InputStream content) {
        try {
            return this.add(name, this.m_store.getLocation(this.m_store.store((Object)content)).toURL());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream build() {
        return TinyBundles.withClassicBuilder().build(this.m_resources, this.m_headers);
    }

    @Override
    public InputStream build(BuildStrategy builder) {
        return builder.build(this.m_resources, this.m_headers);
    }

    @Override
    public TinyBundle set(String key, String value) {
        this.m_headers.put(key, value);
        return this;
    }

    @Override
    public TinyBundle removeResource(String key) {
        this.m_resources.remove(key);
        return this;
    }

    @Override
    public TinyBundle removeHeader(String key) {
        this.m_headers.remove(key);
        return this;
    }

    @Override
    public String getHeader(String key) {
        return this.m_headers.get(key);
    }
}

