/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.impl;

import ch.ethz.iks.r_osgi.RemoteServiceReference;
import ch.ethz.iks.r_osgi.URI;
import ch.ethz.iks.r_osgi.impl.ChannelEndpointImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;

final class RemoteServiceReferenceImpl
implements RemoteServiceReference {
    private static final long serialVersionUID = 1340731053890522970L;
    private final String[] serviceInterfaces;
    private Dictionary properties;
    private final URI uri;
    private final ChannelEndpointImpl channel;

    RemoteServiceReferenceImpl(String[] serviceInterfaces, String serviceID, Dictionary properties, ChannelEndpointImpl channel) {
        this.serviceInterfaces = serviceInterfaces;
        this.properties = properties;
        this.uri = channel.getRemoteAddress().resolve("#" + serviceID);
        this.properties = properties;
        this.channel = channel;
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public String[] getPropertyKeys() {
        ArrayList result = new ArrayList(this.properties.size());
        Enumeration e = this.properties.keys();
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        return result.toArray(new String[this.properties.size()]);
    }

    @Override
    public String[] getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    ChannelEndpointImpl getChannel() {
        return this.channel;
    }

    Dictionary getProperties() {
        return this.properties;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    void setProperties(Dictionary newProps) {
        this.properties = newProps;
    }

    @Override
    public boolean isActive() {
        return this.channel.isConnected() && this.channel.isActive(this.uri.toString());
    }

    boolean isOSGiAsync() {
        return this.getProperty("osgi.async") != null;
    }

    public String toString() {
        return "RemoteServiceReference{" + String.valueOf(this.uri) + "-" + String.valueOf(Arrays.asList(this.serviceInterfaces)) + "}";
    }
}

