/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.factory.bag.primitive.MutableBooleanBagFactory;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.factory.primitive.BooleanBags;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableBooleanBagFactoryImpl implements MutableBooleanBagFactory
{
    INSTANCE;


    public MutableBooleanBag empty() {
        return new BooleanHashBag();
    }

    public MutableBooleanBag of() {
        return this.empty();
    }

    public MutableBooleanBag with() {
        return this.empty();
    }

    public MutableBooleanBag of(boolean ... items) {
        return this.with(items);
    }

    public MutableBooleanBag with(boolean ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return BooleanHashBag.newBagWith(items);
    }

    public MutableBooleanBag ofAll(BooleanIterable items) {
        return this.withAll(items);
    }

    public MutableBooleanBag withAll(BooleanIterable items) {
        return BooleanHashBag.newBag(items);
    }

    public MutableBooleanBag ofAll(Iterable<Boolean> iterable) {
        return this.withAll(iterable);
    }

    public MutableBooleanBag withAll(Iterable<Boolean> iterable) {
        return Iterate.collectBoolean(iterable, Boolean::booleanValue, BooleanBags.mutable.empty());
    }
}

