/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.collection.factory.mapdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.serializer.SerializerBoolean;
import org.mapdb.serializer.SerializerIntegerPacked;

class BindingSetSerializer
implements Serializer<BindingSet> {
    private final LinkedHashSet<String> names = new LinkedHashSet();
    private final List<Predicate<BindingSet>> has = new ArrayList<Predicate<BindingSet>>();
    private final List<Function<BindingSet, Value>> get = new ArrayList<Function<BindingSet, Value>>();
    private final List<BiConsumer<Value, MutableBindingSet>> set = new ArrayList<BiConsumer<Value, MutableBindingSet>>();
    private final Serializer<Value> vs;
    private final SerializerBoolean sb = new SerializerBoolean();
    private final SerializerIntegerPacked si = new SerializerIntegerPacked();
    private final Supplier<MutableBindingSet> create;
    private final Function<String, Predicate<BindingSet>> getHas;
    private final Function<String, Function<BindingSet, Value>> getGet;
    private final Function<String, BiConsumer<Value, MutableBindingSet>> getSet;

    public BindingSetSerializer(Serializer<Value> valueSerializer, Supplier<MutableBindingSet> create, Function<String, Predicate<BindingSet>> getHas, Function<String, Function<BindingSet, Value>> getGet, Function<String, BiConsumer<Value, MutableBindingSet>> getSet) {
        this.vs = valueSerializer;
        this.create = create;
        this.getHas = getHas;
        this.getGet = getGet;
        this.getSet = getSet;
    }

    public void serialize(DataOutput2 out, BindingSet bs) throws IOException {
        int i;
        Set bindingNames = bs.getBindingNames();
        if (this.names.addAll(bindingNames)) {
            Iterator nameI = this.names.iterator();
            for (i = this.has.size(); nameI.hasNext() && i > 0; --i) {
            }
            while (nameI.hasNext()) {
                String name = (String)nameI.next();
                this.has.add(this.getHas.apply(name));
                this.get.add(this.getGet.apply(name));
                this.set.add(this.getSet.apply(name));
            }
        }
        for (i = 0; i < this.has.size(); ++i) {
            if (!this.has.get(i).test(bs)) continue;
            this.sb.serialize(out, Boolean.valueOf(true));
            this.si.serialize(out, Integer.valueOf(i));
            this.vs.serialize(out, (Object)this.get.get(i).apply(bs));
        }
        this.sb.serialize(out, Boolean.valueOf(false));
    }

    public BindingSet deserialize(DataInput2 input, int available) throws IOException {
        boolean hasMore = this.sb.deserialize(input, available);
        MutableBindingSet bs = this.create.get();
        while (hasMore) {
            int nextName = this.si.deserialize(input, available);
            Value nextValue = (Value)this.vs.deserialize(input, available);
            this.set.get(nextName).accept(nextValue, bs);
            hasMore = this.sb.deserialize(input, available);
        }
        return bs;
    }
}

