/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleLongMapFactory;
import org.eclipse.collections.api.map.primitive.DoubleLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleLongMap;
import org.eclipse.collections.impl.factory.primitive.DoubleLongMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleLongEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleLongHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleLongSingletonMap;

public enum ImmutableDoubleLongMapFactoryImpl implements ImmutableDoubleLongMapFactory
{
    INSTANCE;


    public ImmutableDoubleLongMap empty() {
        return ImmutableDoubleLongEmptyMap.INSTANCE;
    }

    public ImmutableDoubleLongMap of() {
        return this.empty();
    }

    public ImmutableDoubleLongMap with() {
        return this.empty();
    }

    public ImmutableDoubleLongMap of(double key, long value) {
        return this.with(key, value);
    }

    public ImmutableDoubleLongMap with(double key, long value) {
        return new ImmutableDoubleLongSingletonMap(key, value);
    }

    public ImmutableDoubleLongMap ofAll(DoubleLongMap map) {
        return this.withAll(map);
    }

    public ImmutableDoubleLongMap withAll(DoubleLongMap map) {
        if (map instanceof ImmutableDoubleLongMap) {
            return (ImmutableDoubleLongMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            double key = map.keysView().doubleIterator().next();
            return new ImmutableDoubleLongSingletonMap(key, map.get(key));
        }
        return new ImmutableDoubleLongHashMap(map);
    }

    public <T> ImmutableDoubleLongMap from(Iterable<T> iterable, DoubleFunction<? super T> keyFunction, LongFunction<? super T> valueFunction) {
        return DoubleLongMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

