/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;

public class SPARQLMinusIteration
extends FilterIteration<BindingSet> {
    private final CloseableIteration<BindingSet> rightArg;
    private boolean initialized;
    private Set<BindingSet> excludeSet;
    private Set<String> excludeSetBindingNames;
    private boolean excludeSetBindingNamesAreAllTheSame;
    private BindingSet[] excludeSetList;
    private Map<String, Map<Value, BindingSet[]>> rightIndex;

    public SPARQLMinusIteration(CloseableIteration<BindingSet> leftArg, CloseableIteration<BindingSet> rightArg) {
        super(leftArg);
        assert (rightArg != null);
        this.rightArg = rightArg;
        this.initialized = false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean accept(BindingSet bindingSet) {
        if (!this.initialized) {
            void var5_8;
            this.excludeSet = this.makeSet(this.getRightArg());
            this.excludeSetList = this.excludeSet.toArray(new BindingSet[0]);
            this.excludeSetBindingNames = this.excludeSet.stream().map(BindingSet::getBindingNames).flatMap(Collection::stream).collect(Collectors.toSet());
            this.excludeSetBindingNamesAreAllTheSame = this.excludeSet.stream().allMatch(b -> {
                Set bindingNames = b.getBindingNames();
                if (bindingNames.size() == this.excludeSetBindingNames.size()) {
                    return bindingNames.containsAll(this.excludeSetBindingNames);
                }
                return false;
            });
            HashMap<String, HashMap> tmpIndex = new HashMap<String, HashMap>();
            BindingSet[] bindingSetArray = this.excludeSetList;
            int n = bindingSetArray.length;
            boolean bl = false;
            while (var5_8 < n) {
                BindingSet bs = bindingSetArray[var5_8];
                for (String string : bs.getBindingNames()) {
                    Value v = bs.getValue(string);
                    if (v == null) continue;
                    tmpIndex.computeIfAbsent(string, k -> new HashMap()).computeIfAbsent(v, k -> new ArrayList()).add(bs);
                }
                ++var5_8;
            }
            HashMap<String, Map<Value, BindingSet[]>> built = new HashMap<String, Map<Value, BindingSet[]>>(tmpIndex.size() * 2);
            for (Map.Entry entry : tmpIndex.entrySet()) {
                HashMap inner = new HashMap(((HashMap)entry.getValue()).size() * 2);
                for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                    inner.put((Value)entry2.getKey(), ((ArrayList)entry2.getValue()).toArray(new BindingSet[0]));
                }
                built.put((String)entry.getKey(), inner);
            }
            this.rightIndex = built;
            this.initialized = true;
        }
        Set bindingNames = bindingSet.getBindingNames();
        boolean hasSharedBindings = false;
        if (!this.excludeSetBindingNames.isEmpty()) {
            Set left = bindingNames;
            Set<String> set = this.excludeSetBindingNames;
            if (left.size() <= set.size()) {
                for (String name : left) {
                    if (!set.contains(name)) continue;
                    hasSharedBindings = true;
                    break;
                }
            } else {
                for (String name : set) {
                    if (!left.contains(name)) continue;
                    hasSharedBindings = true;
                    break;
                }
            }
        }
        if (!hasSharedBindings) {
            return true;
        }
        if (this.rightIndex != null && !this.rightIndex.isEmpty()) {
            for (String string : bindingNames) {
                BindingSet[] bindingSetArray;
                Map<Value, BindingSet[]> byValue;
                Value leftVal = bindingSet.getValue(string);
                if (leftVal == null || (byValue = this.rightIndex.get(string)) == null || (bindingSetArray = byValue.get(leftVal)) == null) continue;
                for (int j = 0; j < bindingSetArray.length; ++j) {
                    BindingSet excluded = bindingSetArray[j];
                    if (!excluded.isCompatible(bindingSet)) continue;
                    return false;
                }
            }
            return true;
        }
        for (BindingSet excluded : this.excludeSetList) {
            if (!this.excludeSetBindingNamesAreAllTheSame) {
                hasSharedBindings = false;
                Set set = excluded.getBindingNames();
                if (bindingNames.size() <= set.size()) {
                    for (String name : bindingNames) {
                        if (!set.contains(name)) continue;
                        hasSharedBindings = true;
                        break;
                    }
                } else {
                    for (String name : set) {
                        if (!bindingNames.contains(name)) continue;
                        hasSharedBindings = true;
                        break;
                    }
                }
            }
            if (!hasSharedBindings || !excluded.isCompatible(bindingSet)) continue;
            return false;
        }
        return true;
    }

    protected Set<BindingSet> makeSet() {
        return new LinkedHashSet<BindingSet>();
    }

    protected Set<String> makeSet(Set<String> set) {
        return new HashSet<String>(set);
    }

    protected Set<BindingSet> makeSet(CloseableIteration<BindingSet> rightArg) {
        return Iterations.asSet(rightArg);
    }

    protected void handleClose() {
        if (this.rightArg != null) {
            this.rightArg.close();
        }
    }

    protected CloseableIteration<BindingSet> getRightArg() {
        return this.rightArg;
    }

    protected long clearExcludeSet() {
        int size = this.excludeSet.size();
        this.excludeSet.clear();
        return size;
    }
}

