/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.platform.internal.commands;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.platform.commands.ListPlugins;
import org.eclipse.rcptt.ecl.platform.internal.PlatformPlugin;
import org.eclipse.rcptt.ecl.platform.objects.ObjectsFactory;
import org.eclipse.rcptt.ecl.platform.objects.Plugin;
import org.eclipse.rcptt.ecl.platform.objects.PluginState;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.osgi.framework.Bundle;

public class ListPluginsService
implements ICommandService {
    private static final Map<Integer, PluginState> pluginStateLookup = new HashMap<Integer, PluginState>();

    static {
        pluginStateLookup.put(1, PluginState.UNINSTALLED);
        pluginStateLookup.put(2, PluginState.INSTALLED);
        pluginStateLookup.put(4, PluginState.RESOLVED);
        pluginStateLookup.put(8, PluginState.STARTING);
        pluginStateLookup.put(16, PluginState.STOPPING);
        pluginStateLookup.put(32, PluginState.ACTIVE);
    }

    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        ListPlugins cmd = (ListPlugins)command;
        boolean includeDeps = cmd.isIncludeDependencies();
        State platformState = includeDeps ? Platform.getPlatformAdmin().getState() : null;
        Bundle[] bundleArray = PlatformPlugin.getDefault().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            Plugin plugin = ObjectsFactory.eINSTANCE.createPlugin();
            plugin.setId(bundle.getSymbolicName());
            plugin.setVersion(bundle.getVersion().toString());
            plugin.setName((String)bundle.getHeaders().get("Bundle-Name"));
            PluginState state = pluginStateLookup.get(bundle.getState());
            if (state != null) {
                plugin.setState(state);
            }
            if (includeDeps) {
                platformState = Platform.getPlatformAdmin().getState();
                BundleDescription bundleDesc = platformState.getBundle(bundle.getBundleId());
                ImportPackageSpecification[] imports = bundleDesc.getImportPackages();
                EList<String> eimports = plugin.getImportedPackages();
                ImportPackageSpecification[] importPackageSpecificationArray = imports;
                int n3 = imports.length;
                int n4 = 0;
                while (n4 < n3) {
                    ImportPackageSpecification p = importPackageSpecificationArray[n4];
                    eimports.add((Object)p.getName());
                    ++n4;
                }
                BundleSpecification[] required = bundleDesc.getRequiredBundles();
                EList<String> erequired = plugin.getRequiredBundles();
                BundleSpecification[] bundleSpecificationArray = required;
                int n5 = required.length;
                int n6 = 0;
                while (n6 < n5) {
                    BundleSpecification b = bundleSpecificationArray[n6];
                    erequired.add((Object)b.getName());
                    ++n6;
                }
            }
            context.getOutput().write((Object)plugin);
            ++n2;
        }
        context.getOutput().close(Status.OK_STATUS);
        return Status.OK_STATUS;
    }
}

