/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner.util;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.reporting.core.IReportRenderer;
import org.eclipse.rcptt.reporting.html.HtmlReportRenderer;
import org.eclipse.rcptt.reporting.html.HtmlReporter;
import org.eclipse.rcptt.reporting.util.FileContentFactory;
import org.eclipse.rcptt.reporting.util.JUnitFileReportGenerator;
import org.eclipse.rcptt.reporting.util.Q7ReportIterator;
import org.eclipse.rcptt.runner.HeadlessRunner;
import org.eclipse.rcptt.runner.HeadlessRunnerPlugin;
import org.eclipse.rcptt.runner.RunnerConfiguration;
import org.eclipse.rcptt.runner.util.IReporter;

public class Reporter
implements IReporter {
    public boolean displayTimeoutMessage = false;

    public void report(Q7ReportIterator reportIterator, HeadlessRunner caller, RunnerConfiguration conf) {
        if (reportIterator != null) {
            if (conf.htmlReportLocation != null) {
                if (conf.splitHTMLReport) {
                    this.createReport(HtmlReporter.class, reportIterator, conf.htmlReportLocation);
                } else {
                    this.createReport(HtmlReportRenderer.class, reportIterator, conf.htmlReportLocation);
                }
            }
            if (conf.junitReportLocation != null) {
                this.createReport(JUnitFileReportGenerator.class, reportIterator, conf.junitReportLocation);
            }
            if (conf.report != null) {
                Path filePath = new Path(conf.report.path);
                conf.report.renderer.getRenderer().generateReport((IReportRenderer.IContentFactory)new FileContentFactory(filePath.removeLastSegments(1)), Reporter.noExt(filePath.lastSegment()), (Iterable)reportIterator);
            }
        }
        if (this.displayTimeoutMessage) {
            System.out.println("\n\nTimeout is happen during execution. Not all test are executed.\nPlease increase value of timeout passed with '-timeout' command line argument.\nCurrent timeout value is: " + conf.executionTimeout + " seconds.");
        }
    }

    @Override
    public void createReport(Class<? extends IReportRenderer> rendererClass, Q7ReportIterator report, String outFile) {
        IReportRenderer renderer;
        try {
            renderer = rendererClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Reporter.log("Error creating renderer", e);
            return;
        }
        this.createReport(renderer, report, outFile);
    }

    @Override
    public void createReport(IReportRenderer renderer, Q7ReportIterator report, String outFile) {
        IPath filePath = Path.fromOSString((String)outFile);
        renderer.generateReport((IReportRenderer.IContentFactory)new FileContentFactory(filePath.removeLastSegments(1)), Reporter.noExt(filePath.lastSegment()), (Iterable)report);
    }

    public static void log(String message, Exception e) {
        HeadlessRunnerPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.rcptt.runner", message, (Throwable)e));
    }

    private static String noExt(String name) {
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return name;
        }
        return name.substring(0, dotIndex);
    }
}

