/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import aQute.bnd.build.Workspace;
import aQute.bnd.service.RepositoryListenerPlugin;
import aQute.bnd.service.clipboard.Clipboard;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.pde.core.IClasspathContributor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.ClasspathContainerResolverManager;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.JavaElementChangeListener;
import org.eclipse.pde.internal.core.JavadocLocationManager;
import org.eclipse.pde.internal.core.PDEExtensionRegistry;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.SearchablePluginsManager;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.TargetDefinitionManager;
import org.eclipse.pde.internal.core.TracingOptionsManager;
import org.eclipse.pde.internal.core.bnd.BndResourceChangeListener;
import org.eclipse.pde.internal.core.bnd.BndWorkspaceServiceFactory;
import org.eclipse.pde.internal.core.builders.FeatureRebuilder;
import org.eclipse.pde.internal.core.builders.PluginRebuilder;
import org.eclipse.pde.internal.core.project.BundleProjectService;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class PDECore
extends Plugin
implements DebugOptionsListener {
    public static final String PLUGIN_ID = "org.eclipse.pde.core";
    public static final IPath REQUIRED_PLUGINS_CONTAINER_PATH = IPath.fromOSString((String)"org.eclipse.pde.core.requiredPlugins");
    public static final IPath JAVA_SEARCH_CONTAINER_PATH = IPath.fromOSString((String)"org.eclipse.pde.core.externalJavaSearch");
    public static final IPath JRE_CONTAINER_PATH = IPath.fromOSString((String)JavaRuntime.JRE_CONTAINER);
    public static final String BINARY_PROJECT_VALUE = "binary";
    public static final String BINARY_REPOSITORY_PROVIDER = "org.eclipse.pde.core.BinaryRepositoryProvider";
    public static final QualifiedName EXTERNAL_PROJECT_PROPERTY = new QualifiedName("org.eclipse.pde.core", "imported");
    public static final QualifiedName TOUCH_PROJECT = new QualifiedName("org.eclipse.pde.core", "TOUCH_PROJECT");
    public static final QualifiedName BND_CLASSPATH_INSTRUCTION_FILE = new QualifiedName("org.eclipse.pde.core", "BND_CLASSPATH_PROJECT");
    public static final QualifiedName SCHEMA_PREVIEW_FILE = new QualifiedName("org.eclipse.pde.core", "SCHEMA_PREVIEW_FILE");
    public static boolean DEBUG_CLASSPATH = false;
    public static boolean DEBUG_MODEL = false;
    public static boolean DEBUG_TARGET_PROFILE = false;
    public static boolean DEBUG_VALIDATION = false;
    private static final String DEBUG_FLAG = "org.eclipse.pde.core/debug";
    private static final String CLASSPATH_DEBUG = "org.eclipse.pde.core/classpath";
    private static final String MODEL_DEBUG = "org.eclipse.pde.core/model";
    private static final String TARGET_PROFILE_DEBUG = "org.eclipse.pde.core/target/profile";
    private static final String VALIDATION_DEBUG = "org.eclipse.pde.core/validation";
    private static PDECore inst;
    private static PDEExtensionRegistry fExtensionRegistry;
    private static PDEPreferencesManager fPreferenceManager;
    private Map<String, IPluginModelBase> fHostPlugins;
    private FeatureModelManager fFeatureModelManager;
    private TargetDefinitionManager fTargetProfileManager;
    private SchemaRegistry fSchemaRegistry;
    private SourceLocationManager fSourceLocationManager;
    private JavadocLocationManager fJavadocLocationManager;
    private SearchablePluginsManager fSearchablePluginsManager;
    private ClasspathContainerResolverManager fClasspathContainerResolverManager;
    private TracingOptionsManager fTracingOptionsManager;
    private BundleContext fBundleContext;
    private JavaElementChangeListener fJavaElementChangeListener;
    private FeatureRebuilder fFeatureRebuilder;
    private PluginRebuilder fPluginRebuilder;
    private ServiceRegistration<ITargetPlatformService> fTargetPlatformService;
    private ServiceRegistration<IBundleProjectService> fBundleProjectService;
    private BndResourceChangeListener bndResourceChangeListener;
    private ServiceTracker<IClasspathContributor, IClasspathContributor> classpathContributorServiceTracker;
    private ServiceTracker<Clipboard, Clipboard> clipBoardsServiceTracker;
    private ServiceTracker<RepositoryListenerPlugin, RepositoryListenerPlugin> repositoryListenerServiceTracker;

    static {
        fExtensionRegistry = null;
    }

    public static PDECore getDefault() {
        return inst;
    }

    public synchronized PDEPreferencesManager getPreferencesManager() {
        if (fPreferenceManager == null) {
            fPreferenceManager = new PDEPreferencesManager(PLUGIN_ID);
        }
        return fPreferenceManager;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(IStatus status) {
        if (status != null) {
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException || e.getMessage() != null) {
            status = Status.error((String)e.getMessage(), (Throwable)e);
        }
        PDECore.log(status);
    }

    public static void logErrorMessage(String message) {
        PDECore.log(Status.error((String)message));
    }

    public static void logException(Throwable e) {
        PDECore.logException(e, null);
    }

    public static void logException(Throwable e, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = Status.error((String)message, (Throwable)e);
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = Status.error((String)message, (Throwable)e);
        }
        PDECore.log(status);
    }

    public PDECore() {
        inst = this;
    }

    public synchronized IPluginModelBase findPluginInHost(String id) {
        if (this.fHostPlugins == null) {
            this.fHostPlugins = new HashMap<String, IPluginModelBase>();
            ITargetDefinition defaultTarget = TargetPlatformService.getDefault().newDefaultTarget();
            IStatus status = defaultTarget.resolve((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                PDECore.log(status);
                return null;
            }
            URI[] pluginPaths = (URI[])Arrays.stream(defaultTarget.getBundles()).filter(b -> !b.isSourceBundle()).map(b -> b.getBundleInfo().getLocation()).toArray(URI[]::new);
            PDEState state = new PDEState(pluginPaths, true, false, (IProgressMonitor)new NullProgressMonitor());
            state.resolveState(false);
            IPluginModelBase[] iPluginModelBaseArray = state.getTargetModels();
            int n = iPluginModelBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase plugin = iPluginModelBaseArray[n2];
                this.fHostPlugins.put(plugin.getPluginBase().getId(), plugin);
                ++n2;
            }
        }
        return this.fHostPlugins.get(id);
    }

    public PluginModelManager getModelManager() {
        return PluginModelManager.getInstance();
    }

    public synchronized TargetDefinitionManager getTargetProfileManager() {
        if (this.fTargetProfileManager == null) {
            this.fTargetProfileManager = new TargetDefinitionManager();
        }
        return this.fTargetProfileManager;
    }

    public synchronized FeatureModelManager getFeatureModelManager() {
        if (this.fFeatureModelManager == null) {
            this.fFeatureModelManager = new FeatureModelManager();
        }
        return this.fFeatureModelManager;
    }

    public JavaElementChangeListener getJavaElementChangeListener() {
        return this.fJavaElementChangeListener;
    }

    public synchronized SchemaRegistry getSchemaRegistry() {
        if (this.fSchemaRegistry == null) {
            this.fSchemaRegistry = new SchemaRegistry();
        }
        return this.fSchemaRegistry;
    }

    public synchronized PDEExtensionRegistry getExtensionsRegistry() {
        if (fExtensionRegistry == null) {
            fExtensionRegistry = new PDEExtensionRegistry();
        }
        return fExtensionRegistry;
    }

    public synchronized SourceLocationManager getSourceLocationManager() {
        if (this.fSourceLocationManager == null) {
            this.fSourceLocationManager = new SourceLocationManager();
        }
        return this.fSourceLocationManager;
    }

    public synchronized ClasspathContainerResolverManager getClasspathContainerResolverManager() {
        if (this.fClasspathContainerResolverManager == null) {
            this.fClasspathContainerResolverManager = new ClasspathContainerResolverManager();
        }
        return this.fClasspathContainerResolverManager;
    }

    public synchronized JavadocLocationManager getJavadocLocationManager() {
        if (this.fJavadocLocationManager == null) {
            this.fJavadocLocationManager = new JavadocLocationManager();
        }
        return this.fJavadocLocationManager;
    }

    public synchronized TracingOptionsManager getTracingOptionsManager() {
        if (this.fTracingOptionsManager == null) {
            this.fTracingOptionsManager = new TracingOptionsManager();
        }
        return this.fTracingOptionsManager;
    }

    public synchronized SearchablePluginsManager getSearchablePluginsManager() {
        if (this.fSearchablePluginsManager == null) {
            this.fSearchablePluginsManager = new SearchablePluginsManager();
        }
        return this.fSearchablePluginsManager;
    }

    public boolean areModelsInitialized() {
        return this.getModelManager().isInitialized();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fBundleContext = context;
        this.fJavaElementChangeListener = new JavaElementChangeListener();
        this.fJavaElementChangeListener.start();
        this.fPluginRebuilder = new PluginRebuilder();
        this.fPluginRebuilder.start();
        this.fFeatureRebuilder = new FeatureRebuilder();
        this.fFeatureRebuilder.start();
        this.fTargetPlatformService = context.registerService(ITargetPlatformService.class, (Object)TargetPlatformService.getDefault(), new Hashtable());
        this.fBundleProjectService = context.registerService(IBundleProjectService.class, (Object)BundleProjectService.getDefault(), new Hashtable());
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("listener.symbolic.name", PLUGIN_ID);
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addSaveParticipant(PLUGIN_ID, new ISaveParticipant(){

            public void saving(ISaveContext saveContext) {
                try {
                    P2TargetUtils.cleanOrphanedTargetDefinitionProfiles();
                }
                catch (CoreException e) {
                    PDECore.this.getLog().warn("Can't cleanup orphaned target definition profiles, will retry later.", (Throwable)e);
                }
            }

            public void rollback(ISaveContext saveContext) {
            }

            public void prepareToSave(ISaveContext saveContext) throws CoreException {
            }

            public void doneSaving(ISaveContext saveContext) {
            }
        });
        this.bndResourceChangeListener = new BndResourceChangeListener();
        workspace.addResourceChangeListener((IResourceChangeListener)this.bndResourceChangeListener);
        this.fBundleContext.registerService(Workspace.class, (ServiceFactory)new BndWorkspaceServiceFactory(), FrameworkUtil.asDictionary(Map.of("service.ranking", -10)));
    }

    public BundleContext getBundleContext() {
        return this.fBundleContext;
    }

    public void stop(BundleContext context) throws CoreException {
        if (fPreferenceManager != null) {
            fPreferenceManager.savePluginPreferences();
        }
        this.fJavaElementChangeListener.shutdown();
        this.fPluginRebuilder.stop();
        this.fFeatureRebuilder.stop();
        if (this.fSchemaRegistry != null) {
            this.fSchemaRegistry.shutdown();
            this.fSchemaRegistry = null;
        }
        if (this.fTargetProfileManager != null) {
            this.fTargetProfileManager.shutdown();
            this.fTargetProfileManager = null;
        }
        if (this.fSearchablePluginsManager != null) {
            this.fSearchablePluginsManager.shutdown();
            this.fSearchablePluginsManager = null;
        }
        if (this.fFeatureModelManager != null) {
            this.fFeatureModelManager.shutdown();
            this.fFeatureModelManager = null;
        }
        if (fExtensionRegistry != null) {
            fExtensionRegistry.stop();
            fExtensionRegistry = null;
        }
        PluginModelManager.shutdownInstance();
        if (this.fTargetPlatformService != null) {
            this.fTargetPlatformService.unregister();
            this.fTargetPlatformService = null;
        }
        if (this.fBundleProjectService != null) {
            this.fBundleProjectService.unregister();
            this.fBundleProjectService = null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeSaveParticipant(PLUGIN_ID);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.bndResourceChangeListener);
    }

    public <T> T acquireService(Class<T> serviceClass) {
        ServiceReference reference = this.fBundleContext.getServiceReference(serviceClass);
        if (reference == null) {
            return null;
        }
        Object service = this.fBundleContext.getService(reference);
        if (service != null) {
            this.fBundleContext.ungetService(reference);
        }
        return (T)service;
    }

    public void optionsChanged(DebugOptions options) {
        boolean DEBUG = options.getBooleanOption(DEBUG_FLAG, false);
        DEBUG_CLASSPATH = DEBUG && options.getBooleanOption(CLASSPATH_DEBUG, false);
        DEBUG_MODEL = DEBUG && options.getBooleanOption(MODEL_DEBUG, false);
        DEBUG_TARGET_PROFILE = DEBUG && options.getBooleanOption(TARGET_PROFILE_DEBUG, false);
        DEBUG_VALIDATION = DEBUG && options.getBooleanOption(VALIDATION_DEBUG, false);
    }

    public synchronized Stream<IClasspathContributor> getClasspathContributors() {
        if (this.fBundleContext == null) {
            return Stream.empty();
        }
        if (this.classpathContributorServiceTracker == null) {
            this.classpathContributorServiceTracker = new ServiceTracker(this.fBundleContext, IClasspathContributor.class, null);
            this.classpathContributorServiceTracker.open();
        }
        return this.classpathContributorServiceTracker.getTracked().values().stream();
    }

    public synchronized Clipboard getClipboardPlugin() {
        if (this.fBundleContext == null) {
            return null;
        }
        if (this.clipBoardsServiceTracker == null) {
            this.clipBoardsServiceTracker = new ServiceTracker(this.fBundleContext, Clipboard.class, null);
            this.clipBoardsServiceTracker.open();
        }
        return (Clipboard)this.clipBoardsServiceTracker.getService();
    }

    public synchronized Stream<RepositoryListenerPlugin> getRepositoryListenerPlugins() {
        if (this.fBundleContext == null) {
            return Stream.empty();
        }
        if (this.repositoryListenerServiceTracker == null) {
            this.repositoryListenerServiceTracker = new ServiceTracker(this.fBundleContext, RepositoryListenerPlugin.class, null);
            this.repositoryListenerServiceTracker.open();
        }
        return this.repositoryListenerServiceTracker.getTracked().values().stream();
    }
}

